/* File: CompleteUG.h */


#ifndef __CompleteUG_h__
#define __CompleteUG_h__


namespace BIOS
{
  /************************/
  /* CompleteUG DEFINITION */
  /************************/
  /**
          @memo CompleteUG 
   
  	@doc
   
      @author Maria Mar Abad Grau
  	@version 1.0
  */
// We wanted to use:
//template <class T>  typedef typename CompleteGraph<UndirectedArc, T> CompleteUG<T>;
// As Template Typedef is not allowed we use this trick

//class SimpleUTree;

template<class T, class U=int>
  struct CompleteUG
  {
    typedef CompleteGraph<UndirectedArc, T, U> Class;
  };

typedef CompleteUG<Node*, int>::Class SimpleCompleteUG;


// template <template<class T, class U=int> class Link, class T, class U> 
//class CompleteGraph;

/*_________________________________________________________________*/

//template <class T, class U> typename Tree<T, U>::Class* CompleteGraph<UndirectedArc, T, U>::getMWST()

template <> SimpleUTree* SimpleCompleteUG::getMWST()
  {// it should also be defined for each CompleteUG graph
    //Kruskal algorithm
// 1) create a forest "forest" (a set of trees), where each vertex in the graph is a separate tree
 Vector<SimpleUTree*>::Class::iterator tree1P, tree2P;
 Vector<SimpleUTree*>::Class *forest=new Vector<SimpleUTree*>::Class::Container();
 Vector<NodeSet*>::Class *forestListOfSetOfNodes=new Vector<NodeSet*>::Class::Container();
 SimpleUTree* uTree=NULL;
 Vector<NodeSet*>::Class::iterator nodeList1, nodeList2;
 Node* node=NULL;
 PNode pNode;
 for (NodeSet::const_iterator it=this->nodes->begin(); it!=this->nodes->end(); it++)
{
node=this->nodes->getElement(it)->clone();
uTree=new SimpleUTree::SingleAncestorGraph(node);
forest->insertElement(uTree);
forestListOfSetOfNodes->insertElement(uTree->nodes);
}
// 2) create a set "s" containing all the edges in the graph
 SimpleCompleteUG* s=this->clone();
 s->sort(true);
//cout << "s is: " << *s <<  "\n";
// 3) while s is nonempty and forest is not yet spanning: a) remove an edge with minimum weight from s b) if that edge connects two different trees in the forest, then add it to the forest, combining two trees into a single tree, otherwise discard that edge.
UndirectedArc<Node*,int>* arc=NULL;
//cout << "first before is: " << *forest->getFirstElement() << "\n";
while (forest->size()>1)
{
 arc=s->pop();
 nodeList1=forestListOfSetOfNodes->findElementContainingInternalElement(*arc->getFirst());
 nodeList2=forestListOfSetOfNodes->findElementContainingInternalElement(*arc->getSecond());
 tree1P=forest->getNode(forestListOfSetOfNodes->getPosition(nodeList1));
 tree2P=forest->getNode(forestListOfSetOfNodes->getPosition(nodeList2));
 pNode=forest->getElement(tree1P)->nodes->findElement(*arc->getFirst());
 if (tree1P!=tree2P) 
{
forest->getElement(tree2P)->setRoot(forest->getElement(tree2P)->nodes->findElement(*arc->getSecond()));
forest->getElement(tree1P)->addChild(pNode, arc->getWeight(), *tree2P);
forestListOfSetOfNodes->erase(nodeList2);
forest->erase(tree2P);
}
 zap(arc); 
}
//cout << "first after is: " << *forest->getFirstElement() << "\n";
SimpleUTree *result=forest->getFirstElement()->clone();
zap(s);
zap(forest);
return result;
 };
};  // Fin del Namespace
#endif

/* Fin Fichero: CompleteUG.h */
