/* File: BNC.cpp */


#ifndef __BNC_cpp__
#define __BNC_cpp__


#include "BNC.h"


//using namespace UTILS;


namespace BIOS
{

  /*____________________________________________________________________________________ */

  BNC::BNC(floatMLSample* sample, int classPosition, floatList* algorithm, VerbosityClass* verbosity, LossFunction* lossFunction):Classifier(sample, classPosition, algorithm, verbosity, lossFunction), GBN(sample, algorithm, verbosity, totalClasses)
  {
    };
  /*____________________________________________________________________________________ */

  BNC::BNC():Classifier(), GBN()
  {
  };

  /*____________________________________________________________________________________ */

  BNC::~BNC()
  {
  };
 /*____________________________________________________________________________________ */
/*
  float BNC::getSNPDistance(int att)
  {
//it actually returns (1-exp(-d)), with d in hundred kilobases

//cout <<"bayestype:" << bayesType <<", parents:" <<*parents[att];
if ((bayesType==BDistanceUniform)// || bayesType==BDistanceMarginal)
&& (!empty(parents[att]) && (parents[att]->size()==1)))
return sample->getSNPDistance(att, parents[att]->getFirstElement());
else cout << "Error in CPT:CPT, estimator " << bayesType << " is only allowed for NB";
return distance;
  }

/*____________________________________________________________________________________ */

/*
 void BNC::extractDistancesVector()
{
directMethod=false;
//positions=NULL;
//bayesType=MLE;
//alpha=0;


if (bayesType==BDistanceUniform || bayesType==BDistanceMarginal)
 Classifier::extractDistancesVector(3);
}
 
/*____________________________________________________________________________________ */
/*
  void BNC::set()
  {
  // GBN::set(); 
  // set();
//report();
//cout <<"ddd\n";
//printProbabilityTables(); 
if (GBN::verbosity.verbosityR.parameters) printProbabilityTables(); 
//cout <<"www\n";
   };
  /*____________________________________________________________________________________ */

  intList* BNC::getDiscretePattern(floatList* inputPattern, int totalClasses)
  {
try
{
       inputPattern->insertElementAtPos(totalClasses, classPosition);//frequired for sample->listOfAttributes->getDiscretePositions;


    intList* discreteInputPattern=sample->listOfAttributes->getDiscretePositions(inputPattern);

    inputPattern->removeNode(classPosition);
  //  discreteInputPattern->removeNode(classPosition);
    return(discreteInputPattern);
}
catch (BasicException& be){be.addMessage("\ncalled from intList* BNC::getDiscretePattern(floatList* inputPattern, int totalClasses)"); throw;};

  }
  /*____________________________________________________________________________________ */

  double* BNC::getClassFrequencies(floatList* inputPattern) 
  {
try
{
   intList* discreteInputPattern=getDiscretePattern(inputPattern, totalClasses);
    double* probs=getPosteriorProb(classPosition, discreteInputPattern);
zap(discreteInputPattern);
return probs;
}
catch (BasicException& be){be.addMessage("\ncalled from double* BNC::getClassFrequencies(floatList* inputPattern)"); throw;};
  }
  

  /*____________________________________________________________________________________ */

  void BNC::printCommonColumns(int att, int r, int totalRows)
  {
    Attribute* attribute=discreteSample->listOfAttributes->getElement(att);
    int totalAttModalidades=attribute->getTotalModalidades();

    cout <<"\t|";
    int pos, *positions;
    Prob freq;
//float alphaNumerator, alphaDenominator;

    for (int j=0;j<totalAttModalidades;j++)
    {
           pos=totalAttModalidades*r+j;
      pos=j*totalRows+r;
     positions=probTables[att]->getPositions(pos);
//alphaDenominator=getAlphaDenominator(att);
//alphaNumerator=getAlphaNumerator(att, j, alphaDenominator);

          freq=probTables[att]->getValue(positions);//, alphaNumerator, alphaDenominator);
    zaparr(positions);
       cout <<"|";
      if (empty(parents[att]))
      {
        	  cout << freq.print();
      //  cout <<"\t";
        printf("%0.3f", freq.convert());
       cout <<"\t";
      }
      else
      {
        if ((freq).isUndefined())
          cout <<"\t" << "---" <<"\t";
        else
        {
               cout << freq.print();
        //  cout <<"\t";
          printf("%0.3f", freq.convert());
          cout <<"\t";
        }
      }

    } // end for each comun
  }
  /*____________________________________________________________________________________ */

  void BNC::printHasParents(int att, int r)
  {
    int* positions=probTables[att]->getPositions(r), totalModalidades;
    Attribute* condAttribute;
    stringList* modalidades;
    floatList* valores;

    //////// conditionant attributes columns ///////

    for (int j=1;j<probTables[att]->getDimension();j++)
    {
      condAttribute=discreteSample->listOfAttributes->getElement(parents[att]->getElement(( int)j-1));
      if (!condAttribute->isContinuous())
        modalidades=condAttribute->getModalidades();
      else valores=condAttribute->getIntervals();
      totalModalidades=condAttribute->getTotalModalidades();
      cout <<"\t|";

      if (!condAttribute->isContinuous()) cout <<"\t" << modalidades->getElement(( int)positions[j]);
      else
      {
        if (positions[j]==0) cout << "\t]-,";
        else cout <<"\t" <<"[" << valores->getElement(( int)positions[j]-1) << ", ";
        if (positions[j]==totalModalidades-1) cout << "-[,";
        else cout <<"\t" << valores->getElement(( int)positions[j]) << "]";
      }
    } // end for each dimension
    zaparr(positions);
  }
  /*____________________________________________________________________________________ */

  void BNC::printHeading(int att)
  {
    int* positions=NULL;
    int* positions2=NULL;
    Attribute* attribute=discreteSample->listOfAttributes->getElement(att);
    int totalAttModalidades=attribute->getTotalModalidades();
    int totalColumns=totalAttModalidades;
    stringList* modalidades;
    floatList* valores;
    if (!empty(parents[att])) totalColumns=totalColumns+parents[att]->size();

    cout <<"\n\nProbability table for attribute " << attribute->getName() <<" (" << att+1 <<")\n\t";


    for (int j=0;j<totalColumns-totalAttModalidades;j++)
      cout << "|\t" << discreteSample->listOfAttributes->getElement(parents[att]->getElement(j))->getName() <<"\t";

    //if (att==totalAttributes-1)
    if (empty(parents[att])) cout <<"\t";


    if (!attribute->isContinuous()) modalidades=attribute->getModalidades();
    else
    {
      valores=attribute->getIntervals();


      if (valores==NULL)
      {
        cout <<"not disc";
        end();
      }
    }


    cout << "||";

    for (int j=0;j<totalAttModalidades;j++)
      if (!attribute->isContinuous())
        cout <<"\t" << modalidades->getElement((int)j) << "\t\t|";
      else
        if (j==0)
          cout <<"\t" <<"]-," << valores->getElement(( int)j) << "]\t\t |";
        else if (j== totalAttModalidades-1) cout <<"\t" <<"]" << valores->getElement((int)j-1) << ",-[\t\t |";
        else cout <<"\t" <<"]" << valores->getElement(( int)j-1) << ","<<  valores->getElement((int)j) <<"]\t\t |";


    cout <<"|\n";
  }
  /*____________________________________________________________________________________ */

  void BNC::printBody(int att)
  {
    int totalRows=1;
    if (!empty(parents[att])) totalRows=probTables[att]->getSize()/probTables[att]->getDimensionList()->getElement((int)0);
    /////////////////// rows//////////////////////

    if (att==classPosition) cout <<"\t";
    for (int r=0;r<totalRows;r++)
    {
      if (!empty(parents[att]))
        printHasParents(att, r);
      printCommonColumns(att, r, totalRows);
      cout <<"||\t\n";
    }  // end for each row
  }
  /*____________________________________________________________________________________ */

  void BNC::printProbabilityTables()
  {
  //  if (probTables==NULL) setProbTables();
    for (int i=0;i<totalAttributes;i++)
   //   if (discreteSample->listOfAttributes->getElement(i)->isSelected())
      {
        printHeading(i);
        printBody(i);
      }
    cout <<"\n";
  }

}
;  // Fin del Namespace

#endif

/* Fin Fichero: BNC.cpp */
