/* File: ClassificationResults.h */

#ifndef __ClassificationResults_h__
#define __ClassificationResults_h__



//using namespace UTILS;


namespace BIOS
{

struct ClassificationResultsSet 
{ //
float averageAccuracy;
float AUC;
float sd;
float averageUncovered;
float euclideanDistance;
BidimensionalTable<float>* true_PredictedTable;
int totalClasses;
Pair<doubleList*> *resultsforBinaryClassifiers;
}; 

  class ClassificationResults
  {
  public: 
ClassificationResultsSet set;
/*________________________________________________________________________*/

    ClassificationResults()
    {
set.true_PredictedTable=NULL;
set.averageAccuracy=0;
set.AUC=0;
set.sd=0;
set.averageUncovered=0;
set.euclideanDistance=0;
set.totalClasses=0;
set.resultsforBinaryClassifiers=NULL;
    };
/*________________________________________________________________________*/
    ~ClassificationResults()
    {
zap(set.true_PredictedTable);
zap(set.resultsforBinaryClassifiers);
}
/*________________________________________________________________________*/

    ClassificationResults(ClassificationResultsSet c)
    {
set=c;
     };

/*________________________________________________________________________*/

void GetMean (ClassificationResults** array, int size)
{
for (int i=1;i<=6;i++)
GetMean(array, size, i);
};
/*________________________________________________________________________*/

protected:

/*________________________________________________________________________*/

void GetMean (ClassificationResults** array, int size, int field)
{
try
{
//set.totalClasses=array[0]->set.totalClasses;
float **table=NULL;
float* array2=new float[size];
if (field==5)
{
table=new float*[array[0]->set.totalClasses*(array[0]->set.totalClasses+1)];
for (int i=0;i<array[0]->set.totalClasses*(array[0]->set.totalClasses+1);i++)
table[i]=new float[size];
}
for (int i=0; i<size;i++)
{
switch (field)
{
case 1: array2[i]=array[i]->set.averageAccuracy;break;
case 7: array2[i]=array[i]->set.AUC;break;
case 2: array2[i]=array[i]->set.sd;break;
case 3: array2[i]=array[i]->set.averageUncovered;break;
case 4: array2[i]=array[i]->set.euclideanDistance;break;
case 6: array2[i]=array[0]->set.totalClasses;break;
case 5: 
for (int j=0;j<array[0]->set.totalClasses*(array[0]->set.totalClasses+1);j++)
if (array[i]->set.true_PredictedTable!=NULL)
table[j][i]=array[i]->set.true_PredictedTable->MultidimensionalTable<float>::getValue(j);
else table[j][i]=0;
break;
default:throw OutOfBounds(0,5);
}
}
float result;
if (field==5) 
{
 set.true_PredictedTable=new BidimensionalTable<float>(array[0]->set.totalClasses, array[0]->set.totalClasses+1);
 for (int i=0;i<array[0]->set.totalClasses;i++)
  for (int j=0;j<array[0]->set.totalClasses+1;j++)
   set.true_PredictedTable->setValue(i,j, BIOS::GetMean(table[set.true_PredictedTable->getPos(i,j)], size));
zaparr(table);
}
else
{
result=BIOS::GetMean(array2, size);
switch (field)
{
case 1: set.averageAccuracy=result; break;
case 7: set.AUC=result; break;
case 2: set.sd=result;break;
case 3: set.averageUncovered=result;break;
case 4: set.euclideanDistance=result;break;
case 6: set.totalClasses=(int)result;
for (int i=0; i<size;i++)
if (array[i]->set.totalClasses!=result)
throw BadFormat("ClassificationResults::GetMean");
break;
}
}
zaparr(array2);
}
catch (OutOfBounds ob){ob.PrintMessage("ClassificationResults::GetMean");};
};
};

ostream& operator<<(ostream& out, ClassificationResults& p)
  {
out <<"average accuracy:\t" << p.set.averageAccuracy <<"+-" << p.set.sd<<"\n";
if (p.set.totalClasses==2) out <<"AUC:\t" << p.set.AUC << "\n"; // <<"+-" << p.set.sd<<"\n";
return out;
    
  };
};  // Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
