/* File: DiscreteEMClassifier.cpp */

#ifndef __DiscreteEMClassifier_cpp__
#define __DiscreteEMClassifier_cpp__





namespace BIOS {







/*____________________________________________________________________________________ */

template<> void EMClassifier<int>::set(floatMLSample* sample, int iterations)
{	
this->iterations=iterations;
frequencyTable=NULL;
MLEstimations=NULL;
this->sample=sample->getDiscreteSample();
};
/*____________________________________________________________________________________ */

template< > EMClassifier<int>::~EMClassifier()
{
zap (frequencyTable);
zap(MLEstimations);
zap(sample);
zap(knownFrequencyTable);
};
/*____________________________________________________________________________________ */

template <> double*  EMClassifier<int>::getFrequencies(intList* targetInputPattern)
{
int pos;
double *classFrequencies=new double[totalClasses];
InitializeList(classFrequencies, totalClasses, 0.0);
int* patternTable=targetInputPattern->getTable();
for (int i=0;i<totalClasses;i++)
{
 patternTable[classPosition]=i;
 classFrequencies[i]=MLEstimations->getValue(patternTable);
}
zap (patternTable);
return classFrequencies;
}

/*____________________________________________________________________________________ */
/* review: commented as new Multinomial(1, MLEstimations->getSize()-1); now requires 3 parameters
template <> void  EMClassifier<int>::setMLEstimations()
{
intList* varList=new intList(sample->listOfAttributes->size());
intList* dimensionList=sample->listOfAttributes->getDimensionList(varList);
MLEstimations=new VarsTable<double>(varList, dimensionList);
zap(varList);
zap(dimensionList);

Multinomial* m=new Multinomial(1, MLEstimations->getSize()-1);

double total=0.0;
for (int i=0; i<(MLEstimations->getSize()-1);i++)
{
 total=total+m->getProbs()[i];
 MLEstimations->setValue(i, m->getProbs()[i]);
}
 MLEstimations->setValue((MLEstimations->getSize()-1), total);

zap(m);
}
/*____________________________________________________________________________________ */
/* review: commented as now  new VarsTable<double>(sample->sample, sample->listOfAttributes) requires more params
template <> void  EMClassifier<int>::setFrequencies()
{
before:  knownFrequencyTable=new VarsTable<double>(sample->sample, varList, dimensionList, sample->listOfAttributes);
// now, not tested:
intList* varList=new intList(sample->listOfAttributes->size());
intList* dimensionList=sample->listOfAttributes->getDimensionList(varList);
knownFrequencyTable=new VarsTable<double>(sample->sample, varList, dimensionList, sample->listOfAttributes);
zap(varList);
zap(dimensionList);
}
/*____________________________________________________________________________________ */

template <> void  EMClassifier<int>::setExpectation()
{
if (frequencyTable!=NULL) zap(frequencyTable);
frequencyTable=new VarsTable<double>(*knownFrequencyTable);
intSample::iterator p;
intList* pattern;
int* tablePattern, totalMissingConfigurations;
int* originalTablePattern=NULL;
Attribute* attribute;
intList* missingPos=NULL;
double denominator;


p=sample->sample->getFirst();
while (p!=sample->sample->end())
{
pattern=sample->sample->getElement(p);
tablePattern=pattern->getTable();
missingPos=new intList();
totalMissingConfigurations=1;
missingPos=sample->listOfAttributes->getMissingPositions(pattern);
intList *missingDimensions=sample->listOfAttributes->getDimensionList(missingPos);
for (int i=0;i<missingDimensions->size();i++)
totalMissingConfigurations=totalMissingConfigurations*missingDimensions->getElement(i);
zap(missingDimensions);
if (missingPos->size()>0) 
{
originalTablePattern=pattern->getTable();

denominator=MLEstimations->getValue(tablePattern);
for (int k=0; k<totalMissingConfigurations;k++)
{
for (int i=0;i<missingPos->size();i++)
 originalTablePattern[missingPos->getElement(i)]=frequencyTable->getIndexPositionOfIndexVar(k, missingPos->getElement(i));
frequencyTable->setValue(originalTablePattern, frequencyTable->getValue(originalTablePattern)+
MLEstimations->getValue(originalTablePattern)/denominator);

}
zap(originalTablePattern);
}
zap(missingPos);
zap(tablePattern);
p=sample->sample->getNext(p);
}//end while
}
/*____________________________________________________________________________________ */

template <> void EMClassifier<int>::maximize()
{
for (int i=0; i<MLEstimations->size();i++)
 MLEstimations->setValue(i, frequencyTable->getValue(i));
}
 /*___________________________________________________________ */

template <> double* EMClassifier<int>::GetClassFrequencies(floatList* targetInputPattern)
{

//cout <<"targetInputPattern:" << *targetInputPattern <<"\n";
intList* targetIntegerPattern=targetInputPattern->getIntList();
targetIntegerPattern->insertElementAtPos(sample->listOfAttributes->getTotalModalidades(classPosition), classPosition);
double* results=getFrequencies(targetIntegerPattern);
zap(targetIntegerPattern);
return results;
};

 /*___________________________________________________________ */




};  // Fin del Namespace

#endif

/* Fin Fichero: DiscreteEMClassifier.cpp */
