/* File: EMClassifier.cpp */

#ifndef __EMClassifier_cpp__
#define __EMClassifier_cpp__


#include "EMClassifier.h"

//using namespace UTILS;


namespace BIOS {




/*____________________________________________________________________________________ */



/*____________________________________________________________________________________ */

template<class T> EMClassifier<T>::EMClassifier(floatMLSample* sample, int att, floatList* parameterList, VerbosityClass *verbosity, LossFunction* lossFunction, int iterations):Classifier(sample, att, parameterList, verbosity, lossFunction)
{	
set(sample, iterations);
setFrequencies();
setMLEstimations();
runEMClassifierAlgorithm();
};
/*____________________________________________________________________________________ */

template<class T> void EMClassifier<T>::set(floatMLSample* sample, int iterations)
{	
this->iterations=iterations;
frequencyTable=NULL;
MLEstimations=NULL;
knownFrequencyTable=NULL;
};


/*____________________________________________________________________________________ */

template<class T> EMClassifier<T>::~EMClassifier()
{
zap (frequencyTable);
zap(MLEstimations);
zap(knownFrequencyTable);
};
/*____________________________________________________________________________________ */


template<class T> void  EMClassifier<T>::setMLEstimations()
{
cout <<"Error in EMClassifier::setMLEstimations(), not implemented yet";
end();
}
/*____________________________________________________________________________________ */


template<class T> void  EMClassifier<T>::setFrequencies()
{
cout <<"Error in EMClassifier::setMLEstimations(), not implemented yet";
end();
}
/*____________________________________________________________________________________ */

template<class T> double*  EMClassifier<T>::getFrequencies(struct Vector<T>::Class* inputPattern)
{
cout <<"Error in EMClassifier::getFrequencies(), not implemented yet";
end();
}
/*____________________________________________________________________________________ */

template<class T> void  EMClassifier<T>::setExpectation()
{
throw NonImplemented(" EMClassifier<T>::setExpectation()");
}
/*____________________________________________________________________________________ */

template<class T> void  EMClassifier<T>::maximize()
{
throw NonImplemented(" EMClassifier<T>::maximize()");
}

/*____________________________________________________________________________________ */

template<class T> void  EMClassifier<T>::runEMClassifierAlgorithm(int it)
{
setExpectation();
maximize();
if (it<iterations) runEMClassifierAlgorithm(it+1);
}
 /*___________________________________________________________ */

template<class T> double*  EMClassifier<T>::getClassFrequencies(floatList* targetInputPattern)
{
//review return this->getFrequencies(targetInputPattern);
throw NonImplemented("EMClassifier<T>::GetClassFrequencies(floatList* targetInputPattern)");
};





};  // Fin del Namespace

#endif

/* Fin Fichero: EMClassifier.cpp */
