#ifndef GenericMLTest_cpp//
#define GenericMLTest_cpp//






//using namespace UTILS;

namespace BIOS
{

	GenericMLTest::GenericMLTest ( char* fileSample, TestModeClass *testMod, int jointRows, int testModeForInsideMeasure )
	{
		try
		{
			char timestr[256];
			struct timeval  tv;
			gettimeofday ( &tv, NULL );
			sprintf ( timestr, "%u.%06u", tv.tv_sec,  tv.tv_usec );
			timeMark=string ( timestr );

			this->testModeForInsideMeasure=testModeForInsideMeasure;
			if ( testModeForInsideMeasure>0 && (testMod->tm==tTraining || testMod->tm==tHalfTraining ))
			{
				cout <<"testmode is:" << *testMod <<" but should be cross validation, Holdout or leave-one-out\n";
				throw BadFormat ( "GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows, int testModeForInsideMeasure)" );
			}
			this->testMod=testMod->clone();
			if ( !testModeForInsideMeasure ) this->externalNumberOfFolds=testMod->numberOfFolds;
			else this->externalNumberOfFolds=1;

			// if (testMod->tm==tHalfTraining && testModeForInsideMeasure) throw BadFormat("GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows, bool testModeForInsideMeasure)");
//cout <<testMod->numberOfFolds <<"\n";
			fileName=new char[256];
			strcpy ( fileName,fileSample );
//this->pos=pos;
			this->size=0;
			totalAtts=GenericSample::divideSample ( timeMark, fileSample, testMod, jointRows );


			samplesForTraining=NULL;
			samplesForTest=NULL;
			wholeSample=NULL;
			genericCountsForTraining=NULL;
			genericCountsForTest=NULL;
			wholeCounts=NULL;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  GenericMLTest::GenericMLTest (char* fileSample, TestModeClass *testMod, int jointRows)" ); throw; };
	}

	/*___________________________________________________________ */

	int GenericMLTest::getSize()
	{
		if ( size==0 ) setSize();
		if ( size==0 ) throw NullValue ( "void  GenericMLTest::getSize()" );
		return size;
	}

	/*___________________________________________________________ */

	GenericMLTest::~GenericMLTest()
	{
		emptyCounts();
//cout <<"numberof folds:" << testMod->numberOfFolds <<"\n";
//for (int i=0; i<testMod->numberOfFolds; i++)
//{
//cout <<"zap i:" << i <<"\n";
//zap(samplesForTraining);
//}
//cout <<*testMod <<"\n";
		zaparr ( samplesForTraining, testMod->numberOfFolds );
		zaparr ( samplesForTest, testMod->numberOfFolds );
		zap ( wholeSample );
		zaparr ( fileName );
		zap ( testMod );
	}
	/*___________________________________________________________ */

	void GenericMLTest::emptyCounts()
	{
		zaparr ( genericCountsForTraining, testMod->numberOfFolds );
		zaparr ( genericCountsForTest, testMod->numberOfFolds );
		zap ( wholeCounts );
	}
	/*___________________________________________________________ */

	GenericCounts** GenericMLTest::getGenericCountsForTraining()
	{
		return genericCountsForTraining;
	}
	/*___________________________________________________________ */

	GenericCounts** GenericMLTest::getGenericCountsForTest()
	{
		return genericCountsForTest;
	}
	/*___________________________________________________________ */

	int GenericMLTest::getRealNumberOfAtts()
	{
		return totalAtts;
	}
	/*___________________________________________________________ */

	void GenericMLTest::setSize()
	{
//defaultPositions=true;
		this->size=getRealNumberOfAtts();
//this->pos=initializeFrom(0, size);
	}
	/*___________________________________________________________ */

	char* GenericMLTest::getFileName()
	{
//defaultPositions=true;
		return fileName;
//this->pos=initializeFrom(0, size);
	}
	/*___________________________________________________________ */

	void  GenericMLTest::setSubsamples ( int iniPos, int length )
	{
		try
		{
			samplesForTraining=new GenericSample*[testMod->numberOfFolds];
			samplesForTest=new GenericSample*[testMod->numberOfFolds];
			char file[1024];
			string t;
			GenericSample** genericSamples=NULL, **genericSubsamples=NULL;
			if ( length==-1 ) length=getSize();
			int* pos=initializeFrom ( iniPos, length );
			wholeSample=this->getSample ( fileName, pos, length );
			//print(pos, length, cout);
			// cout << fileName <<"\n";
			// cout <<"numberof folds:" << testMod->numberOfFolds <<"\n";
			for ( int i=0; i<testMod->numberOfFolds;i++ )
			{
				for ( int j=0; j<2;j++ ) // Training and test
				{
					if ( j==0 ) {t=timeMark+string ( "dat" ); genericSamples=samplesForTraining;}
					else {t=timeMark+string ( "test" ); genericSamples=samplesForTest;}
					if ( testMod->tm!=tTraining ) changeExtension ( fileName, file, ( t+tos ( i ) ).c_str() ); else strcpy ( file, fileName );

					if ( testMod->tm!=tTraining )
					{
						char * fileNoPath = removeDir ( file );

						genericSamples[i]=this->getSample ( fileNoPath, pos, length );
						unlink ( fileNoPath );
						delete fileNoPath;
					}
					else genericSamples[i]=this->getSample ( file, pos, length );

//for (int x=0; x<100000; x++)
//for (int y=0; y<20000; y++);
//cout <<"endsec\n";
				}
			}
			zap ( pos );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void  GenericMLTest::setSubsamples(int* pos, int length) " ); throw;};

	}


	/*___________________________________________________________ */

	void  GenericMLTest::setGenericCounts ( int* pos, int length )
	{
		try
		{
			if ( pos==NULL ) throw NullValue ( "void  GenericMLTest::setGenericCounts(int* pos, int length)" );
			if ( genericCountsForTraining!=NULL || genericCountsForTest!=NULL || wholeCounts!=NULL ) emptyCounts();
			genericCountsForTraining=new GenericCounts*[testMod->numberOfFolds];
			genericCountsForTest=new GenericCounts*[testMod->numberOfFolds];
			//cout <<"sample size is " << ((VectorOfParentalGenotypes*)wholeSample)->size() <<"\n";
			//cout <<"whole sample is: " << *wholeSample <<"\n";
			wholeCounts=this->getCounts ( wholeSample, pos, length );
			GenericCounts** genericCounts=NULL;
			GenericSample** samples=NULL;

			for ( int i=0; i<testMod->numberOfFolds;i++ )
				for ( int j=0; j<2;j++ ) // training and test
				{
					if ( j==0 ) {genericCounts=genericCountsForTraining; samples=samplesForTraining;}
					else {genericCounts=genericCountsForTest; samples=samplesForTest;}
					genericCounts[i]=this->getCounts ( samples[i], pos, length );
				}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void  GenericMLTest::setGenericCounts(int* pos, int length) " ); throw;};
	}
	/*___________________________________________________________ */

	MeasureResults**  GenericMLTest::getResults ( ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams ) //, int*subRegion, int length)
	{
		try
		{
			MeasureResults*** results=new MeasureResults**[measures->size() ], **finalResults=new MeasureResults*[measures->size() ];
			GenericMeasure* training=NULL, *test=NULL;
			stringSample*sample, *result;
			for ( int j=0; j<measures->size();j++ )
				results[j]=new MeasureResults*[externalNumberOfFolds];
			for ( int i=0; i<externalNumberOfFolds;i++ )
			{
				for ( int j=0; j<measures->size(); j++ )
					for ( int k=0; k<2;k++ )
						// FIRST CREATE TRAINING MEASURE
						if ( k==0 )
						{
							if ( testModeForInsideMeasure>0 )
							{
								training=measures->getElement ( j )->getNewGenericMeasure ( wholeCounts, genericCountsForTraining, genericCountsForTest );
							}
							else
								training=measures->getElement ( j )->getNewGenericMeasure ( genericCountsForTraining[i] );

					//		cout << training->getName() <<"\n";
//cout <<*training <<"\n";
						}
						else
						{
							test=NULL;
							// SECOND CREATE TEST MEASURE
							if ( testMod->tm==tTraining || testMod->tm==tHalfTraining || testModeForInsideMeasure>0 )
							{
								test=training->clone();
							}
							else
								test=training->inferGenericMeasure ( genericCountsForTest[i] );// outSideTestMode crossVal
							if ( test==NULL ) throw NullValue ( "MeasureResults**  GenericMLTest::getResults (ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams)" );
//							cout << test->getName() << "\n";
//cout << *test <<"\n";

							if ( listOfStreams!=NULL ) *listOfStreams->getElement ( j )  << *test <<"\n";
							// OBTAIN P-VALUES
							results[j][i]=test->getResults();
							// DELETE TEMPORAL MEASURES
							zap ( training );
							zap ( test );
						}
			}
			for ( int k=0; k<measures->size();k++ )
			{
				finalResults[k]=results[k][0]->getAverage ( results[k], externalNumberOfFolds );
				zaparr ( results[k], externalNumberOfFolds );
			}
			zaparr ( results, measures->size() );
			return finalResults;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from MeasureResults**  GenericMLTest::getResults(ListOfGenericMeasures* measures) " ); throw;};
	}
} // end namespace
#endif
