#ifndef GenericSample_h//
#define GenericSample_h//



namespace BIOS {


class InputTUI;


////////////////////////////

class GenericSample {

/** This class is used as a generalization of any sample (ML Sample, genetic samples, etc.) so that they all can be divided in order to use tests, classifier or any other measure using different testting comfigurations (cross-validation, holdout, training).
It stores information about the extension of auxiliar files depending on the sublcasses (eg. .mas for MLSample, .pou and .rs for TrioSamples).
It also stores the number of rows that cannot be splitted: 3 for trioSamples, 1 default
*/






public:

GenericSample(){};
static int divideSample(string timeMark, char* filename, TestModeClass* testMod, int jointRows=1);
static intSet* selectPositions(int foldSize, Sampling* sampling, int index, int jointRows=1);
friend ostream& operator<<(ostream& out, GenericSample& l) 
{
try
{
l.print(out); 
}
catch (BasicException& be){be.addMessage("\ncalled from ostream& operator<<(ostream& out, GenericSample& l)  "); throw;};
return out;
};

virtual void print(ostream&)=0;
virtual ~GenericSample(){};
};

} // end namespace
#endif

