/* File: DiscModeClass.h */

#ifndef __DiscModeClass_h__
#define __DiscModeClass_h__



//using namespace UTILS;


namespace BIOS {

 enum DiscMode {
    IgualAnchura=1,
    D1R=2,
    PRPRMR=3,
    PRPEME=4,
    RM=5,
    PEPEME=7,
    PEPRMR=8,
    EM=9,
    IgualFrecuencia=10,
    IgualFrecuenciaYang=11,
    EntropiaDirichletImprecisa=12,
    EntropiaDirichlet=13,
    PRPRME=16,
    PRPEMR=17,
    PEPRME=18,
    PEPEMR=19,
    LocalEntropiaPuntosRiesgo=-6,
    LocalRiesgoPuntosEntropia=-5, 
    LocalEntropiaPuntosEntropia=-4, //C45
    LocalRiesgoPuntosRiesgo=-3,
    LocalMitadEntropia=-2,
    LocalMitadRiesgo=-1,
	NoDiscretization=0
  };


class DiscModeClass {

char line[1024];

DiscMode discMode;

public:

 	
DiscModeClass(DiscMode discMode)
{
this->discMode=discMode;
}

 	



///////
char* print ()
{
	strcpy(line, "\nDiscretization algorithm:\t");
	switch (discMode)
	{
	case NoDiscretization: strcat(line, "no discretization"); break;
	case IgualAnchura:  strcat(line, "Equal intervals"); break;
	case D1R:  strcat(line, "Holte's 1R"); break;
	case PRPRMR:  strcat(line, "PRPRMR"); break;
	case PRPEME:  strcat(line, "PRPEME"); break;
	case RM:  strcat(line, "RM"); break;
	case PEPEME:  strcat(line, "Fayyad & Irani's MDL"); break;
	case PEPRMR:  strcat(line, "PEPRMR"); break;
	case EM:  strcat(line, "EM"); break;
   	case IgualFrecuenciaYang:  strcat(line, "Yang's equal frequency"); break;
	case EntropiaDirichletImprecisa:  strcat(line, "Imprecise Dirichlet entropy"); break;
	case EntropiaDirichlet:  strcat(line, "Dirichlet entropy"); break;
	case PRPRME:  strcat(line, "PRPRME"); break;
	case PRPEMR:  strcat(line, "PRPEMR"); break;
   	case PEPRME:  strcat(line, "PEPRME"); break;
	case PEPEMR:  strcat(line, "PEPEMR"); break;
   	case LocalEntropiaPuntosRiesgo:  strcat(line, "LPEPR"); break;
	case LocalRiesgoPuntosEntropia:  strcat(line, "LPRPE"); break;
	case LocalEntropiaPuntosEntropia:  strcat(line, "LPEPE"); break;
	case LocalRiesgoPuntosRiesgo:  strcat(line, "LPRPR"); break;
	case LocalMitadEntropia:  strcat(line, "LHE"); break;
	case LocalMitadRiesgo:  strcat(line, "LMR"); break;
	}
	return line;
}
};

ostream& operator<<(ostream& out, DiscModeClass& p)
{
out << p.print();
return out;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: DiscModeClass.h */
