#ifndef Discretization_cpp
#define Discretization_cpp



#include "Discretization.h"//
//////

//using namespace UTILS;


namespace BIOS {
  /*____________________________________________________________________________________________*/

  Discretization::~Discretization()
  {
  };
  /*____________________________________________________________________________________________*/

  Discretization::Discretization(floatMLSample* sample, DiscMode discMod, bool supervised, VerbosityClass * verbosity, int classPosition)
  {


    // create listOfDiscretizedAttributes, discretizing continuous attributes in listOfAttributes by using discMod on sample
    this->classPosition=classPosition;
    discMode=discMod;
     ListOfAttributes::iterator pA=sample->listOfAttributes->getFirst();
    Valores *intervals=NULL;
    Attribute *attribute;
    floatMLSample* narrowSample;
    intList *selectedAttributes=new intList();
    selectedAttributes->insertElement(classPosition);
    int i=0;
       while(pA!=sample->listOfAttributes->end())
    {
     attribute=sample->listOfAttributes->getElement(pA);

	   if (attribute->isContinuous())
        if (attribute->isSelected())
         {

	 selectedAttributes->insertElementAtPos(i, 0);
	 narrowSample=sample->copyColumns(selectedAttributes, false);	    

  	 intervals=SetIntervals(narrowSample);

        attribute->setIntervals(intervals);
      if (verbosity->verbosityR.discretization)
{
      cout <<"\n Intervals att: " << i+1 <<": " << *attribute->getIntervals();
//cout <<"\nTotal intervals:" << attribute->GetTotalModalidades();
}
      zap(narrowSample);
      zap(intervals);
       selectedAttributes->removeNode(0);
      }
    pA=sample->listOfAttributes->getNext(pA);
      i++;
    }

zap(selectedAttributes);	
  }
  /*____________________________________________________________________________________________*/

  floatList* Discretization::SetIntervals(floatMLSample* narrowSample)
  {
    AttributeDiscretization* attributeDiscretization=NULL;

    bool iterative=false;
    bool structural=false;

    switch (discMode)
    {
    case IgualAnchura: 
attributeDiscretization=new SameWidthAttributeDiscretization(narrowSample);
break;
    case D1R: break;
    case RM: break;
    case PRPEME: half=false; puntos=true; parada=false; iterative=true;  attributeDiscretization=new EntropyAttributeDiscretization(narrowSample, half, puntos, parada);
break;
    case PEPEME: half=false; puntos=true; parada=false; iterative=true;  attributeDiscretization=new EntropyAttributeDiscretization(narrowSample, half, puntos, parada);
break;
    case PEPRME: half=false; puntos=true; parada=true; iterative=true; 
attributeDiscretization=new EntropyAttributeDiscretization(narrowSample, half, puntos, parada);
break;
case PRPRMR: half=false; puntos=true; parada=true; iterative=true; structural=true; 
    case PEPEMR: half=false; puntos=true; parada=false; iterative=true; structural=true; break;
    case PRPEMR: half=false; puntos=true; parada=false; iterative=true; structural=true;  break;
    case PEPRMR: half=false; puntos=true; parada=true; iterative=true; structural=true;  break;
    case EM: break;
 case IgualFrecuencia: 
attributeDiscretization=new SameFrequencyAttributeDiscretization(narrowSample);
break;
    case IgualFrecuenciaYang: 
    case EntropiaDirichletImprecisa: 
    case EntropiaDirichlet:
    case LocalEntropiaPuntosRiesgo: 
    case LocalRiesgoPuntosEntropia: 
    case LocalEntropiaPuntosEntropia: 
    case LocalRiesgoPuntosRiesgo: 
    case LocalMitadEntropia: 
    case LocalMitadRiesgo:
      cout <<"discr method not implemented yet";
      exit(0);
      break;

    }



     attributeDiscretization->discretization(narrowSample->sample->begin(), narrowSample->sample->end());

     floatList* intervals;
    intervals=attributeDiscretization->GetIntervals();
   
 
  //  intervals->size();
    zap(attributeDiscretization);
    return(intervals);
  }
 
}
#endif
