#ifndef IterativeDiscretization_cpp //
#define IterativeDiscretization_cpp //

#include<cstdio>//
#include<cstdlib>//
#include<cmath>//
#include<iostream>//
#include<iomanip>//
#include<fstream>//
#include "IterativeDiscretization.h"
//////

//using namespace UTILS;


namespace BIOS {



IterativeDiscretization::~IterativeDiscretization()
{
}


/*____________________________________________________________________________________________*/

IterativeDiscretization::IterativeDiscretization(floatMLSample* sample, bool half, bool puntos, bool parada, int maxNumberOfIntervals):AttributeDiscretization(sample, maxNumberOfIntervals)
{
this->half=half;
this->puntos=puntos;
this->parada=parada;

//cout <<*sample;
}
/*____________________________________________________________________________________________*/

void IterativeDiscretization::discretization(floatSample::iterator first, floatSample::iterator last)
{

bool isFirst=false;
if (first==sample->sample->begin() && last==sample->sample->end())
{
first=sample->sample->getFirst();
last=sample->sample->getLast();
isFirst=true;
}
//cout <<"max val is: " << maxNumberOfIntervals;
if (first!=last)
{
cutPair=getCutPair(first, last, isFirst);
//cout << "cutPair is " << *cutPair->element;
//end();
double middle, left, right;
floatSample::iterator nextCutPair;
if (cutPair!=sample->sample->end()) //&& getTotalLeftPatterns(first, last, cutPair)>1 && getTotalRightPatterns(first, last, cutPair)>1)
{
pattern=(floatList*)sample->sample->getElement(cutPair);
left=pattern->getElement(0);
pattern=(floatList*)sample->sample->getElement(sample->sample->getNext(cutPair));
right=pattern->getElement(0);
middle=(left+right)/2;
nextCutPair=sample->sample->getNext(cutPair);
if (sample->sample->getPosition(cutPair)>0)
discretization(first, cutPair);
if (intervals->size()==0 || (middle!=intervals->getLastElement()))
intervals->insertElement(middle);
if ((sample->sample->getPosition(last)-sample->sample->getPosition(nextCutPair))>1)
discretization(nextCutPair, last);
}
}
}
/*____________________________________________________________________________________________*/

floatSample::iterator IterativeDiscretization::getCutPair(floatSample::iterator first, floatSample::iterator last, bool isFirst)
{
floatSample::iterator p=first, pMin;
float measure, nextVal, val, val2;
bool improved=false;
int firstPos=sample->sample->getPosition(first);
int lastPos=sample->sample->getPosition(last);
int currentPos;
intList* classList=new intList(); classList->insertElement(1);
floatMLSample* onlyClass=sample->copyColumns(classList);
zap(classList);
intMLSample* discSample=onlyClass->getDiscreteSample();
zap(onlyClass);
double margen1=getMargen1(discSample), margen2, min=margen1;
//cout <<"margen0: " << margen1;
if (isFirst) min=maxreal;
//cout <<"margen0: " << min;
while (p!=last)
{
val=sample->sample->getElement(p)->getElement(0);
val2=sample->sample->getElement(sample->sample->getNext(p))->getElement(0);
currentPos=sample->sample->getPosition(p);
if (val!=val2 && (lastPos-currentPos)>minNumberOfInstancesPerInterval && 
(currentPos-firstPos)>minNumberOfInstancesPerInterval)
{
margen2=getMargen2(discSample, sample->sample->getPosition(p));
if (min>margen2) 
{
//cout <<"\nmargen2:" << margen2 <<"for element" << sample->sample->GetPos(p);
improved=true;
min=margen2;
pMin=p;
}
}
p=sample->sample->getNext(p);
}
zap (discSample);
if (!improved) return last;
else return pMin; 
}
}

#endif
