/***************************************************************************
 *   Copyright (C) 2005 by M. Mar Abad Grau 				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef __InputTUI_cpp__
#define __InputTUI_cpp__



#include "InputTUI.h"//



namespace BIOS
{

  /*____________________________________________________________________*/

  void InputTUI::printHelp(const char* programName)


  {
    cout << "\nUsage: " << programName <<" <INPUTFILE> [<OPTION>] ...";
    //cout <<"\nINPUTFILE:\t
    cout <<"\n\nOPTIONS:";
    cout <<"\n -h\t help";
    cout <<"\n -f\t second input file";
    cout <<"\n\n -a=[0..12]\tLEARNING ALGORITHM \n\t\t";
    cout << "0 (default): NB (modifiers: <inference 0 (default): junction tree, 1: direct)>, <estimationMethod 0 (default): MLE, uniform Bayes: 1, Uniform Bayes with distance: 4>, <alpha for Bayes uniform: any real number>), \n\t\t";
    cout << "1: TAN (modifiers: <inference 0 (default): junction tree, 1: direct>, <estimationMethod 0 (default): MLE, uniform Bayes: 1, Uniform Bayes with distance: 4>, <alpha for Bayes uniform: any real number>), \n\t\t";
    cout <<"2: GTAN  (modifiers: <inference 0 (default): junction tree, 1: direct>, <estimationMethod 0 (default): MLE, uniform Bayes: 1, Uniform Bayes with distance: 4>, <alpha for Bayes uniform: any real number> ), \n\t\t";
     cout <<"8: UAN  (modifiers: <inference 0 (default): junction tree, 1: direct>, <estimationMethod 0 (default): MLE, uniform Bayes: 1, Uniform Bayes with distance: 4>, <alpha for Bayes uniform: any real number>), \n\t\t";
    cout << "3: FUNCDEP0 (modifiers: <inference 0 (default): junction tree, 1: direct>, <estimationMethod 0 (default): MLE, uniform Bayes: 1, Uniform Bayes with distance: 4>, <alpha for Bayes uniform: any real number>):, \n\t\t";
    cout <<"4: c4.5, \n\t\t5: continuous c4.5\n\t\t6: BT, \n\t\t7: knn, \n\t\t8: user-chosen BN (in file .mod), \n\t\t9: EM, \n\t\t10: continuous EM";
    cout <<"\n\n -s=[0..5]\t SELECTION ALGORITHM "; SelModeClass::printHelp(cout); 
    cout <<"\n\n -d=[-6..19]\t DISCRETIZATION ALGORITHM \n\t\t0: no discretization, ";
    cout <<"\n\t\t-1: localHalfRisk (only for C4.5), \n\t\t-2: localHalfEntropy (only for C4.5), \n\t\t-3: localRiskPR (only for C4.5), \n\t\t-4: LocalEntropyPE (only for C4.5), \n\t\t-5: localRiskPE (only for C4.5), \n\t\t-6: localEntropyPR (only for C4.5)";
    cout <<"\n\t\t1: EqualIntervals, \n\t\t2: 1R, \n\t\t3: PRPRMR, \n\t\t4: PRPEPE, \n\t\t5: RM, \n\t\t7: PEPEPE (Fayyad and Irani, default),\n\t\t8: PEPRMR, \n\t\t9: EM, 11: Yang, \n\t\t12: EntropyImpreciseDirichlet, \n\t\t13: EntropyDirichlet, ";
    cout <<"\n\t\t16: PRPRMR, \n\t\t17: PRPEMR, \n\t\t18: PEPRME, \n\t\t19: PEPEMR";
    cout <<"\n\n -t=[0..3][ <n>]\t TRAINING ALGORITHM \n\t\t0 (default): leaveOneOut, \n\t\t1: crossValidation (modifiers: <n: number of folds (default: 5)> , \n\t\t2: holdout, \n\t\t3: training> >";
    cout <<"\n\n -v=[string]\t VERBOSITY\n\t\twith each char in string having the following values: \n\t\ta: accuracies, \n\t\tc: configuration, \n\t\td: attribute description, \n\t\tD: attribute discretization, \n\t\tS: selected attributes\n\t\ts: structure, \n\t\tp: parameters, \n\t\ti: individual test results, \n\t\tt: true/predicted value table, \n\t\te: Euclidean distance, \n\t\tr: Selection scores, \n\t\to: Show progress,  \n\t\tm: Complete sample";
     cout <<"\n\n -c=[1..n]\t CLASS ATTRIBUTE\n\t\tattribute to be used as the class for classification algorithms. Default is n -the last attribute-, attributes start at 1, 0 means all the attributes will be used as classes,-1 if only the last will be used as the class and -2 if all except the last one will be used as classes";
    cout <<"\n\n -m=[0..2]\t METADATA\n\t\t0 (default): do not create metadata file, \n\t\t1: create if it does not exist, \n\t\t2: create always (replace old if it exists)";
cout <<"\n\n -l=[0..1]\t LOSS FUNCTION\n\t\tthe loss function to be used to compute accuracy in classification algorithms (default is 0 (all errors have the same penalty, a class is always chosen) or,  1 if the loss function is specified in the file with same name but extension .los. Format for the los file is explained at http://bios.ugr.es/MLT/lossFunction.php";
     cout <<"\n\n -D=[0..1]\t DECISION\n\t\t	whether decision will be stochastic (1) or deterministic (0, default)";
    cout <<"\n";
    cout <<"\n";

  }

  /*____________________________________________________________________*/

  void InputTUI::readInputFile()
  {
 strcpy(filename, argv[1]);
}
  /*____________________________________________________________________*/

  void InputTUI::readSecondInputFile()
  {
  strcpy(secondFilename,"\0");
		string str=getStringArgument('f');
//cout << "string is:" << str;
  if (str.compare(string(""))!=0)
		strcpy(secondFilename,str.c_str());
//  cout << "secondFule is:" << secondFilename << "\n";
}
 /*____________________________________________________________________*/

  void InputTUI::readClassPosition()
  {
 selectedClassPosition=getArgument('c');

 if (selectedClassPosition<-2) 
{
cout << "Error in InputTUI::readClassPosition, selected class must be greater than -3" ;
end();
}

//if (selectedClassPosition>-1) 
selectedClassPosition--;

}
 /*____________________________________________________________________*/

  void InputTUI::readVerbosity()
  {
string str=getStringArgument('v');

if (str.find('a', 0)!=string::npos) verbosity->verbosityR.accuracy=true;
if (str.find('S', 0)!=string::npos) verbosity->verbosityR.selection=true;
if (str.find('p', 0)!=string::npos) verbosity->verbosityR.parameters=true;
if (str.find('c', 0)!=string::npos) verbosity->verbosityR.configuration=true;
if (str.find('d', 0)!=string::npos) verbosity->verbosityR.attributeDescription=true;
if (str.find('D', 0)!=string::npos) verbosity->verbosityR.discretization=true;
if (str.find('s', 0)!=string::npos) verbosity->verbosityR.structure=true;
if (str.find('i', 0)!=string::npos) verbosity->verbosityR.individualAccuracy=true;
if (str.find('t', 0)!=string::npos) verbosity->verbosityR.true_predictedValues=true;
if (str.find('e', 0)!=string::npos) verbosity->verbosityR.euclideanDistance=true;
if (str.find('r', 0)!=string::npos) verbosity->verbosityR.selectionScores=true;
if (str.find('o', 0)!=string::npos) verbosity->verbosityR.progress=true;
//if (str.find('m', 0)!=string::npos) verbosity->verbosityR.completeSample=true;
}

 /*____________________________________________________________________*/

  void InputTUI::readLossFunction()
  {
useFileForLossFunction=false;
int ver=getArgument('l');
if (ver!=-1) useFileForLossFunction=(bool)ver;
}

 /*____________________________________________________________________*/

  void InputTUI::readSelection()
  {
int sel=getArgument('s');
if (sel==-1) 
{
selection->insertElement(0);//All attributesfalse
return;
}
selection->insertElement(sel);
int i=getArgumentPosition('s');
if (sel==manualFromFile)
{
if (getTotalArguments('s')!=2) throw BadFormat("inputTUI::readSelection, selection parameters with subtype and file with selection attributes are required");
selection->insertElement(atof(argv[i+1]));
//strcpy(selectionFile,argv[i+1]);
selSubmodeClass=new SelSubmodeClass((SelSubmode)atoi(argv[i+1]), argv[i+2]);
return;
}
if (sel==reliefF)
{
if (getTotalArguments('s')>3) throw BadFormat("inputTUI::readSelection, selection parameters with m (number of instances for sampling), k (number of nearest neighbours) and t (quality threshold) are required for ReliefF algorithm");
if (getTotalArguments('s')>0) selection->insertElement(atof(argv[i+1]));
else selection->insertElement(0);
if (getTotalArguments('s')>1) selection->insertElement(atof(argv[i+2]));
else selection->insertElement(10);
if (getTotalArguments('s')>2) selection->insertElement(atof(argv[i+3]));
//else selection->insertElement(1/sqrt(selection->getElement(0)));
//strcpy(selectionFile,argv[i+1]);
return;
}

while (i<(argc-1) && !isAModifier(argv[i+1]))
        {
          i=i+1;
          if (isANumber(argv[i]))
            selection->insertElement(atof(argv[i]));
          else
          {
	        cout <<"Error in argument for " << argv[i] << ". It should be a number. \n";
            printHelp("InputTUI");
            end();
          }
}


}
/*____________________________________________________________________*/

  void InputTUI::readDiscretization()
  {
int disc=getArgument('d');
//end();
if (disc!=-1) discretization->insertElement((float)disc);
else discretization->insertElement((float)7);//All attributesfalse
}
/*____________________________________________________________________*/

  void InputTUI::readTestMode()
  {
int t=getArgument('t');
if (t!=-1) 
{
test->insertElement(t);
if (t>1) // Holdout, tTraining, tHalfTraining
test->insertElement(1); // one fold
int i=getArgumentPosition('t');
if (t==1) // cross-validation
 if (i<(argc-1) && argv[i+1][0]!='-')
           test->insertElement(atof(argv[i+1]));
	else test->insertElement(5);
}
else 
{
 test->insertElement(1);//tCrossValidation
 test->insertElement(5);//number of folds=5
}
}

/*____________________________________________________________________*/

  void InputTUI::readAlgorithm()
  {

int a=getArgument('a');
if (a==nil) 
{
algorithmParameters->insertElement(0);//naive bayes
algorithmParameters->insertElement(0); // no direct method
algorithmParameters->insertElement(0); // MLE
return;
}
//cout <<"a is " << a <<"and arg so gar are: " << *algorithmParameters;
algorithmParameters->insertElement(a);
int i=getArgumentPosition('a');
//cout <<"i is: " << i;
while (i<(argc-1) && !isAModifier(argv[i+1]))
        {
          i=i+1;
          if (isANumber(argv[i]))
            algorithmParameters->insertElement(atof(argv[i]));
          else
          {
	        cout <<"Error in argument for " << argv[i] << ". It should be a number. \n";
            printHelp("InputTUI");
            end();
          }
if (algorithmParameters->size()==3)
if (algorithmParameters->getFirstElement()==aNB || 
algorithmParameters->getFirstElement()==aTAN ||
algorithmParameters->getFirstElement()==aGTAN||
algorithmParameters->getFirstElement()==aUAN ||
algorithmParameters->getFirstElement()==aFUNC)
if (!isAnInteger(argv[i]) || (atoi(argv[i])!=0 && atoi(argv[i])!=1 && atoi(argv[i])!=4))
{
cout << "Error in InputTUI::readAlgorithm, the estimation method for Bayesian networks must be 0, 1 or 4 and you entered " << atoi(argv[i]); 
end();
}
//if ((i>=(argc-1) || isAModifier(argv[i+1]))) algorithmParameters->insertElement(1);
}
}
 /*____________________________________________________________________*/

  void InputTUI::readMetadata()
  {
metadata=getArgument('m');
if (metadata==-1) metadata=1;
}

 /*____________________________________________________________________*/

  void InputTUI::readDecision()
  {
stochastic=getArgument('D');
if (stochastic==-1) stochastic=0;
}
 /*____________________________________________________________________*/

  int InputTUI::getArgument(char a)
  {
int i=getArgumentPosition(a);
if (i==-1) return -1;
else return atoi(argv[i]+3);
}
 /*____________________________________________________________________*/

  string InputTUI::getStringArgument(char a)
  {
int i=getArgumentPosition(a);
//cout << "i is:" << i << "\n";
if (i==-1) return string("");
else return string(argv[i]+3);
}

 /*____________________________________________________________________*/

  int InputTUI::getTotalArguments(char a)
  {
int i=getArgumentPosition(a), ini=i;
if (i==-1) return 0;
else 
while (i<(argc-1) && !isAModifier(argv[i+1]))
          i=i+1;
         
return i-ini;
}
/*____________________________________________________________________*/

  int InputTUI::getArgumentPosition(char a)
  {
int i=2;
  char modifier;
     while (i<argc)
    {
      while(i<argc && !isAModifier(argv[i]))
      {
     //   cout <<"Error in " << argv[i] << ".\n";
     //   printHelp("InputTUI");
     //   end();
i++;
      }
if (i==argc) return -1;
       modifier=argv[i][1];
if (modifier!='v' && modifier!='f' && !isAnInteger(argv[i]+3))
      {
          cout <<"Error in argument for " << argv[i] << ". It should be a number. \n";
        printHelp("InputTUI");
        end();
      }
       if (modifier==a) return i;
      i++;
//cout <<"ff";
  // end();
    }
return -1;
}


 
  /*_________________________________________________________________________*/

  bool InputTUI::isAModifier(char* c)
  {
    if (strlen(c)<2) return false;

    if (c[0]=='-' && (c[1]=='s' || c[1]=='d' || c[1]=='D' || c[1]=='t' || c[1]=='a' || c[1]=='h'|| c[1]=='v'|| c[1]=='c' || c[1]=='l' || c[1]=='f') && c[2]=='=')
      return true;
    else return false;
  }
  /*_________________________________________________________________________*/
/*
  bool InputTUI::isAValue(char* c)
  {
    if (strlen(c)<4) {return false;}
    if (c[0]=='-' && (c[1]=='s' || c[1]=='d' || c[1]=='t' || c[1]=='a'|| c[1]=='v'|| c[1]=='c') && c[2]=='=')
      return true;
    else return false;
  }
  /*_________________________________________________________________________*/

  bool InputTUI::isHelp(char* c)
  {
    if (strlen(c)<2) return false;

    if (c[0]=='-' && c[1]=='h')
      return true;
    else return false;
  }

 
  /*_________________________________________________________________________*/

  InputTUI::InputTUI(int argc, char *argv[], const char* programName)
  {
try
{
selSubmodeClass=NULL;
discretization=new floatList();
selection=new floatList();
test=new floatList();
algorithmParameters=new floatList();
verbosity=new VerbosityClass();
this->programName=string(programName);
if (argc==1 || (argc>=2 && isAModifier(argv[1])) || (argc>=2 && argv[1][0]=='-'))
    {
      printHelp(programName);
      exit(0);
    };


this->argc=argc;
this->argv=argv;
readInputFile();
readSecondInputFile();
readDiscretization();
readSelection();
readAlgorithm();
readTestMode();
readVerbosity();
//cout << verbosity;
readClassPosition();
readLossFunction();
readDecision();
 discMode=(DiscMode) (int) discretization->getElement((int)0);
 discretization->removeNode((int)0);
     selMode=(SelMode) (int) selection->getElement((int)0);
selection->removeNode((int)0);
     algType= (AlgType) (int) algorithmParameters->getElement((int)0);
algorithmParameters->removeNode((int)0);


     testMode=(TestMode) (int) test->getElement((int)0);
test->removeNode((int) 0);

    if (test->getFirst()!=test->end())
      numberOfFolds=(TestMode) (int) test->getElement((int)0);
//test->removeNode((int) 0);
     algTypeClass=new AlgTypeClass(algType, algorithmParameters);
     testModeClass=new TestModeClass(testMode, numberOfFolds);
     discModeClass=new DiscModeClass(discMode);
     selModeClass=new SelModeClass(selMode, selection);

if (verbosity->verbosityR.configuration)
{
cout << *this <<"\n";
/*
if (stochastic) cout <<"Decision: \t\t\tStochastic";
else cout <<"Decision: \t\t\tDeterministic";
       cout << *algTypeClass;
      cout << testModeClass->print();
      cout << discModeClass->print();
 	cout << *selModeClass;// << ", params: " << *selection;
if (selModeClass->selMode==manualFromFile) cout << selSubmodeClass;
cout << verbosity;
cout <<"\n";
cout <<"Class attribute: \t\t";
switch(selectedClassPosition)
{
 case -3: cout <<"All attributes except the last used as classes"; break;
case -2: cout <<"Only the last attribute used as class"; break;
case -1: cout <<"All attributes used as classes"; break;
 default: cout << selectedClassPosition; break;
 }
*/
}

}
catch (BasicException& be){be.addMessage("\ncalled from InputTUI::InputTUI(int argc, char *argv[], const char* programName))"); throw;};
}


 /*_________________________________________________________________________*/

  InputTUI::~InputTUI()
  {
zap(selModeClass);
zap(discModeClass);

zap(testModeClass);
zap(algTypeClass);

//zap(positions);

//zap(verbosity);
zap(algorithmParameters);
zap(test);
zap(selection);
zap(discretization);
zap(verbosity);
}


 /*_________________________________________________________________________*/

ostream& operator<<(ostream& out, InputTUI& p)
{
try
{
out <<"\nInput configurations:\nProgram:\t\t\t" << p.programName;
out <<"\nSource file:\t\t\t" << p.filename;
if (strcmp(p.secondFilename, "\0")!=0)
out <<"\nSecond source file:\t\t" << p.secondFilename;
if (!p.useFileForLossFunction) cout <<"\nLoss function: default"; else out <<"\nLoss function read from file";
if (p.verbosity==NULL) throw NullValue("InputTUI<<");
out << *p.verbosity;
out <<"\nClass attribute: \t\t";
switch(p.selectedClassPosition)
{
 case -3: out <<"All attributes except the last used as classes"; break;
case -2: out <<"Only the last attribute used as class"; break;
case -1: out <<"All attributes used as classes"; break;
 default: out << p.selectedClassPosition; break;
 }

out <<"\nMetadata:\t\t\t" << p.metadata;
out <<"\nDecision:\t\t\t"; if (p.stochastic) cout << "stochastic\n"; else out <<"deterministic";
out << *p.discModeClass<< *p.selModeClass;
if (p.selSubmodeClass!=NULL) out << *p.selSubmodeClass;
out << *p.algTypeClass<< *p.testModeClass <<"\n";
return out;

}
catch (BasicException& be){be.addMessage("\ncalled from  InputTUI::ostream& operator<<(ostream& out, InputTUI& p)"); throw;};


}

}

#endif




