/* File: VerbosityClass.h */

#ifndef __VerbosityClass_h__
#define __VerbosityClass_h__



using namespace std;


namespace BIOS {


typedef struct
{
bool accuracy;
bool selection;
bool selectionScores;
bool parameters;
bool configuration;
bool attributeDescription;
bool discretization;
bool structure;
bool individualAccuracy;
bool true_predictedValues;
bool euclideanDistance;
bool progress;
//bool completeSample;
}
verbosityRecord;



class VerbosityClass {


public:

verbosityRecord verbosityR;
 	
VerbosityClass(verbosityRecord verbosityR)
{
this->verbosityR=verbosityR;
}
VerbosityClass()
{
verbosityR.accuracy=false;
verbosityR.selection=false;
verbosityR.parameters=false;
verbosityR.configuration=false;
verbosityR.attributeDescription=false;
verbosityR.discretization=false;
verbosityR.structure=false;
verbosityR.individualAccuracy=false;
verbosityR.true_predictedValues=false;
verbosityR.euclideanDistance=false;
verbosityR.selectionScores=false;
verbosityR.progress=false;
//verbosityR.completeSample=false;
}

/*________________________________________________________*/


verbosityRecord getValue()
{
return verbosityR;
}

/*________________________________________________________*/


};

ostream& operator<<(ostream& out, VerbosityClass& p)
  {
 out << "\nVerbosity values:\t\t";
 if (p.verbosityR.accuracy)  out << "Accuracy,";
 if (p.verbosityR.selection)  out << "Selection,";
 if (p.verbosityR.parameters)  out << "Parameters,";
 if (p.verbosityR.configuration)  out << "Configuration,";
 if (p.verbosityR.attributeDescription)  out << "Attribute description,";
 if (p.verbosityR.discretization)  out << "Discretization,";
 if (p.verbosityR.structure)  out << "Structure,";
 if (p.verbosityR.individualAccuracy)  out << "Individual accuracy,";
 if (p.verbosityR.true_predictedValues)  out << "True/predicted values table,";
 if (p.verbosityR.euclideanDistance)  out << "Euclidean distance,";
 if (p.verbosityR.selectionScores)  out << "Selection scores,";
 if (p.verbosityR.progress)  out << "Show progress,";
 //if (p.verbosityR.completeSample)  out << "Complete sample,";
return out;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: VerbosityClass.h */
