/* File: Container.cpp */


#ifndef __Container_cpp__
#define __Container_cpp__




#include "Container.h"




/**
@memo Declaration of a list (FIFO)
@doc
*/


namespace BIOS
{

	/************************/
	/* list DEFINITION */
	/************************/


	/**
	@memo list

	  @doc
	  Definition:
	  A set of list's features
	  
		Memory space: O(SizeP), which SizeP being the number of elements in the list
		
		  @author Maria Mar Abad Grau<< "\n
		  @version 1.0
	*/





	/*______________________________________________________*/
	/*
	  template <class Cont, class T>
	void order (Container<Cont, T>* const & l, bool ascendant)
	{
	l->sort(ascendant);
	}

	 /*______________________________________________________*/
	/*
	  template <class Cont, class T>
	void order (Container<Cont, T*>* const  & l, bool ascendant)
	{
	l->sortPointer(ascendant);
	}

	 /*______________________________________________________*/

	template <class Cont, class T>
	ostream& operator<< ( ostream& out, Container<Cont, T>& l )
	{
		for ( typename Container<Cont, T>::iterator p = l.begin(); p != l.end(); p++ )
		{
			if ( p==l.begin() && l.leftDelimiter!='\0' ) out << l.leftDelimiter;
			out << *p;

			p++;
			if ( l.size() >1 && p!= l.end() && l.outputSeparator!='\0' ) out <<l.outputSeparator;
			if ( p==l.end() && l.rightDelimiter!='\0' ) out <<l.rightDelimiter;
			p--;
		}
		return out;
	}
	/*______________________________________________________*/

	template <class Cont, class T>
	ostream& operator<< ( ostream& out, Container<Cont, T*>& l )
	{
		for ( typename Container<Cont, T*>::iterator p = l.begin(); p != l.end(); p++ )
		{
			if ( p==l.begin() && l.leftDelimiter!='\0' ) out << l.leftDelimiter;
			if ( ( T* ) *p!=NULL ) out << **p;

			p++;
			if ( l.size() >1 && p!= l.end() && l.outputSeparator!='\0' ) out <<l.outputSeparator;
			if ( p==l.end() && l.rightDelimiter!='\0' ) out << l.rightDelimiter;
			p--;
		}
		return out;
	}


	/*______________________________________________________*/

//  template <>
//ostream& operator<<(ostream& out, Container<vector, long long int>& lista)
	/*
	   ostream& operator<<(ostream& out, longLongList& lista)
	  {
	out <<"(";
	    longLongList::iterator p=lista.getFirst();
	 while (p!=lista.end())
	    {
	         out << lista.getElement(p);
	         p=lista.getNext(p);
	        if (p!=lista.end()) out <<","; else out <<")";
	    }
	     out <<"\n";
	    return out;
	  }
	/*______________________________________________________*/
	/*
	   ostream& operator<<(ostream& out, intList& lista)
	  {
	out <<"(";
	    intList::iterator p=lista.getFirst();
	 while (p!=lista.end())
	    {
	         out << lista.getElement(p);
	         p=lista.getNext(p);
	        if (p!=lista.end()) out <<","; else out <<")";
	    }
	     out <<"\n";

	    return out;
	  }


	  /**********************************/
	/* DEFINITIONS OF THE FUNCTIONS */
	/**********************************/


	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( int size, int startingPoint, int way, char outputSeparator, char leftDelimiter, char rightDelimiter ) :Cont()
	{
		init ( outputSeparator, leftDelimiter, rightDelimiter );
		switch ( way )
		{
			case 1:
				for ( int i=0; i<size;i++ )
					this->insertElement ( startingPoint+i ); break;
			case 0:
				for ( int i=0; i<size;i++ )
					this->insertElement ( startingPoint ); break;
			case -1:
				for ( int i=0; i<size;i++ )
					this->insertElement ( startingPoint-i ); break;
			default: throw BadFormat ( "Container<Cont, T>::Container(int size, int startingPoint, int way, char outputSeparator, char leftDelimiter, char rightDelimiter):Cont()" );
				break;
		}
	}

	/*____________________________________________________________ */

	template <class Cont, class T>    template <class Cont2, class U> Container<Cont, T>::Container ( Container<Cont2, U> &source ) :Cont()
	{
		// this->outputSeparator=source.outputSeparator;
		for ( typename Container<Cont2, T>::iterator it=source.getFirst(); it!=source.end(); it++ )
			insertHardElement ( *it );

		init ( source.outputSeparator, source.leftDelimiter, source.rightDelimiter );
	}

	/*____________________________________________________________ */
	/*
	   template <class Cont, class T>    template <class Cont2, class U> Container<Cont, T>::Container( Container<Cont2, U*> &source):Cont()
	  {
	   // this->outputSeparator=source.outputSeparator;

	   for (typename Container<Cont2, T>::iterator it=source.getFirst(); it!=source.end(); it++)
	   insertElement(new U(*it));

	   init(source.elementsInHeap, source.outputSeparator, source.leftDelimiter, source.rightDelimiter);
	   }

	/*____________________________________________________________ */
	/*
	   template <class Cont, class T>
	Container<Cont, T>::Container( Container<Cont, T*> &source, typename Container< Cont, T*>::iterator first, typename Container<Cont, T*>::iterator last):Cont()
	  {
	for (typename Container<Cont,T>::iterator it=first; it!=last; it++)
	 this->insertHardElement(it);
	   init(source.outputSeparator, leftDelimiter, rightDelimiter);
	   }


	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( Container &source ) :Cont()
	{
		for ( typename Container<Cont,T>::iterator it=source.begin(); it!=source.end(); it++ )
		{
			this->insertHardElement ( *it );
		}
		init ( source.outputSeparator, source.leftDelimiter, source.rightDelimiter );
	}

	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( char outputSeparator, char leftDelimiter, char rightDelimiter ) :Cont()
	{
		init ( outputSeparator, leftDelimiter, rightDelimiter );
	}
	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( Container &source, typename Container< Cont, T>::iterator first, typename Container<Cont, T>::iterator last ) :Cont()
	{
		if ( first>last ) throw BadFormat ( "Container(Container &source, typename Container< Cont, T, STL2>::iterator first, typename Container<Cont, T>::iterator last" );
		for ( typename Container<Cont,T>::iterator it=first; it!=last; it++ )
			this->insertHardElement ( *it );


		/*
		   int iniPos=source.getPosition(first), lastPos=source.getPosition(last);
		   this->removeObjects(this->begin()+lastPos+1, this->end());
		   this->removeObjects(this->begin(), this->begin()+iniPos);
		*/
		init ( source.outputSeparator, source.leftDelimiter, source.rightDelimiter );
	}




	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( const char* filename, const char* tokens, char outputSeparator, char leftDelimiter, char rightDelimiter ) :Cont()
	{
		try
		{
			init ( outputSeparator, leftDelimiter, rightDelimiter );
			this->getInfo ( filename, tokens );
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from Container<Cont, T>::Container (const char* filename, const char* tokens, char outputSeparator, char leftDelimiter, char rightDelimiter)" );throw;};
	}

	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>::Container ( T* array, int size ) :Cont()
	{
		init();
		for ( int i=0; i<size;i++ )
			this->insertElement ( ( T& ) array[i] );
	}

	/*___________________________________________________________________________________________*/


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::clone()
	{
		Container<Cont, T>*result=new Container<Cont, T> ( *this );
		return result;
	}

	/*___________________________________________________________________________________________*/


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::emptyCopy()
	{
		Container<Cont,T>* result=clone();
		result->empty();
		return result;
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::init ( char outputSeparator, char leftDelimiter, char rightDelimiter )
	{
		this->outputSeparator=outputSeparator;
		this->leftDelimiter=leftDelimiter;
		this->rightDelimiter=rightDelimiter;
	}
	/*_____________________________________________ */

	template <class Cont, class T> int Container<Cont, T>::size() const
	{
		return ( int ) this->Cont::size();
	}

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::empty()
	{
//if (this->begin()!=this->end())
//cout <<"will empty" << this->size() <<" objects\n";
		this->removeObjects ( 0, this->size() );
	};
	/*____________________________________________________________ */

	template <class Cont, class T>   typename Container<Cont, T>::iterator Container<Cont, T>::getFirst()
	{
		return ( typename Container<Cont, T>::iterator ) this->begin();
	};

	/*____________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNext ( typename Container<Cont, T>::iterator iterator2 )
	{
		return ++iterator2;
	};
	/*____________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getPrevious ( typename Container<Cont, T>::iterator iterator2 )
	{
		return --iterator2;
	};

	/*____________________________________________________________ */

	template <class Cont, class T>  typename Container<Cont, T>::iterator Container<Cont, T>::getLast()
	{
		return ( typename Container<Cont, T>::iterator ) this->end();
	};

	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getFirstElement()
	{
		return this->front(); //getElement(this->end()); // this->front()
	};
	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getLastElement()
	{
		return this->back(); //getElement(this->begin()); //this->back();
	};
	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getElement ( typename Container<Cont, T>::iterator it )
	{
		return ( T& ) *it;
//return this->getElement(this->getPosition(it));
	};
	/*____________________________________________________________ */
	/*
	 Container<Cont, T>T* Container<Cont, T*, STL2>::getElement(typename Container<Cont, T*, STL2>::iterator it)
	{
	return (T*)*it;
	};


	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::setOutputSeparator ( char outputSeparator )
	{
		this->outputSeparator=outputSeparator;
	};

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::setDelimiters ( char leftDelimiter, char rightDelimiter )
	{
		this->leftDelimiter=leftDelimiter;
		this->rightDelimiter=rightDelimiter;
	};

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::insertElement ( typename Container<Cont, T>::iterator first, typename Container<Cont, T>::iterator second )
	{
		for ( typename Container<Cont, T>::iterator it=first; it!=second;it++ )
			insertElement ( *it );
// return this->insert(this->end(), first, second);
	};








	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElement ( T element )
	{
		this->insertElement ( ( const T& ) element, this->end() );
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElementAtPos ( T element, int pos )
	{
		try
		{
			insertElement ( ( const T& ) element, getNode ( pos ) );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from void Container<Cont, T>::insertElementAtPos (T element, int pos)" ); throw;};



	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElement ( T element, typename Container<Cont, T>::iterator it )
	{
//cout << "here\n";
		insert ( it, element );
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertElementFromString ( string s )
	{
		T e;
		insertElement ( fromString ( e, s ) );
	}


	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::getElement ( int position ) const
	{
		try
		{

			int i=0;
			for ( typename Container<Cont, T>::const_iterator it=this->begin(); it!=this->end(); it++ )
			{
				if ( i==position ) return ( T& ) *it;
				i++;
			};
			throw OutOfBounds ( position, this->size(), "Container<Cont, T>::getElement(int position) " );
		}
		catch ( OutOfBounds& ob ) {throw;}



//return this->at(position); for vectors this line would be equivalent

//return this->getElement(this->getNode(position));
	};





	/*____________________________________________________________ */
	/*
	// Container<Cont, T>
	template <template <class T, typename _Alloc=std::allocator<T> > class Vector<T>::Class, class T>
	//template < template < class T, typename _Alloc=std::allocator<T> > class classCont=vector, class T >
	 T&  Container<vector<T>, T>::getElement(int position)

	//template <> int& intV::getElement(int position)
	{
	return this->at(position);
	};


	/***************************************/

	template <class Cont, class T>
	void Container<Cont, T>::removeNode ( typename Container<Cont, T>::iterator it )
	{
//T val=this->getElement(it);
//
//this->removeNodeWithObject(p, it);
		if ( it==this->end() )  throw NullValue ( "void Container<Cont, T>::removeNode (typename Container<Cont, T>::iterator it)" );
		zap ( ( T& ) *it );
		this->erase ( it );

	};
	/***************************************/
	/*
	 Container<Cont, T>
	void Container<Cont, typename Selec<IsPrimitive<T>::r, T, void>::R NewT, STL2>::removeNodeWithObject(Primitive p, typename Container<Cont, T>::iterator it)
	{
	this->erase(it);
	}
	};
	/***************************************/

	template <class Cont, class T>
	void Container<Cont, T>::removeObjects ( typename Container<Cont, T>::iterator it, typename Container<Cont, T>::iterator it2 )
	{
//cout <<"now here\n";
		for ( typename Container<Cont, T>::iterator it1=it; it1!=it2; it1++ )
		{
//cout <<"erasing\n";
//zap(getElement(this->size()-1));
			zap ( ( T& ) *it1 );
//zap(getElement(it1));
//cout <<"end erasing\n";
// if only zap(&) is defined, as currently, zap(*it1) will give an error for containers of primitive types or of objets in the stack (no pinters))
// if zap(*&) and zap(&) are both defined, if zap(*it1) is written instead, function zap(T&) will be allways called, instead of zap(T*&) for those objects in the heap
		}
//cout <<"size is:" << size() <<"\n";
		this->erase ( it, it2 );

//cout <<"now size is:" << size() <<"\n";
	};
	/***************************************/

	template <class Cont, class T>
	void Container<Cont, T>::removeObjects ( int firstPos, int lastPos )
	{
		try
		{
// <<"here called\n";
			this->removeObjects ( this->getNode ( firstPos ), this->getNode ( lastPos ) );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  void Container<Cont, T>::removeObjects (int firstPos, int lastPos)" ); throw;};

	};



	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	typename Container<Cont, T>::iterator
	Container<Cont, T>::findElementContainingInternalElement ( U element )
	{
//cout <<" findinel" << *element <<"\n";
		for ( typename Container<Cont, T>::iterator p=this->getFirst();p!=this->end();p++ )
		{
			if ( this->getElement ( p )->findElement ( ( const U& ) element ) !=this->getElement ( p )->end() ) return p;
		}

		return this->end();

	};

	/*___________________________________________________________________________________*/
	/*

	  template <class Cont, class T>
	  template <class U>
	  typename Container<Cont, T>::iterator
	  Container<Cont, T>::findElementContainingEqualInternalElement (U element)
	  {
	    for (typename Container<Cont, T>::iterator p=this->getFirst();p!=this->end();p++)
	      if (this->getElement (p)->findEqualElement ( (const U&) element) !=this->getElement (p)->end() ) return p;

	    return this->end();

	  };

	  /*______________________________________________________*/

	/*
	template <>
	template <class U>
	SetOfCliques::iterator SetOfCliques::findElementContainingInternalElement(U& element)
	{
	Clique * clique;
	for (SetOfCliques::iterator p=this->getFirst();p!=this->end();p++)
	{
	clique=*p;
	for (Clique::iterator p2=clique->getFirst();p2!=clique->end();p2++)
		if (**p2==*element) return p;
	}
	return this->end();
	//return this->at(position);
	//return this->getElement(this->getNode(position));
	};

	 /*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::removeNode ( int position )
	{
		try
		{
			removeNode ( getNode ( position ) );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  void Container<Cont, T>::removeNode (int position)" ); throw;};

	};

	/*____________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNode ( int position )
	{
		if ( size() <position ) throw OutOfBounds ( size(), position, " template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getNode (int position)" );
		typename Container<Cont, T>::iterator it=this->begin();
		if ( position<0 ) return this->end();
		for ( int i=0;i<position;i++ ) ++it; return it;
	};
	/*____________________________________________________________ */


	template <class Cont, class T> int Container<Cont, T>::getPosition ( typename Container<Cont, T>::iterator it )
	{
		typename Container<Cont, T>::iterator it2;
		int pos=0;
		for ( it2=this->begin();it2!=it;++it2 )
		{
			++pos;
			if ( pos>size() ) throw OutOfBounds ( size(), pos, "template <class Cont, class T> int Container<Cont, T>::getPosition (typename Container<Cont, T>::iterator it)" );
		}
		if ( pos==size() ) return -1;
		return pos;
	};
	/*____________________________________________________________ */


	template <class Cont, class T>
	Container<set<Integer*>, Integer*>* Container<Cont,T>::getIntegerSetFromIntegerList()
	{
		Container<set<Integer*>, Integer*> *integerSet=new Container<set<Integer*>, Integer*> ( true );
		typename Container<vector<Integer*>, Integer*>::iterator p=this->getFirst();
		Integer* i;
		while ( p!=this->end() )
		{
			i=new Integer ( *this->getElement ( p ) );
			integerSet->insert ( i );
			zap ( i );
			p=this->getNext ( p );
		}
		return integerSet;
	}

	/*____________________________________________________________ */

	template <class Cont, class T> bool Container<Cont, T>::includes ( Container<Cont, T> * Source )
	{
		if ( Source==NULL )
		{
			cout <<"Error in Container<Cont, T>::includes";
			end();
		}

		if ( this->size() <Source->size() ) return false;
		typename Container<Cont,T>::iterator p=Source->getFirst();
		while ( p!=Source->end() )
		{
			if ( findElement ( getElement ( p ) ) ==this->end() ) return false;
			p=Source->getNext ( p );
		}
		return true;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::changeElementAtPos ( T element, int pos )
	{
		try
		{
			T& val=getElement ( pos );
			this->erase ( this->getNode ( pos ) );
//this->removeNode(pos);
			this->insertElementAtPos ( element, pos );
			return val;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from T& Container<Cont, T>::changeElementAtPos (T element, int pos)" ); throw;};

	}


	/*___________________________________________________________ */

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getClosestGreaterPointerToElement ( T argument, bool checkOrder )
	{
// precond: this must be ordered
		if ( checkOrder==true )
		{
			cout <<"Error in list<T>::getClosestGreaterPointerToElement, not ordered";
			exit ( 0 );
		}
		// it returns a pointer to the element in the list which has the closest upper value than argument
		typename Container<Cont, T>::iterator pk=this->getFirst();


		while ( pk!=this->end() )
		{

			if ( *this->getElement ( pk ) >*argument ) return pk;// change to make it works for primitive values

			pk=this->getNext ( pk );
		}
		return pk;
	};
	/*___________________________________________________________ */
	/*
	    Container<Cont, T>void Container<Cont, T>::readInfo (ifstream * is, char* tokens)
	  {

	char a,b;
	 a=is->get();
	 if (a!=EOF) b=is->get();
	int i =0;
	    while (a!=EOF && b!=EOF)
	    {
	     is->putback(b);
	     is->putback(a);
	    insertElement(readElement(is, tokens));
	a=is->get();
	 if (a!=EOF) b=is->get();
	i++;
	//cout << "\nsig: " << i;
	  }

	  }

	/*___________________________________________________________ */
	/*
	    Container<Cont, T>void Container<Cont, T>::readInfo (ifstream * is, char* tokens)
	  {

	    while (!is->eof())
	    {
	//     is->putback(b);
	//     is->putback(a);
	    insertElement(readElement(is, tokens));
	//a=is->get();
	 //if (a!=EOF) b=is->get();
	//cout << "\nsig: " << i;
	  }

	  }


	  /* _____________________________________________________*/


//virtual T readElement (ifstream * source, const char* tokens, int* pos=NULL, int size=0);

	/* _____________________________________________________*/


	template <class Cont, class T> T Container<Cont, T>::readElement ( ifstream * source, const char* tokens, int* pos, int size )
	{

		T  val, val2;
		char* genotypebuf=NULL;//new char[100000];//NULL;
		genotypebuf=CaptureLine ( source );
//cout << "buf is: " << genotypebuf << "\n";
		val2=BIOS::fromString ( val, string ( genotypebuf ) );
		zaparr ( genotypebuf );
		return val2;
	};
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::getInfo ( const char *FileName, const char* tokens, int* pos, int size )
	{
		try
		{
			ifstream InputFile;
			T element, el;
			OpenInput ( FileName, &InputFile );
			int i=0;
			while ( !InputFile.eof() && InputFile.peek() !=EOF && InputFile.peek() !='\n'  && InputFile.peek() !='\r' )
			{
				el=readElement ( &InputFile, tokens, pos, size );
				insertElement ( el );


			//	 cout <<"line " << i << "has been read\n";
				i++;
			}
			InputFile.close();
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  Container<Cont, T>::getInfo(,..." );throw;};

	};

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> bool Container<Cont, T>::hasElementsInHeap()
	{
		return BIOS::isAPointer ( ( T& ) *this->begin() );
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> void Container<Cont, T>::insertHardElement ( const T& element )
	{
// it should not work for Cont=set; if Cont=set, use just insert(element)
//cout << "lement " << element << " is about to be inserted\n";



//zap(*it1);

//const T& element2=element;
		/*T* element2;
		if (hasElementsInHeap()) { element2=new &T(*element); cout <<"HHHHH:\n" << element <<"\n";}
		else element2=(T*)&element;
		*/
		T element2=BIOS::clone ( ( T& ) element );// we need to use (T&) to consider whether is a pointer or not
		this->insertElement ( element2 );



//if (this->hasElementsInHeap()) {this->insertElement(element.clone()); cout <<"HHHHH:\n" << element <<"\n";}
//else {this->insertElement(element); } //cout <<"nohard:" << element <<"\n";}


//cout << "lsat element inserted was:" << getLastElement() <<"\n";

	}
	/*___________________________________________________________________________________________*/
	/*
	   template <class Cont, class T> void Container<Cont, T>::insertHardElement(const T*& element)
	  {
	cout <<"---------\n";
	this->insertElement(element);

	  }

	   /*___________________________________________________________________________________________*/

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement ( const T& element, bool usePointer )
	{
		try
		{
// if a primitive data, second argument is useless
// if not: if usePointer, identity will be used, if not, equivalency (status object) will be used in comparisons
			if ( !isAPointer ( ( T& ) element ) || usePointer )
				return find ( this->begin(), this->end(),  element );
			else return findEqualElement ( element );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from Container<Cont, T>::iterator Container<Cont, T>::findElement (const T& element, bool usePointer)" ); throw;};
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findEqualElement ( const T& element )
	{
		try
		{
//cout <<"element is: " << *element << "\n";
			for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
			{
//cout <<"INNN\n";
//cout <<"el" << **it <<"\n";
				if ( **it== *element )
				{
//cout <<"INNN2222\n";
					return it;
				}
//cout <<"INNN333\n";
			}
//cout <<"INNN44\n";
			return this->end();
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from typename Container<Cont, T>::iterator Container<Cont, T>::findEqualElement (const T& element)" ); throw;};
	}
	/*___________________________________________________________________________________________*/

// these are to prevent compilation errors in findEqualElements when using primitive data
	template <> stringList::iterator stringList::findEqualElement ( const string& element ) {};
	template <> stringSet::iterator stringSet::findEqualElement ( const string& element ) {};
	template <> intList::iterator intList::findEqualElement ( const int& element ) {};
	template <> intSet::iterator intSet::findEqualElement ( const int& element ) {};
	template <> doubleList::iterator doubleList::findEqualElement ( const double& element ) {};
	template <> doubleSet::iterator doubleSet::findEqualElement ( const double& element ) {};
	template <> floatList::iterator floatList::findEqualElement ( const float& element ) {};
	template <> floatSet::iterator floatSet::findEqualElement ( const float& element ) {};
	template <> longLongList::iterator longLongList::findEqualElement ( const long long& element ) {};
	template <> longLongSet::iterator longLongSet::findEqualElement ( const long long& element ) {};
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> bool Container<Cont, T>::operator== ( Container<Cont, T> & otherContainer )
	{
		if ( isAPointer ( this->getElement ( this->begin() ) ) ) return sameState ( &otherContainer );

		T element, element2;
		for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
		{
			element=this->getElement ( it );
			element2=otherContainer.getElement ( getPosition ( it ) );
			if ( ( element==element2 ) ==false ) return false;
		}
		return true;
	}

	/*___________________________________________________________________________________________*/

// these are to prevent compilation errors in sameState when using primitive data
	template <> bool stringList::sameState ( stringList* otherContainer ) {};
	template <> bool stringSet::sameState ( stringSet* otherContainer ) {};
	template <> bool intList::sameState ( intList* otherContainer ) {};
	template <> bool intSet::sameState ( intSet* otherContainer ) {};
	template <> bool doubleList::sameState ( doubleList* otherContainer ) {};
	template <> bool doubleSet::sameState ( doubleSet* otherContainer ) {};
	template <> bool floatList::sameState ( floatList* otherContainer ) {};
	template <> bool floatSet::sameState ( floatSet* otherContainer ) {};
	template <> bool longLongList::sameState ( longLongList* otherContainer ) {};
	template <> bool longLongSet::sameState ( longLongSet* otherContainer ) {};
	template <> bool Container<vector<allele>, allele>::sameState ( Container<vector<allele>, allele>* otherContainer ) {};
	template <> bool Container<Container<std::vector<float, std::allocator<float> >, float>, float>::sameState ( Container<Container<std::vector<float, std::allocator<float> >, float>, float>* otherContainer ) {throw NonImplemented ( "Container<Container<std::vector<float, std::allocator<float> >, float>, float>::sameState" );};
	template <> bool Container<Container<std::vector<int, std::allocator<int> >, int>, int>::sameState ( Container<Container<std::vector<int,
	        std::allocator<int> >, int>, int>* otherContainer ) {throw NonImplemented ( "Container<Container<std::vector<int, std::allocator<int> >, int>, int>::sameState" );};


	/*___________________________________________________________________________________________*/

	template <class Cont, class T> bool Container<Cont, T>::sameState ( Container<Cont, T> * otherContainer )
	{
		T element, element2;
		for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
		{
			element=this->getElement ( it );
			element2=otherContainer->getElement ( getPosition ( it ) );
			if ( ! ( * ( T& ) element==* ( T& ) element2 ) ) return false;
		}
		return true;
	}

	/*___________________________________________________________________________________________*/
	/*
	    template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement(const T*& element)
	  {
	cout <<"poo\n";
	//cout <<"\nbegin is:" << *this->begin(); // << ", and end is" << this->back();
	//return find(element);
	 return find(this->begin(), this->end(), (const T&) *element);
	  }

	    /*___________________________________________________________________________________________*/
	/*
	    template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::findElement(const T*& element)
	  {
	 return find(this->begin(), this->end(), *element);
	  }

	    	/*___________________________________________________________________________________*/
	/*
	   Container<Cont, T>typename Container<Cont, T>::iterator  Container<Cont, T>::findElementContainingInternalElement(void* element)//
	  {
	// it only works whether element 	T is another container (void is used to avoid compiling errors when this condition does not hold
	 iterator p=this->GetFirst();
	 T * secondContainer;
	 while (p!=this->end())
	{
		 secondContainer=getElement(p);
	  if (secondContainer->findElement((T&*)element)!=secondContainer->end()) return p;
	p=this->GetNext(p);
	}
	return end();

	  };

	/*____________________________________________________________ */

	template <class Cont, class T> T& Container<Cont, T>::operator[] ( int position ) const
	{
		return ( T& ) this->at ( position );

//return this->getElement(this->getNode(position));
	};
	/*____________________________________________________________ */

	template <class Cont, class T> T* Container<Cont, T>::getTable()
	{
		T*elements=new T[this->size() ];
		int i=0;
		typename Container<Cont, T>::iterator p=this->getFirst();
		while ( p!=this->end() )
		{
			elements[i]=this->getElement ( p );
			p=this->getNext ( p );
			i++;
		}
		return elements;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> T* Container<Cont, T>::toArray()
	{
		return getTable();
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	template <class Cont2, class U>
	Container<Cont2, U>* Container<Cont, T>::convertPrimitiveList ( Container<Cont2, U> * cont )
	{
//it converts among different primitive lists
		cont=new Container<Cont2, U>();
		for ( typename Container<Cont, T>::iterator p=this->begin(); p!=this->end();++p )
			cont->insertHardElement ( ( U ) *p );

		return cont;
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	template <class Cont2, class U>
	Container<Cont2, U>* Container<Cont, T>::getPrimitiveContainerFromPointerContainer ( Container<Cont2, U>* type )
	{
//it converts among different primitive lists
		Container<Cont2, U>* cont=new Container<Cont2, U>();
		for ( typename Container<Cont, T>::iterator p=this->begin(); p!=this->end();++p )
			cont->insertElement ( ( U ) ( ( T ) *p )->getValue() );

		return cont;
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	intList* Container<Cont, T>::getIntList()
	{
//it converts other primitive number list (like float or double) in an intList

		intList *primitiveList;
		return convertPrimitiveList ( primitiveList );
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	floatList* Container<Cont, T>::getFloatList()
	{
//it converts other primitive number list to a floatList
		floatList *primitiveList;
		return convertPrimitiveList ( primitiveList );
	}

	/*___________________________________________________________________________________________*/
	/*
	    Container<Cont, T>floatList* Container<Cont, T>::getFloatList()
	  {
	//it converts other primitive number list (like float or double) in an intList
	    floatList *primitiveList=new intList();
	    typename Container<Cont, T>::iterator p;
	    for (p=this->begin(); p!=this->end();++p)
	          primitiveList->insertElement((float)*p);

	    return primitiveList;
	  }
	  /*___________________________________________________________________________________________*/
	template <> intList* stringList::getListFromString()
	{
//it converts a stringList in an intList
		intList *primitiveList=new intList();
		int wilk;
		stringList::iterator p;
		for ( p=this->begin(); p!=this->end();++p )
			primitiveList->insertElement ( BIOS::fromString ( wilk, ( string ) *p ) );

		return primitiveList;
	}
	/*____________________________________________________________ */

	template <class Cont, class T>  double Container<Cont, T>::getMinDistance ( T arg1 )
	{
		return getDistance ( arg1, false );
	};
	/*____________________________________________________________ */

	template <class Cont, class T> double Container<Cont, T>::getMaxDistance ( T arg1 )
	{
		return getDistance ( arg1, true );
	};
	/*____________________________________________________________ */

	template <class Cont, class T>  double Container<Cont, T>::getDistance ( T arg1, bool max )
	{
		try
		{
			bool distance=true;
			bool atts=true;
			double result=MAXFLOAT, temp;
			if ( max ) result=-MAXFLOAT;
			for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end();it++ )
			{
				temp= ( double ) arg1->getDistance ( this->getElement ( it ) );
				if ( ( temp<result && !max ) || ( temp>result && max ) )
					result=temp;
			}
			return result;
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from  Container<Cont, T>::getDistance(T arg1, bool max, int* posArray, int length) " ); throw;};
	};

	/*____________________________________________________________ */



	template <class Cont, class T> template <class U> intSet* Container<Cont, T>::getPositionsWithExtremeDistance ( U element, bool max, int position, bool toLeft )
	{
		intSet*result=new intSet();
		//if (size()==0) return result;
		FreqAndKey *val;
		FreqAndKeyVector * distanceList= new FreqAndKeyVector();
		double extreme=MAXFLOAT;
		if ( max ) extreme=-extreme;
		double currentDistance;
		for ( typename Container<Cont, T>::iterator it=this->begin(); it!=this->end(); it++ )
		{


//arg1->getDistance (this->getElement (it) );

			currentDistance=element->getDistance ( *it, position, toLeft );
			if ( ( currentDistance>=extreme && max ) || ( currentDistance<=extreme && !max ) )
			{
				val=new FreqAndKey ( currentDistance, getPosition ( it ) );
				extreme=currentDistance;
				distanceList->insertElement ( val );
			}
		}
		if ( distanceList->size() ==0 ) throw NullValue ( "intSet* Container<Cont, T>::getPositionsWithExtremeDistance(T element, bool max)" );
		distanceList->sort ( !max );
		extreme=distanceList->getFirstElement()->first();
		FreqAndKeyVector::iterator it2=distanceList->begin();
		bool equal=true;
		int realPos;
		while ( it2!=distanceList->end() && equal )
		{
			realPos= ( int ) distanceList->getElement ( it2 )->second();
			if ( result->size() ==0 || distanceList->getElement ( it2 )->first() ==extreme )
				result->insertElement ( realPos );
			else equal=false;
			it2++;
		}
		zap ( distanceList );
		return result;
	};
	/*____________________________________________________________ */

	template <class Cont, class T> template <class U>  intSet* Container<Cont, T>::getPositionsWithMaxDistance ( U element, int position, bool toLeft )
	{
		return getPositionsWithExtremeDistance ( element, true, position, toLeft );
	}

	/*____________________________________________________________ */


	template <class Cont, class T> template <class U>  intSet* Container<Cont, T>::getPositionsWithMinDistance ( U element,int position, bool toLeft )
	{
		return getPositionsWithExtremeDistance ( element, false, position, toLeft );
	}


	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	intSet*
	Container<Cont, T>::getPositionsWithInternalExtremeDistance ( U element, bool max, int position, bool toLeft )
	{
		intSet* result=new intSet(), *partialResult=NULL;
		double currentDistance=-MAXFLOAT, distance;
		if ( !max ) currentDistance=MAXFLOAT;
		// cout << "current list is: " << *this <<"\n";
		// cout << "Element is: " << *element <<"\n";
		for ( typename Container<Cont, T>::iterator p=this->getFirst();p!=this->end();p++ )
		{
			partialResult=this->getElement ( p )->getPositionsWithExtremeDistance ( element, max, position, toLeft );
			//cout <<"\npartialresults for element " << *this->getElement(p) <<" are: " << *partialResults;
			if ( partialResult->size() >0 )
			{
				distance=this->getElement ( p )->getElement ( partialResult->getElement ( 0 ) )->getDistance ( element, position, toLeft );
				//  cout <<"\nthe distance from " << *this->getElement(p)->getElement(partialResult->getElement(0)) <<" to " << element <<" is " << distance;
				if ( ( max && distance>=currentDistance ) || ( !max && distance<=currentDistance ) )
				{
					if ( ( max && distance>currentDistance ) || ( !max && distance<currentDistance ) )
						result->empty();
					currentDistance=distance;
					result->insertElement ( this->getPosition ( p ) );
				}
			}
			zap ( partialResult );
		}
		//    cout <<"pos with min distance is: " << *result <<"\n";
		return result;
	};


	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	intSet*
	Container<Cont, T>::getPositionsWithInternalMinDistance ( U element, int position, bool toLeft )
	{
		return getPositionsWithInternalExtremeDistance ( element, false, position, toLeft );
	};


	/*___________________________________________________________________________________*/


	template <class Cont, class T>
	template <class U>
	intSet*
	Container<Cont, T>::getPositionsWithInternalMaxDistance ( U element )
	{
		return getPositionsWithInternalExtremeDistance ( element, true );
	};

	/*___________________________________________________________________________________________*/

	template <class Cont, class T> stringList* Container<Cont, T>::getStringList()
	{
//it converts a primitive number list to a stringList
		stringList* res;
		return this->toString ( res );
		/*
		    stringList*primitiveList=new stringList((bool)false);
		    typename Container<Cont, T>::iterator p;
		    for (p=this->begin(); p!=this->end();++p)
		          primitiveList->insertElement(tos(*p));

		    return primitiveList;
		*/
	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> stringList* Container<Cont, T>::toStringList()
	{
//it converts a primitive number list to a stringList
		return getStringList();
	}

	/*___________________________________________________________________________________________*/

	template <class Cont, class T>
	template <class Cont2, class U>
	Container<Cont2, U>* Container<Cont, T>::toString ( Container<Cont2, U>* type )
	{
		Container<Cont2, U> *primitiveList=new Container<Cont2, U> ();
		for ( typename Container<Cont, T>::iterator p=this->begin(); p!=this->end();++p )
			primitiveList->insertElement ( tos ( *p ) );

		return primitiveList;

	}
	/*___________________________________________________________________________________________*/

	template <class Cont, class T> T Container<Cont, T>::pop()
	{
		T val=this->back();
		this->pop_back();
		return val;
	}

	/*___________________________________________________________________________________________*/
	/*
	     template <class Cont, class T> intList* Container<Cont, T>::getIntListFromPointerList()
	  {
	    intList *primitiveList=new intList();
	    typename Container<Cont, T>::iterator p=this->getFirst();
	    while (p!=this->end())
	    {
	      primitiveList->insertElement(this->getElement(p)->getValue());
	      p=this->getNext(p);
	    }
	    return primitiveList;
	  }
	  /*___________________________________________________________________________________________*/

	template <> Container<vector<Integer*>, Integer*>* intList::getIntegerList()
	{
		Container<vector<Integer*>, Integer*> *integerList=new Container<vector<Integer*>, Integer*> ( true );
		intList::iterator p=this->getFirst();
		Integer* i;
		while ( p!=this->end() )
		{
			i=new Integer ( *p );
			integerList->insertHardElement ( i );
			p=this->getNext ( p );
		}
		return integerList;
	}
	/*___________________________________________________________________________________________*/

//template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator>
// template <>
	template <>
	IntegerSet* intList::getIntegerSet()
	{
		Container<vector<Integer*>, Integer*> *integerList=this->getIntegerList();
		IntegerSet *integerSet=integerList->getIntegerSetFromIntegerList();
		zap ( integerList );

		return integerSet;
	}

	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElements ( bool* table )
	{
		throw NonImplemented ( "Container<Cont, T>::removeElements(bool* table)" );
		/*
		    int i=0;
		    typename Container::iterator p=getFirst(), p2;
		    while (p!=this->end())
		    {
		      if (table[i])
		{
		       this->removeNode(p);
		}
		      p=this->getNext(p);
		      i++;
		     }
		*/
	}
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElementsIn ( Container<Cont, T>* sourceList )
	{
		try
		{
			if ( sourceList==NULL )
			{
				cout <<"Error in list::selectElementsByContents";
				end();
			}

			typename Container::iterator p=sourceList->getFirst(), p2;
			while ( p!=sourceList->end() )
			{
				if ( this->findElement ( sourceList->getElement ( p ) ) !=this->end() )
					this->removeNode ( find ( this->begin(), this->end(), sourceList->getElement ( p ) ) );
				p=sourceList->getNext ( p );
			}
		}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from void Container<Cont, T>::removeElementsIn (Container<Cont, T>* sourceList)" );throw;};
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsByContents ( Container<Cont, T>* sourceList, bool within, bool orderedByThis )
	{
		if ( within && !orderedByThis ) throw NonImplemented ( "template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsByContents (Container<Cont, T>* sourceList, bool within, bool orderedByThis)" );

		if ( !within && !orderedByThis ) throw NonImplemented ( "template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsByContents (Container<Cont, T>* sourceList, bool within, bool orderedByThis)" );// non sense
		if ( sourceList==NULL )
		{
			cout <<"Error in list::selectElementsByContents";
			end();
		}

		intList* newList=new intList ( ( bool ) false, this->outputSeparator, this->leftDelimiter, this->rightDelimiter );
		typename Container<Cont,T>::iterator p2;
		for ( typename Container<Cont, T>::iterator p=this->getFirst(); p!=this->end(); p++ )
		{
			p2=sourceList->findElement ( *p );
			if ( ( !within && p2==sourceList->end() ) || ( within && p2!=sourceList->end() ) )
			{
				newList->insertElement ( this->getPosition ( p ) );
			}
		}

		return newList;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsByContents ( Container<Cont, T> * Source, bool within, bool orderedByThis )
	{
		// type=0: common, 1: different
//cout <<"2spaatorthisis" << this->outputSeparator <<"her\n";

		intList* newList=this->copyPositionsByContents ( Source, within );
//cout <<"intsize:" << newList->size() <<"\n";
//cout <<"2spaatornewsis" << newList->outputSeparator <<"her\n";
		Container<Cont, T> *result=this->copyElementsWithPositionsIn ( newList, orderedByThis );
		zap ( newList );
		return result;
	}


	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( intList* sourceList, bool orderedByThis )
	{
		try
		{
			longLongList* other=new longLongList();
			for ( intList::iterator it=sourceList->begin(); it<sourceList->end(); it++ )
				other->insertElement ( sourceList->getElement ( it ) );
			Container<Cont, T>* newList=copyElementsWithPositionsIn ( other, orderedByThis );
			zap ( other );
			return newList;
		}
		catch ( BasicException be ) {be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn (intList* sourceList, bool orderedByThis)" ); throw;};
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( longLongList* sourceList, bool orderedByThis )
	{
		try
		{
			if ( sourceList==NULL ) throw NullValue ( "Error 1 in Container::copyElementsByPositions" );
// cout <<"orderedByThis: " << orderedByThis << "\n";
			Container<Cont, T>* newList=this->emptyCopy();
			longLongList* sourceList2=new longLongList ( *sourceList );
			int pos=0;
 //  cout << "list is:" << *sourceList2 << "\n";
			if ( orderedByThis )
				for ( typename Container::iterator p=this->begin();p!=this->end();p++ )
				{
					while ( sourceList2->findElement ( pos ) !=sourceList2->end() )
					{
    // cout << "found element at pos " << pos << " to be " << *p << "and will cop\n";
						newList->insertHardElement ( *p );
						sourceList2->removeNode ( sourceList2->findElement ( pos ) );
					}
					pos++;
				}
			else
				for ( longLongList::iterator p2=sourceList->getFirst();p2!=sourceList->end();p2++ )        newList->insertHardElement ( *this->getNode ( *p2 ) );

			delete sourceList2;
			return newList;
		}
		catch ( BasicException  & be ) {be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn (longLongList* sourceList, bool orderedByThis)" ); throw;};
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( intList* sourceList )
	{
//   cout <<"original positions list that will not be used:" << *sourceList <<"\n";
		longLongList* other=new longLongList();
		for ( intList::iterator it=sourceList->begin(); it<sourceList->end(); it++ )
			other->insertElement ( sourceList->getElement ( it ) );

//cout <<"new original positions list that will not be used:" << *sourceList <<"\n";
		Container<Cont, T>* newList=copyElementsWithoutPositionsIn ( other );
		zap ( other );
		return newList;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( longLongList* sourceList )
	{
		if ( sourceList==NULL ) throw NullValue ( "Error 1 in Container::copyElementsWithoutPositionsIn" );

		Container<Cont, T>* newList=new Container<Cont, T>();
	int pos=0;

		for (typename Container::iterator p=this->getFirst();p!=this->end();p++ )
		{
			if ( sourceList->findElement ( pos ) ==sourceList->end() )
				newList->insertHardElement ( *p );
			pos++;
		}

		return newList;
	}

	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithPositionsIn ( intSet* sourceSet, bool orderedByThis )
	// type 0; copywith, 1: copyWithout
	{
		intList* sourceList=new intList ( *sourceSet );
		Container<Cont, T>* result=copyElementsWithPositionsIn ( sourceList, orderedByThis );

		zap ( sourceList );

		return result;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::copyElementsWithoutPositionsIn ( intSet* sourceSet )
	// type 0; copywith, 1: copyWithout
	{
		intList* sourceList=new intList ( *sourceSet );
		Container<Cont, T>* result=copyElementsWithoutPositionsIn ( sourceList );
		zap ( sourceList );
		return result;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::removeElementsWithPositionsIn ( intSet* sourceSet )
	// type 0; copywith, 1: copyWithout
	{
			if ( sourceSet==NULL ) throw NullValue ( "void Container<Cont, T>::removeElementsWithoutPositionsIn ( intSet* sourceSet )" );

		intList* sourceList=new intList ( *sourceSet );
  sourceList->sort(false);



		for (typename intList::iterator p=sourceList->getFirst(); p!=sourceList->end(); p++) 
		 removeNode(this->getNode(*p));

		zap(sourceList);
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsByPositions ( intSet* sourceList, bool within, bool orderedByThis )
	// type 0: extractWith, 1: extractWithout
	{
		try
		{
			Container<Cont, T>* newList;
			if ( within )
			{
				newList=copyElementsWithPositionsIn ( sourceList, orderedByThis );
				this->removeElementsWithPositionsIn ( sourceList );
			}
			else
			{
				newList=copyElementsWithoutPositionsIn ( sourceList );
// remove elements
		//		this->removeElementsWithPositionsIn ( sourceList );to define
				throw NonImplemented ( "Container<Cont, T>* Container<Cont, T>::extractElementsByPositions (intSet* sourceList, bool within, bool orderedByThis)" );
			}
			return newList;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled fromContainer<Cont, T>* Container<Cont, T>::extractElementsByPositions (intSet* sourceList, bool within, bool orderedByThis)" ); throw;};
	};

	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::mergeWith ( Container<Cont, T>* secondList )
	{

		Container<Cont, T>* result=new  Container<Cont, T>();

		merge ( this->begin(), this->end(),  // merge sequences
		        secondList->begin(), secondList->end(),
		        result->begin() );


		/*
		   Container<Cont, T>* result=new  Container<Cont, T>();
		   typename Container<Cont, T>::iterator p=this->GetFirst(), p2=secondList->GetFirst();
		   while (p!=this->end() || p2!=NULL)
		 {
		 while (p!=this->end() &&
		(p2!=NULL && this->GetElement(p)>=secondList->GetElement(p2)) || p2==NULL)
		{
		  result->insertElement(GetElement(p));
		  p=this->GetNext(p);
		}
		 while (p2!=NULL &&
		(p!=this->end() && this->GetElement(p)<secondList->GetElement(p2)) || p==NULL)
		{
		  result->insertElement(secondList->GetElement(p2));
		  p2=secondList->GetNext(p2);
		}
		 }
		*/
		return result;
	}



	/*____________________________________________________________ */


	template <class Cont, class T> void Container<Cont, T>::copyPaste ( Container<Cont, T>* sourceList, int firstPosition, int nextOfLastPosition )
	{
		Container<Cont, T>* copy=sourceList->copyPaste ( firstPosition, nextOfLastPosition );
		this->insertElement ( copy->begin(), copy->end() );
	};


	/*____________________________________________________________ */


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::copyPaste ( int firstPosition, int nextOfLastPosition )
	{
		try
		{
			Container<Cont, T>* result=this->clone();
			result->removeObjects ( result->getNode ( nextOfLastPosition ), result->end() );
			result->removeObjects ( result->begin(), result->getNode ( firstPosition ) );
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::copyPaste (int firstPosition, int nextOfLastPosition)" ); throw;};

	};

	/*____________________________________________________________ */


	template <class Cont, class T> void Container<Cont, T>::paste ( Container<Cont, T>* sourceList, int firstPosition, int nextOfLastPosition )
	{
		try
		{
			this->insertElement ( sourceList->getNode ( firstPosition ), sourceList->getLastTrueNode ( nextOfLastPosition ) );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from void Container<Cont, T>::paste (Container<Cont, T>* sourceList, int firstPosition, int nextOfLastPosition)" ); throw;};

	};


	/*____________________________________________________________ */


	template <class Cont, class T> typename Container<Cont, T>::iterator Container<Cont, T>::getLastTrueNode ( int position )
	{
		try
		{
			if ( position==-1 ) return getNode ( size() ); else return getNode ( position );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from Container<Cont, T>::iterator Container<Cont, T>::getLastTrueNode (int position)" ); throw;};

	};

	/*____________________________________________________________ */


	template <class Cont, class T>  Container<Cont, T>* Container<Cont, T>::paste ( int firstPosition, int nextOfLastPosition )
	{
		try
		{
			Container<Cont, T>* result=this->emptyCopy();
			result->insertElement ( this->getNode ( firstPosition ), this->getLastTrueNode ( nextOfLastPosition ) );
			return result;
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from Container<Cont, T>* Container<Cont, T>::paste (int firstPosition, int nextOfLastPosition)" ); throw;};

	};



	/*____________________________________________________________ */


	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithPositionsIn ( intSet * sourceList )
	{
		return extractElementsByPositions ( sourceList, true );
	};
	/*____________________________________________________________ */


	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::extractElementsWithoutPositionsIn ( intSet * sourceList )
	{
		return extractElementsByPositions ( sourceList, false );
	};

	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>* Container<Cont, T>::copyElementsIn ( Container<Cont, T> * Source, bool orderedByThis )
	{
		return copyElementsByContents ( Source, true, orderedByThis );
	}
	/*____________________________________________________________ */

	template <class Cont, class T>
	Container<Cont, T>* Container<Cont, T>::copyElementsNotIn ( Container<Cont, T> * Source, bool orderedByThis )
	{
		return copyElementsByContents ( Source, false, orderedByThis );
	}
	/*____________________________________________________________ */
	/*
	    template <class Cont, class T> intSet * Container<Cont, T>::copyPositionsWithElementsInUnrepeatedList(Container<Cont, T> * Source, bool orderedByThis)
	  {
	    intList* list= copyPositionsByContents(Source, true);
	    intSet* result=new intSet(*list);
	    zap(list);
	    return result;
	  }
	/*____________________________________________________________ */

	template <class Cont, class T> intSet * Container<Cont, T>::copyPositionsWithElementsInSet ( Container<set<T>,T> * Source, bool orderedByThis )
	{
		Container<vector<T>,T>* source=new Container<vector<T>,T> ( *Source );
		intList* list= copyPositionsByContents ( source, true );
		intSet* result=new intSet ( *list );
		zap ( source );
		zap ( list );
		return result;
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsWithElementsIn ( Container<Cont, T> * Source, bool orderedByThis )
	{
		return copyPositionsByContents ( Source, true, orderedByThis );
	}
	/*____________________________________________________________ */

	template <class Cont, class T> Container<vector<int>,int> * Container<Cont, T>::copyPositionsWithoutElementsIn ( Container<Cont, T>* Source )
	{
		return copyPositionsByContents ( Source, false );
	}

	/*____________________________________________________________ */

	/*
	 Container<Cont, T>
	void Container<Cont, T>::sort(typename Container<Cont, T>::ierator begin, typename Container<Cont, T>::iterator end, Compare comp)
	{
	return std::sort(begin, end, comp);
	}


	/*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::shuffle()
	{
		try
		{
			int originalSize=this->size();
			Sampling *sampling=new Sampling ( this->size() );
			for ( int i=0; i<originalSize;i++ )
				insertElement ( this->getElement ( sampling->getPositionsTable() [i] ) );
			erase ( this->getNode ( 0 ), this->getNode ( originalSize ) );
			zap ( sampling );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from void Container<Cont, T>::shuffle()" ); throw;};

	}
	/*____________________________________________________________ */

	/*
	 template <class Cont, class T>
	void Container<Cont, T>::sortPointer(bool ascendant)
	{
	//struct Compare<T> compare;
	//struct CompareInv<T> compareinv;

	//throw NonImplemented("Container<Cont, T>::order(bool ascendant)");
	//__gnu_cxx::__normal_iterator<Container<Cont, T> > it=this->getFirst();
	if (ascendant) std::sort((typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), comparePointer<T>);
	else std::sort((typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), compareInvPointer<T>);
	};

	/*____________________________________________________________ */

	template <class Cont, class T>
	void Container<Cont, T>::sort ( bool ascendant )
	{

//    if (ascendant) std::sort ( (typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), BIOS::compare<T>);
//    else std::sort ( (typename Container<Cont, T>::iterator) this->getFirst(), (typename Container<Cont, T>::iterator) this->getLast(), BIOS::compareInv<T>);
		if ( ascendant ) std::sort ( this->getFirst(), this->getLast(), BIOS::compare<T> );
		else std::sort ( this->getFirst(), this->getLast(), BIOS::compareInv<T> );
	};


	/*____________________________________________________________ */

	template <class Cont, class T> void Container<Cont, T>::orderFunction ( bool compareArg ( const T& arg1, const T& arg2 ) )
	{
		sort ( this->begin(), this->end(), compareArg );
	};
	/*____________________________________________________________ */
	/*
	 Container<Cont, T>void Container<Cont, T>::orderPointer(bool ascendant)
	{
	 if (ascendant) sort(this->begin(), this->end(), comparePointer<T>);
	 else sort(this->begin(), this->end(), compareinvPointer<T>);
	};
	/*____________________________________________________________ */
	/*
	 Container<Cont, T>void Container<Cont, T>::orderPointer(bool compareArg(const T& arg1, const T& arg2))
	{
	sort(this->begin()/vector, this->end(), compareArg);
	};
	/*____________________________________________________________ */
	/*
	template <class Cont, class T> void Container<Cont, T>::basicOrder()
	{
	 sort(this->begin(), this->end());
	 };
	/*____________________________________________________________ */

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::reverse()
	{
		Container<Cont, T>* result=new Container<Cont, T>();
		typename Container<Cont, T>::iterator p=this->GetLast();
		while ( p!=this->end() )
		{
			result->insertHardElement ( *p );
			p=this->GetPrevious ( p );
		}
		return result;
	}

	/* _____________________________________________________*/

	template <class Cont, class T> Container<Cont, T>* Container<Cont, T>::fromString ( string s )
	{
		throw NonImplemented ( "Container<Cont, T>" );
	}

	template <class Cont, class T>
	void Container<Cont, T>::print()
	{
		cout << *this << endl;
	}

	/*____________________________________________________________ */

	/*
	template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator>
	struct IT
	{
	typedef Container<Cont, T>::iterator Class;
	};

	template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator>
	T& IT::Class::getElement()
	{
	return (T&)*this;
	}
	*/
	/*
	template <class T>
	T& std::_Rb_tree_const_iterator<T>::getElement()
	{
	return (T&)*this;
	}
	*/

} // end namespace
#endif

/* Fin Fichero: list.cpp */
// void zap<list<float>::node*>(list<float>::node*&);

//BIOS::Container::Container< Cont, T >(char * file, const char * tokens, char outputSeparator, bool delimiter)
//{
//}


