/* File: Container.h */


#ifndef __Container_h__
#define __Container_h__





/**
    @memo Declaration of a Container (FIFO)
    @doc
    */

// //using namespace UTILS;

namespace BIOS
{
  /************************/
  /* Container DEFINITION */
  /************************/
//template <class T> class list: public vector<T>{};
//typedef vector ListOfPointers;

  /**
          @memo Container
   
  	@doc
          Definition:
          A set of Container's features
   
          Memory space: O(SizeP), which SizeP being the number of elements in the Container
   
      @author Maria M. Abad Grau
  	@version 1.0
  */


// template <template<class T, class _Compare = std::less<T>, class _Alloc = std::allocator<T> > class Cont, class T> class AssociateContainer;
//typedef template <class T>  vector<T> list;

  //template <class T> class Set;

//template <template<class T> class Cont> class Container: public Cont<T>



  class ListOfAttributes;
  class DistanceMethodClass;

  template <class Cont, class T>
  class Container: public Cont
  {


    public:

      char outputSeparator;

      char leftDelimiter, rightDelimiter;






    public:




      Container (const char* file, const char* tokens=NULL, char outputSeparator=' ', char leftDelimiter='\0', char rightDelimiter='\n')  ;
      Container<Cont, T> (T* array, int size);

      Container (char outputSeparator=' ', char leftDelimiter='\0', char rightDelimiter='\n');
      Container (int size, int startingPoint, int way=1, char outputSeparator=' ', char leftDelimiter='\0', char rightDelimiter='\n');
      Container (Container &source, typename Container::iterator first, typename Container::iterator last);
// Container<Cont, T>(ArrayList &source, Sampling* sampling);


      Container (Container &source);

      template <class Cont2, class U> Container (Container<Cont2, U> & source);
//template <class Cont2, class U> Container(Container<Cont2, U*> & source);





      bool hasElementsInHeap();



      void insertElementFromString (string s);

      int size() const;
      T& changeElementAtPos (T element, int pos);

//  Container(typename Container::iterator first, typenamfe Container::iterator last, char outputSeparator=' ', bool delimiter=false);
// Container(const Container &source);


      void init (char outputSeparator=' ', char leftDelimiter='\0', char rightDelimiter='\n');


//template <template <class, class> class Cont2, class T2, template<class> class STL2B>
//  typename Container<Cont, T>::iterator  findElementContainingInternalElement(T2 element);

      static Container<Cont, T>* fromString (string s);

      template <class U> typename Container<Cont, T>::iterator  findElementContainingInternalElement (U element);//
     // template <class U> typename Container<Cont, T>::iterator  findElementContainingInternalElement (U element);//

      typename Container<Cont, T>::iterator findElement (const T& value, bool usePointers=false);
      typename Container<Cont, T>::iterator findEqualElement (const T & value);

//typename Container<Cont, T>::iterator findElementContainingInternalElement(void* value);

      virtual ~Container() {this->empty();};

//void readInfo (ifstream * is, char* tokens=NULL);

      virtual T readElement (ifstream * source, const char* tokens, int* pos=NULL, int size=0);

      void getInfo (const char *FileName, const char* tokens=NULL, int* pos=NULL, int size=0);

      void insertElement (T element);

      void insertHardElement (const T& element);

//void insertHardElement(const T*& element);

      void insertElement (typename Container<Cont, T>::iterator first, typename Container<Cont, T>::iterator second);


      T* getTable();

      T* toArray();

      T pop();

      void insertElementAtPos (T element, int pos);
      virtual void insertElement (T element, typename Container<Cont, T >::iterator it);
      void sort (bool ascendant=true);
//void sortPointer(bool ascendant=true);
      void orderFunction (bool compare (const T& arg1, const T& arg2) );
//void orderPointer(bool ascendant=true);
//void orderPointer(bool compare(const T& arg1, const T& arg2));
      void basicOrder();
      void shuffle();
      void empty();
      bool includes (Container<Cont, T>* source);
      typename Container<Cont, T>::iterator getFirst();
      typename Container<Cont, T>::iterator getNext (typename Container<Cont, T>::iterator iterator2);
      typename Container<Cont, T>::iterator getPrevious (typename Container<Cont, T>::iterator iterator2);
      typename Container<Cont, T>::iterator getLast();
      T& getFirstElement();
      T& getLastElement();
      T& getElement (typename Container<Cont, T>::iterator it) ;
//T* getElement(typename Container<Cont, T*, STL2>::iterator it);
      T& getElement (int position) const ;

      T& operator[] (int position) const;

      void removeObjects (typename Container<Cont, T>::iterator it, typename Container<Cont, T>::iterator it2);
      void removeObjects (int firstPos, int lastPos);
//void removeNode(typename Container<Cont, T>::iterator it, typename Container<Cont, T>::iterator it2);
      void removeNode (typename Container<Cont, T>::iterator it) ;
//void removeNodeWithObject(typename Container<Cont, T>::iterator it) ;
//void removeNodeWithObject(typename IsPrimitive<T>::Class isPrimitive, typename Container<Cont, T>::iterator it);
//void removeNodeWithObject(NonPrimitive isPrimitive, typename Container<Cont, T>::iterator it);

      void removeNode (int position);
//void removeNodeWithObject(int position);
      typename Container<Cont, T>::iterator getNode (int position);
      int getPosition (typename Container<Cont, T>::iterator it) ;

      virtual bool operator==(Container<Cont, T>& otherContainer);
      virtual bool sameState (Container<Cont, T>* otherContainer);

      virtual Container<Cont, T> *clone();
      virtual Container<Cont, T> *emptyCopy();


      typename Container<Cont, T>::iterator getLastTrueNode (int lastPosition);
      Container<Cont, T>* copyPaste (int firstPosition, int lastPosition);
      void copyPaste (Container<Cont, T>* source, int firstPosition=0, int lastPosition=-1);
      Container<Cont, T>* paste (int firstPosition=0, int lastPosition=-1);
      void paste (Container<Cont, T>* source, int firstPosition=0, int lastPosition=-1);

// Container<Cont, T>(const Container<T,Cont>& other){cout <<"Container(const) not implemented yet"; end();};
//Container<Cont, T>(Container<T,Cont>& other){cout <<"Container(&) not implemented yet"; end();};
//  Container<Cont, T>(Container<T,Cont>& other, typename Container<Cont, T>::NodePointer first=NULL, typename Container<Cont, T>::NodePointer last=NULL):Cont<T>(other, first, last){};

      Container<vector<int>,int> * copyPositionsByContents (Container<Cont, T>* c, bool within, bool orderedByThis=true);
      Container<Cont, T>* copyElementsByContents (Container * Source, bool within, bool orderedByThis=true);
      Container<Cont, T>* copyElementsIn (Container* Source, bool orderedByThis=true);
      Container<Cont, T>* copyElementsNotIn (Container * Source, bool orderedByThis=true);
      Container<vector<int>,int> * copyPositionsWithElementsIn (Container<Cont, T>* Source, bool orderedByThis=true);
      Container<vector<int>,int> * copyPositionsWithoutElementsIn (Container<Cont, T>* Source);
//  intSet * copyPositionsWithElementsInUnrepeatedList(Container<Cont, T>* Source, bool orderedByThis=true);
      Container<set<int>,int>  * copyPositionsWithElementsInSet (Container<set<T>, T>* Source, bool orderedByThis=true);
      Container<Cont, T>* copyElementsWithoutPositionsIn (Container<set<int>,int>  * sourceList);
      Container<Cont, T>* copyElementsWithoutPositionsIn (Container<vector<long long int>, long long int>  * sourceList);
      Container<Cont, T>* copyElementsWithoutPositionsIn (Container<vector<int>,int>  * sourceList);
      Container<Cont, T>* copyElementsWithPositionsIn (Container<set<int>,int>  * sourceList, bool orderedByThis=true);
      Container<Cont, T>* copyElementsWithPositionsIn (Container<vector<int>,int> * sourceList, bool orderedByThis=true);
      Container<Cont, T>* copyElementsWithPositionsIn (Container<vector<long long int>, long long int> * sourceList, bool orderedByThis=true);
      Container<Cont, T>* extractElementsWithoutPositionsIn (Container<set<int>,int>  * sourceList);
      Container<Cont, T>* extractElementsWithoutPositionsIn (Container<vector<int>,int> * sourceList);
      Container<Cont, T>* extractElementsWithPositionsIn (Container<set<int>,int>  * sourceList);
      Container<Cont, T>* extractElementsWithPositionsIn (Container<vector<int>,int> * sourceList);
      Container<Cont, T>* extractElementsByPositions (Container<set<int>,int>  * sourceList, bool within, bool orderedByThis=true);
      Container<Cont, T>* extractElementsByPositions (Container<vector<int>,int> * sourceList, bool within, bool orderedByThis=true);
      Container<Cont, T>* mergeWith (Container<Cont, T>* secondList); // Not working...segmentation fault

      void removeElementsIn (Container* Source);
						void removeElementsWithPositionsIn (Container<set<int>,int>* Source);
      void removeElements (bool* table);
      Container< set<Integer*>, Integer* >* getIntegerSet();


      Container<vector<Integer*>, Integer*>* getIntegerList();


      template <class Cont2, class U>
      Container<Cont2, U>* getPrimitiveContainerFromPointerContainer (Container<Cont2, U>* type);
      Container<vector<int>,int>* getListFromString();
      Container<vector<string>, string>* getStringList();
      Container<vector<int>,int>* getIntList();
      Container<vector<float>, float>* getFloatList();

      Container<Cont, T>* reverse();

      Container<Cont, T>* removeSubsets ();
      Container<Cont, T>* getCommonNodes (Container<Cont, T>* otherSet);
      bool comparison (Container<Cont, T> & Source, int type);



      Container<set<Integer*>, Integer*>* getIntegerSetFromIntegerList();

      void setOutputSeparator (char outputSeparator);

      void setDelimiters (char leftDelimiter, char rightDelimiter);

      bool operator== (const Container<Cont, T>& otherContainer); //throw NonImplemented("Container::operator==");};

      template <class Cont2, class U>
      Container<Cont2, U>* convertPrimitiveList (Container<Cont2, U>* type);

      template <class Cont2, class U> Container<Cont2, U>* toString (Container<Cont2, U>* type);


      Container<vector<string>, string>* toStringList();

//template <class Cont2<class T> > Container<Cont2, U>* toString(Container<Cont2, U>* type);



      double getDistance (T element, bool max);

      double getMinDistance (T element);

      double getMaxDistance (T element);
		
		void print();


       template <class U> Container<set<int>, int>* getPositionsWithExtremeDistance (U element, bool max,int position=0, bool toLeft=false);

      template <class U>  Container<set<int>, int>*  getPositionsWithMaxDistance (U element, int position=0, bool toLeft=false);
      template <class U>  Container<set<int>, int>*  getPositionsWithMinDistance (U element, int position=0, bool toLeft=false);

      template <class U>  Container<set<int>, int>* getPositionsWithInternalExtremeDistance (U element, bool max, int position=0, bool toLeft=false);
					 template <class U>  Container<set<int>, int>* getPositionsWithInternalMaxDistance (U element);
 					template <class U>  Container<set<int>, int>* getPositionsWithInternalMinDistance (U element,  int position=0, bool toLeft=false);


      typename Container<Cont, T>::iterator getClosestGreaterPointerToElement (T argument, bool checkOrder=true);




  };  // End of class Container





  /*

  typedef Container<int, list> intList;
  typedef Container<float, list> floatList;
  typedef Container<double, list> doubleList;
  typedef Container<string, list> stringList;

  typedef Container<Integer, ListOfPointers> IntegerList;

  */




  template <class T>
  struct Vector
  {
    typedef Container<vector<T>, T> Class;
  };


  template <class Cont>
  struct BoolContainer
  {
    typedef Container<Cont, bool> Class;
  };

  class Node;



  typedef Vector<bool>::Class boolVector;
  typedef Vector<int>::Class intVector;
  typedef Vector<unsigned int>::Class unsignedIntVector;
  typedef Vector<float>::Class floatVector;
  typedef Vector<double>::Class doubleVector;
  typedef Vector<string>::Class stringVector;
  typedef Vector<long long int>::Class longLongVector;
  typedef boolVector boolList;
  typedef intVector intList;
  typedef floatVector floatList;
  typedef doubleVector doubleList;
  typedef stringVector stringList;
  typedef longLongVector longLongList;

  typedef Vector<Integer*>::Class IntegerVector;
  typedef Vector<Integer*>::Class IntegerList;

  typedef Vector<Node*>::Class NodeList;


  typedef HeteroPair<double, long long int> FreqAndKey;
  typedef Pair<long long int> PairOfLongs;
  typedef Pair<double> PairOfDoubles;


  typedef Vector<FreqAndKey*>::Class FreqAndKeyVector;
  typedef Vector<PairOfLongs*>::Class PairOfLongsVector;
  typedef Vector<PairOfDoubles*>::Class PairOfDoublesVector;

  class Haplotype;

  typedef Vector<Haplotype*>::Class HaplotypeVector;


  class LongHaplotype;

  typedef Vector<LongHaplotype*>::Class LongHaplotypeVector;
  
    class TDTtable;
  
  typedef Vector<TDTtable*>::Class TDTtableVector;

  class TUMeasure;

  typedef Vector<TUMeasure*>::Class ListOfTUMeasures;

  class GenericMeasure;

  typedef Vector<GenericMeasure*>::Class ListOfGenericMeasures;

//typedef map<long long int, double,  std::less<long long int>,boost::pool_allocator<std::pair<const long long int, double> > > MAP;



//template <template <class, class, class> class Cont, class T, template<class> class STL2>
  template <class T, class U>
  ostream& operator<< (ostream& out, map<T, U>& l)
  {
    throw NonImplemented ("ostream& operator<<(ostream& out, MAP& l)");
  };


  template <class Cont, class T>
  ostream& operator<< (ostream& out, Container<Cont, T>& l);

//template <class Cont, class T>
//ostream& operator<<(ostream& out, Container<Cont, T*>& l);

//template <class Cont, class T>
//void order (Container<Cont, T>* const & l, bool ascending=true);


//   ostream& operator<<(ostream& out, longLongList& lista);
















} // end namespace
#endif


/* Fin Fichero: Container.h */


/* Fin Fichero: Container.h */
