/* File: MultidimensionalEmptyTable.h */


#ifndef __MultidimensionalEmptyTable_cpp__
#define __MultidimensionalEmptyTable_cpp__

using namespace std;

namespace BIOS
{



	/*______________________________________________________*/

	template <class T> MultidimensionalEmptyTable<T>::MultidimensionalEmptyTable()
	{
		set();
	};
	/*______________________________________________________*/

	template <class T> MultidimensionalEmptyTable<T>::MultidimensionalEmptyTable ( intList* dimensionList )
	{
		try
		{
			set ( dimensionList );
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from MultidimensionalEmptyTable<T>::MultidimensionalEmptyTable(intList* dimensionList)" ); throw;};
	};
	/*______________________________________________________*/

	template <class T> MultidimensionalEmptyTable<T>::MultidimensionalEmptyTable ( MultidimensionalEmptyTable &source )
	{
		set ( source.dimensionList );

	}

	/*______________________________________________________*/

	template <class T> void MultidimensionalEmptyTable<T>::set()
	{

		this->totalDimensions=0;
		this->dimensionList=NULL;
		this->size=0;
	};

	/*______________________________________________________*/

	template <class T> void MultidimensionalEmptyTable<T>::set ( intList *dimensionList )
	{
		try
		{
			set();
			if ( dimensionList==NULL )
				throw NullValue ( "MultidimensionalEmptyTable::set(intList*): NULL value" );
			this->dimensionList=new intList ( *dimensionList );
			this->totalDimensions=dimensionList->size();
			if ( this->totalDimensions==0 )
				throw NullValue ( "MultidimensionalEmptyTable::set(intList*): 0 dimensions" );
			this->setSize();
		}
		catch ( BasicException & be ) {be.addMessage ( "\ncalled from  MultidimensionalEmptyTable<T>::set(intList *dimensionList)" ); throw;};

	}

	/*______________________________________________________*/


	template <class T> intList* MultidimensionalEmptyTable<T>::getPosList ( long long int pos )
	{
		int* positions=getPositions ( pos );
		intList* result=new intList();
		for ( int i=0; i<totalDimensions; i++ )
			result->insertElement ( positions[i] );
		zaparr ( positions );
		return result;
	}

	/*______________________________________________________*/

	template <class T> int  MultidimensionalEmptyTable<T>::getDimension()
	{
		return totalDimensions;
	};

	/*______________________________________________________*/

	template <class T> int  MultidimensionalEmptyTable<T>::getSize() {return size;};
	/*______________________________________________________*/

	template <class T> bool  MultidimensionalEmptyTable<T>::inferredFrequency ( int pos )
	{
		// true if the frequency can be inferred by considering the frequencies in the other positions
		int* positions=getPositions ( pos );
		bool result=false;
		int i=0;
		while ( !result && i<this->totalDimensions )
		{
			if ( positions[i]== ( this->dimensionList->getElement ( i )-1 ) && pos== ( getSubtableSize ( i )-1 ) ) result=true;
			i++;
		}
		zaparr ( positions );
		return result;
	};
	/*______________________________________________________*/

	template <class T> int  MultidimensionalEmptyTable<T>::getIndexPositionOfIndexVar ( int pos, int var )
	{
		// given a pos in Table and a var, it returns the index position of such a var
		int *positions=getPositions ( pos );
		int index=positions[var];
		zaparr ( positions );
		return index;
	};
	/*______________________________________________________*/

	template <class T> MultidimensionalEmptyTable<T>::~MultidimensionalEmptyTable()
	{
		empty();
	}
	/*______________________________________________________*/

	template <class T>  void  MultidimensionalEmptyTable<T>::empty()
	{
		zap ( dimensionList );
	};


	/*______________________________________________________*/

	template <class T> long long int  MultidimensionalEmptyTable<T>::getSubtableSize ( int dim )
	{
		try
		{
			long long int subsize=1;
			for ( int i=dim+1; i<totalDimensions;i++ )
				if ( i<0 || i >=totalDimensions ) throw OutOfRange<long long int> ( i, "MultidimensionalEmptyTable<T>::getSubtableSize" );
				else
					subsize=subsize* ( dimensionList->getElement ( ( int ) i ) );
			return subsize;
		}
		catch ( ORLLI & e ) {e.PrintMessage(); throw;};

	}
	/*______________________________________________________*/

	template <class T> long long int  MultidimensionalEmptyTable<T>::getPos ( int *pos )
	{
		long long int absPos=0;
//cout << "dimlist: " << *dimensionList << "\n";
		for ( int i=0; i<totalDimensions;i++ )
		{
			if ( pos[i]<0 || pos[i]>= ( dimensionList->getElement ( i ) ) )
			{
				cout <<"\ndimensions in MultidimensionalEmptyTable are: " << *dimensionList;
				cout <<"\noverflowed dimension is the one at pos " << i;
				throw OutOfRange<long long int> ( pos[i], "MultidimensionalEmptyTable<T>::getPos" );
//throw OutOfRange<long long int>();
			}
			absPos=absPos+pos[i]*getSubtableSize ( i );
//cout << "absposfordim " << i << ", with val:" << pos[i] <<": " << absPos << "subtable size is: " << getSubtableSize ( i ) << "\n";
		}




		if ( absPos>=size || absPos<0 )
		{
			cout <<"OutOfRange error in MultidimensionalEmptyTable::getPos, with (" << *dimensionList <<") dimensions, size is " << size <<" and it is trying to access at pos " << absPos;
			for ( int i=0; i<totalDimensions;i++ )
			{
				cout <<"\nval at pos" <<i<<" is: " << pos[i];
				cout << "subtablesize is" << getSubtableSize ( i );
			}
			throw OutOfRange<long long int> ( absPos, "2. MultidimensionalEmptyTable<T>::getPos" );
		}
		return absPos;
	};



	/*______________________________________________________*/

	template <class T>  void  MultidimensionalEmptyTable<T>::setSize()
	{
		size=1;
		for ( int i=0; i<totalDimensions;i++ )
		{
			size=size* ( dimensionList->getElement ( i ) );
			if ( size==0 ) throw ZeroValue ( "MultidimensionalEmptyTable::setSize, size is 0" );
			if ( size<0 )
			{
				cout << "for i: " << i <<"\n";
				throw OutOfRange<long long int> ( size, "MultidimensionalEmptyTable::setSize, too big" );

			}
		}
//cout <<"dize is: " << size <<"\n\n";
	}




	/*______________________________________________________*/

	template <class T> int*  MultidimensionalEmptyTable<T>::getPositions ( long long int pos )
	{
		try
		{
			if ( pos>=size || pos<0 )
			{
				cout <<"total dims:" << this->totalDimensions <<", vals: " << *this->dimensionList;
				throw OutOfRange<long long int> ( pos, "MultidimensionalEmptyTable<T>::getPositions" );
			}
			int *positions=new int[totalDimensions];
			long long int rem;
			for ( int i=0; i<totalDimensions;i++ )
			{
				rem=getSubtableSize ( i );
//cout <<"\nrem is: " << rem <<" and pos is: "  << pos;

				positions[i]=pos/rem;
//cout <<"Pos:" << positions[i];
				pos=pos-positions[i]*getSubtableSize ( i );
			}
			return positions;
		}
		catch ( ORLLI & e ) {e.addMessage ( "\ncalled from MultidimensionalEmptyTable<T>::getPositions" ); throw;};
	};




	/*______________________________________________________*/

	template <class T> string MultidimensionalEmptyTable<T>::print()
	{
		string result=string ( "" );

		return result;

	};

	/*____________________________________________________________ */

	template <class T> intList*  MultidimensionalEmptyTable<T>::getAmbiguousDimList ()
	{
		if ( dimensionList==NULL ) throw NullValue ( "MultidimensionalEmptyTable<T>::getAmbiguousDimList" );
		intList* newDimList=new intList();
		int values;
		for ( intList::iterator it=dimensionList->begin(); it<dimensionList->end(); it++ )
		{
			values=AmbiguousArray::getTotalPos ( dimensionList->getElement ( it ) );
			if ( values==0 ) values=1;
			newDimList->insertElement ( values );
		}
		return newDimList;
	}
	/*____________________________________________________________ */

	template <class T> AmbiguousArray*  MultidimensionalEmptyTable<T>::getAmbiguousTable ()
	{
		intList* newDimList=getAmbiguousDimList();
		AmbiguousArray* result=new AmbiguousArray ( newDimList );
		zap ( newDimList );
//int pos=0, *knownPositions, unknownPositions;
		return result;
	}


	template <class T> ostream& operator<< ( ostream& out, MultidimensionalEmptyTable<T>& p )
	{
		out << "empty table has dimension vars: "  << *p.dimensionList;
		return out;
	};


	/*______________________________________________________*/
	/*
	  template <class T> ostream& operator<<(ostream& out, MultidimensionalEmptyTable<T>& p)
	  {
	    out << p.print();
	    return out;
	  };
	   */


}
#endif
