/* File: MultidimensionalTable.h */


#ifndef __MultidimensionalTable_cpp__
#define __MultidimensionalTable_cpp__


using namespace std;

namespace BIOS

{
 template <class T> ostream& operator<<(ostream& out, MultidimensionalTable<T>& p)
  {
    int *pos=NULL;
//cout << "size is " << size << "\n";
//if (this->table==NULL) cout << "yes\n"; else cout << "no\n";
//cout << "value at 0 is :\n";
//cout << (this->table[0]) << "\n";
    for (int i=0; i<p.getSize();i++)
    {

      pos=p.getPositions(i);
      out << "\nFreq (";
      for (int j=0; j<p.dimensionList->size();j++)
      {
        out << "var Pos "<< j <<"= "<< pos[j] <<" ";
      }
      out << ") = ";
      out << p.getValue(pos);
      zaparr(pos);
    };
    return out;
  };


/*______________________________________________________________________________________*/

ostream& operator<<(ostream& out, MultidimensionalTable<longLongList*>& p)
  {
//out <<"heresize" << p.getSize() << "\n";
    int *pos=NULL;
//cout << "size is " << size << "\n";
//if (this->table==NULL) cout << "yes\n"; else cout << "no\n";
//cout << "value at 0 is :\n";
//cout << (this->table[0]) << "\n";
    for (int i=0; i<p.getSize();i++)
    {
      pos=p.getPositions(i);
      out << "\nList (";
      for (int j=0; j<p.dimensionList->size();j++)
      {
        out << "Pos "<< j <<"= "<< pos[j] <<" ";
      }
      out << ") = ";
      if (p.getValue(i)==NULL) out <<"null"; else out << *p.getValue(i);
//cout <<"ggg\n";
      zaparr(pos);
  
//out << i <<"\n" << *p.getValue(i);
  };
    return out;
  };
   /*______________________________________________________*/

  ostream& operator<<(ostream& out, MultidimensionalTable<Prob>& p)
  {
     char posChar[2000];
    int *pos=NULL;
    int pv;
    cout <<"Total counts: " << p.totalCounts <<"\n"; 
    for (int i=0; i<p.getSize();i++)
    {

      pos=p.getPositions(i);
      out << "\nProb (";
      strcpy(posChar,"\0");

      for (int j=0; j<p.dimensionList->size();j++)
      {


        sprintf(posChar, " %d, ", pos[j]);
       out << "var ";
        out << string(posChar);
      }

      out << ") = ";


     // out << tos(p.getValue(pos));
        out << "[" << p.getValue(pos).getNumerator() <<", " << p.getValue(pos).getDenominator() <<"]";

      zaparr(pos);
    };
  
    return out;
  }

/*______________________________________________________________________________________*/

   template <class T> MultidimensionalTable<T>::MultidimensionalTable():MultidimensionalEmptyTable<T>()
    {
     set();
    };

/*______________________________________________________*/

        template <class T> void MultidimensionalTable<T>::set(intList *dimensionList)
    {
MultidimensionalEmptyTable<T>::set(dimensionList);
set();
}
/*______________________________________________________*/

        template <class T> void MultidimensionalTable<T>::set()
    {
      this->table=NULL;
      totalCounts=0;
string s;
if (this->size>0)
{
if ((this->table=new T[this->size])==NULL)
{
s=tos(*this->dimensionList);
throw NoMemory(string("MultidimensionalTable<T>::set() with dimList: ")+s);
}
this->initialize();
}
};
    /*______________________________________________________*/

   template <class T>   MultidimensionalTable<T>::MultidimensionalTable(intList* dimensionList):MultidimensionalEmptyTable<T>(dimensionList) 
    {
    set();
    };
      /*______________________________________________________*/

    template <class T>  MultidimensionalTable<T>::MultidimensionalTable(MultidimensionalTable &source):MultidimensionalEmptyTable<T>(source)
    {
try{
 if (this->dimensionList!=NULL) 
    {
  set();
 this->totalCounts=source.totalCounts;
      for (int i=0; i<this->size;i++)
       setValue(i, source.getValue(i));
}
}
catch (MissingValue mv){mv.PrintMessage("MultidimensionalTable(MultidimensionalTable &source)");end();}
      }


 
  /*______________________________________________________*/

template <class T> void  MultidimensionalTable<T>::initialize()
{
InitializeList(this->table, this->size, (T)0);
}
  /*______________________________________________________*/

template <class T> T  MultidimensionalTable<T>::GetMax()
{
return BIOS::GetMax(table, this->size);
}
   /*______________________________________________________*/
/*
   template <class T>  void  MultidimensionalTable<T>::setSize() throw (ZeroValue)
    {
  return MultidimensionalEmptyTable<T>::setSize(false);

    }
       /*______________________________________________________*/

   // virtual ostream& operator<<(ostream& out);//{cout <<"MultidimensionalTable:print() Not implemented yet"; end();};
     /*______________________________________________________*/

    template <class T>  MultidimensionalTable<T>::~MultidimensionalTable(){this->empty();};
    /*______________________________________________________*/

   template <class T>  void  MultidimensionalTable<T>::empty(){
zaparr(this->table); //, this->size); 
};

 /*_______________________________________________________________*/

 template <class T>  MultidimensionalTable<T>*  MultidimensionalTable<T>::project(intList* sourcePosList)
  {
try
{

//  this->setTotalCounts();// it will not work if T is Prob and is a conditional prob table that may have missing values (the method will be called from getValue)
//cout <<"totalcounts:" << (T&)this->getTotalCounts();
  intList* chosenDimensionList=this->dimensionList->copyElementsWithPositionsIn(sourcePosList);
  intList* remainingDimensionList=this->dimensionList->copyElementsWithoutPositionsIn(sourcePosList);
/*
  intList* newDimensionList=new intList(*newDimensionSet);
zap(newDimensionSet);

  intList* missingDimensionList=new intList(*missingDimensionSet);
zap(missingDimensionSet);
*/
//cout << "this " << *this <<" will be project in " << *sourcePosList <<"\n";
//cout << "choo:" << *chosenDimensionList << "\n";
  MultidimensionalTable<T>* chosenMultidimensionalTable=new MultidimensionalTable<T>(chosenDimensionList);


//cout << "rem:" << *remainingDimensionList << "\n";
  MultidimensionalTable<T>* remainingTable=new  MultidimensionalTable<T>(remainingDimensionList);
zap(remainingDimensionList);
  zap(chosenDimensionList);



intList* allVars=new intList(this->totalDimensions, 0);
intList* remainingPosList=allVars->copyElementsWithoutPositionsIn(sourcePosList);

  int completePositions[this->totalDimensions], *remainingVarPositions=remainingPosList->getTable(), * currentPositions=this->dimensionList->getTable(), *chosenPositions, *chosenVarPositions=sourcePosList->getTable(), c, *remainingPositions;
zap(allVars);
zap(remainingPosList);
  for (int i=0; i<chosenMultidimensionalTable->size;i++)
  {
	chosenPositions=chosenMultidimensionalTable->getPositions(i);
  disperseValues(chosenPositions, chosenMultidimensionalTable->totalDimensions, chosenVarPositions, currentPositions, this->totalDimensions);
try
{
   remainingTable->initialize(); 
   for (int j=0;j<remainingTable->size;j++)
     {
     remainingPositions=remainingTable->getPositions(j);
     disperseValues(remainingPositions, remainingTable->getDimension(), remainingVarPositions, currentPositions, this->totalDimensions);
     zaparr(remainingPositions);
//cout <<"val at pos " << j <<"is: " << remainingTable->getValue(j) <<" and " << this->getValue(currentPositions) << " will be added\n";
     //if (j==0) remainingTable->setValue(j, this->getValue(currentPositions)); else 
     remainingTable->addValue(j, this->getValue(currentPositions)); 
     }
}
catch (MissingValue mv){mv.PrintMessage("MultidimensionalTable::project");end();}
    remainingTable->setTotalCounts();

    chosenMultidimensionalTable->setValue(i, (T)remainingTable->getTotalCounts());
    zaparr(chosenPositions);
   }
   // chosenMultidimensionalTable->setTotalCounts();// it will not work if T is Prob and is a conditional prob table that may have missing values (the method will be called from getValue)
  zap(remainingTable);
  zaparr(currentPositions);
zaparr(chosenVarPositions);
return chosenMultidimensionalTable;
}
		catch ( BasicException& be ) {be.addMessage ( "\ncalled from MultidimensionalTable<T>*  MultidimensionalTable<T>::project(intList* sourcePosList)" ); throw;};

  };
/*______________________________________________________*/

  template <class T> void  MultidimensionalTable<T>::setTotalCounts()
  {
//cout <<*this <<"\n";
if (this->size>0)
{
    totalCounts=table[0];
    if (this->size>1) 
     for (int i=1; i<this->size;i++)
          totalCounts=totalCounts+table[i];
}
  };
     /*______________________________________________________*/

  template <class T>   T  MultidimensionalTable<T>::getTotalCounts()
    {
//if (totalCounts=0) // if this line is not commented, there can be problems with the project method (very important in BN inference using cliques)
setTotalCounts();
      return totalCounts;
    };


    /*______________________________________________________*/

    template <class T> void  MultidimensionalTable<T>::setValue(int* pos, T value)
    {
     table[MultidimensionalEmptyTable<T>::getPos(pos)]=value;
    };
    /*______________________________________________________*/

    template <class T> void  MultidimensionalTable<T>::setValue(int pos, T value)
    {
      table[pos]=value;
    };

/*______________________________________________________*/

    template <class T> void  MultidimensionalTable<T>::addValue(int pos, T value)  
    {
      table[pos]=table[pos]+value;
    };

/*______________________________________________________*/

    template <class T> void  MultidimensionalTable<T>::addValue(int* pos, T value) 
    {
addValue(MultidimensionalEmptyTable<T>::getPos(pos), value);
    };

    /*_____________________________________________________*/
/*
    template <class T> int  MultidimensionalTable<T>::getSubtableSize(int dim)
    {
return MultidimensionalEmptyTable<T>::getSubtableSize(dim, false);
}
    /*______________________________________________________*/
/*
    template <class T> long long int  MultidimensionalTable<T>::getPos(int *pos, bool missing) throw (OutOfRange<long long int>)
    {
return MultidimensionalEmptyTable<T>::getPos(pos, false);
	


    };


    /*______________________________________________________*/
/*
    template <class T> int*  MultidimensionalTable<T>::getPositions(long long int pos)  throw (OutOfRange<long long int>)
    {
return MultidimensionalEmptyTable<T>::getPositions(pos, false);
    };


    /*______________________________________________________*/

   template <class T>  bool  MultidimensionalTable<T>::isCompletelyMissing(int *pos)
    {
      int totalMissing=0;
      for (int i=0;i<this->totalDimensions;i++) 
      {
      if (i>=this->dimensionList->size())//eliminar comprobacion
      {
      cout <<"Error in MultidimensionalTable::isCompletelyMissing";
      end();
      }
      if (pos[i]==this->dimensionList->getElement(i)) totalMissing++;
      }
      if (totalMissing==this->totalDimensions) return true; else return false;

    }
     /*______________________________________________________*/

    template <class T> void  MultidimensionalTable<T>::setMissing(int* pos, int index)
    {
      pos[index]=this->dimensionList->getElement(index);
      }
 /*______________________________________________________*/

    template <class T> bool  MultidimensionalTable<T>::isMissing(int *pos)
    {
      int totalMissing=0;
      int i=0;
      while (i<this->totalDimensions)
      {
      if (i>=this->dimensionList->size())//eliminar comprobacion
      {
      cout <<"Error in MultidimensionalTable::isCompletelyMissing";
      end();
      }
      if (pos[i]==this->dimensionList->getElement(i)) return true;
      i++;
      }
      return false;
      };

 /*______________________________________________________*/

    template <class T> int  MultidimensionalTable<T>::getTotalMissing(int *pos)
    {
      int totalMissing=0;
      int i=0;
      while (i<this->totalDimensions)
      {
      if (i>=this->dimensionList->size())//eliminar comprobacion
      {
      cout <<"Error in MultidimensionalTable::isCompletelyMissing";
      end();
      }
      if (pos[i]==this->dimensionList->getElement(i)) totalMissing++;
      i++;
      }
return totalMissing;
      }

 /*______________________________________________________*/

   template <class T>  intList*  MultidimensionalTable<T>::getMissingDimensions(int *pos)
    {
      intList* missingDimensions=new intList();
      int i=0;
      while (i<this->totalDimensions)
      {
      if (i>=this->dimensionList->size())//eliminar comprobacion
      {
      cout <<"Error in MultidimensionalTable::isCompletelyMissing";
      end();
      }
      if (pos[i]==this->dimensionList->getElement(i)) missingDimensions->insertElement(pos[i]);
      i++;
      }
      return missingDimensions;
      }
 /*______________________________________________________*/

    template <class T> int*  MultidimensionalTable<T>::getMissingVars(int *pos)
    {
      int totalMissing=getTotalMissing(pos);
      int* missingPositions=new int[totalMissing];
      int i=0, cont=0;
      while (i<this->totalDimensions)
      {
      if (i>=this->dimensionList->size())//eliminar comprobacion
      {
      cout <<"Error in MultidimensionalTable::isCompletelyMissing";
      end();
      }
      if (pos[i]==this->dimensionList->getElement(i)) 
{
missingPositions[cont]=i;
cont++;
}
      i++;
      }
return missingPositions;
      }
 /*______________________________________________________*/

    template <class T> int  MultidimensionalTable<T>::getFirstMissing(int *pos)
    {
      int i=0;
      while (i<this->totalDimensions)
      {
      if (i>=this->dimensionList->size())//eliminar comprobacion
      {
      cout <<"Error in MultidimensionalTable::isCompletelyMissing";
      end();
      }
      if (pos[i]==this->dimensionList->getElement(i)) return i;
      i++;
      }
return -1;
      }
    /*______________________________________________________*/

    template <class T> T  MultidimensionalTable<T>::getValue(int pos)
    {
    try
    {
if (table==NULL) cout << "error table null\n";
    return table[pos];
    }
    catch (BasicException& be){be.addMessage("\ncalled from MultidimensionalTable<T>::getValue(int pos)"); throw;};
    }
    /*______________________________________________________*/

    template <class T> T  MultidimensionalTable<T>::getValue(int *pos) 
    {
    try
    {
      int totalMissing=0;

      for (int i=0;i<this->totalDimensions;i++) if (pos[i]==this->dimensionList->getElement(i)) totalMissing++;
      if (totalMissing==0) 
{
return getValue(MultidimensionalEmptyTable<T>::getPos(pos)); 
}
        //   cout <<"hh" << totalMissing << "and total dim:" << totalDimensions;
      if (totalMissing==this->totalDimensions) throw MissingValue("MultidimensionalTable::getValue");
      
     intList *remainingVarPositions=new intList();
     int remainingPositions[this->totalDimensions-totalMissing], c=0;

     for (int i=0;i<this->totalDimensions;i++)
      {
        if (pos[i]!=this->dimensionList->getElement(i))
        {
          remainingVarPositions->insertElement(i);
          remainingPositions[c]=i;
          c++;
        }

      }

     MultidimensionalTable* mT=project(remainingVarPositions);

       T value=mT->getValue(remainingPositions);
     zap(mT);
zap(remainingVarPositions);
     return value;
     }
    catch (BasicException& be){be.addMessage("\ncalled from  MultidimensionalTable<T>::getValue(int *pos) "); throw;};

   };


    /*______________________________________________________*/
/*
    template <class T> int  MultidimensionalTable<T>::getSize(int* values)
    {
      int size=1;
      for (int i=0; i<totalDimensions;i++)
        if (values[i]!=dimensionList->getElement(i))
          size=size*dimensionList->getElement((int)i);

      return size;
    };
/*_______________________________________________________________*/


  template <class T> void  MultidimensionalTable<T>::normalize()
  {
try
{
  BIOS::normalize(table, this->size);
}
catch (ZeroValue & zv) {zv.addMessage("\ncalled from void  MultidimensionalTable<T>::normalize()"); throw;};
}
/*_______________________________________________________________*/


  template <> void  MultidimensionalTable<longLongList*>::normalize()
  {
  throw BadFormat(string("MultidimensionalTable<longLongList*>::normalize()"));
}
/*_______________________________________________________________*/


  template<> void MultidimensionalTable<Prob>::normalize()
  {

};

  
    /*_______________________________________________________________*/

  template <class T> void  MultidimensionalTable<T>::removeInconsistenciesWithEvidence(intList* sourcePosList, T value)
  {
if (sourcePosList==NULL)
{
cout <<"Error in MultidimensionalTable::removeInconsistenciesWithEvidence, NULL pattern";
end();
}
    int *pos;
    int j;
    bool inconsistency=true, conditionalInconsistency=false;
    for (int i=0; i<MultidimensionalEmptyTable<T>::getSize();i++)
    {
      inconsistency=false;
      pos=MultidimensionalEmptyTable<T>::getPositions(i);
      j=0;
      do
      {
        if (pos[j]!=sourcePosList->getElement(j) && sourcePosList->getElement(j)!=this->dimensionList->getElement(j))
          inconsistency=true;
        j++;
      }
      while (j<this->getDimension() && inconsistency==false);
      if (inconsistency)
         setValue(this->getPos(pos), value);
		zap(pos);
    }
    //setTotalCounts();
    //if (totalCounts>0) normalize();
  }
 
   
/*______________________________________________________*/

  template <class T> string  MultidimensionalTable<T>::print()
  {
    string result=string("");
    char posChar[2000];
    int *pos=NULL;
    int pv;
//cout << "size is " << size << "\n";
//if (this->table==NULL) cout << "yes\n"; else cout << "no\n";
//cout << "value at 0 is :\n";
//cout << (this->table[0]) << "\n";
    for (int i=0; i<this->size;i++)
    {

      pos=this->getPositions(i);
      result=result+"\nFreq (";
      strcpy(posChar,"\0");
//cout << " here\n";
      for (int j=0; j<this->dimensionList->size();j++)
      {
//cout << "shere\n";
        sprintf(posChar, "Pos %d= %d, ", j, pos[j]);
        result=result+"var ";
        result=result+string(posChar);
//cout << "wwwwwwwwwhere\n";
      }

      result=result+ ") = ";
//cout << "vhere\n";
//cout << " this value for i " <<  i << " is : \n"; 
//cout << *this << "jet\n";
//cout << tos(this->getValue(i)) << "\n";
      result=result+tos(this->getValue(pos));
  //   cout << "where\n";
      zaparr(pos);
//cout << "bhere\n";
    };
    return result;

  };
/*____________________________________________________________ */

template <class T> MultidimensionalTable<T>*  MultidimensionalTable<T>::getTable (HeteroListPair<long long int, T>* pair)
{
MultidimensionalTable<T>* result=new MultidimensionalTable(this->dimensionList);
int pos=0;
for (longLongList::iterator it=pair->First->begin(); it<pair->First->end(); it++)
{
result->setValue(pair->First->getElement(it), pair->Second->getElement(pos));
pos++;
}
return result;
}

  /*______________________________________________________*/












};// end namespace
#endif
