/* File: Partition.h */


#ifndef __Partition_h__
#define __Partition_h__



/**
    @memo Declaration of a ListOfPointers (FIFO)
    @doc
    */

//using namespace UTILS;

namespace BIOS
{

 // template <class Cont, class T> class Container;


  /************************/
  /* ListOfPointers DEFINITION */
  /************************/


  /*
          @memo ListOfPointers 
   
  	@doc
          Definition:
          A Cont of ListOfPointers's features 
   
          Memory space: O(SizeP), which SizeP being the number of elements in the ListOfPointers
   
      @author Maria M. Abad Grau
  	@version 1.0
  */
//template <class T> typedef  Container<Cont, T> Container<Cont, T>;


// template <template <class T, typename STL2 > class Cont, class T, typename STL2=std::allocator<T> >



 

  template <class T> 
  struct Partition
  {
    typedef Sample<
															Container<
																									set<Container<set<T>, T>*>,
																									Container<set<T>, T>*
                        >,
															Container<set<T>, T>, 
															T
															> Class;
  };



typedef Partition<Haplotype*>::Class PartitionOfHaplotypes;

typedef SetSample<Haplotype*>::Class PartitionAsSetSampleOfHaplotypes;


// template <class T> ostream& operator<<(ostream& out, struct  Partition<T>::Class& l);




}; // end namespace
#endif

//#include "ListOfPointers.cpp"

/* Fin Fichero: ListOfPointers.h */
