/* File: Quotient.h */


#ifndef __Quotient_cpp__
#define __Quotient_cpp__



using namespace std;

namespace BIOS {

	template <class T> T  Quotient<T>::getNumerator(){return numerator;};
	template <class T> T  Quotient<T>::getDenominator(){return denominator;};
	template <class T> void  Quotient<T>::setNumerator(T numerator){this->numerator=numerator;};
	

/////////////
template <class T> Quotient<T>::~Quotient ()
{
}
/////////////
template <class T> Quotient<T>::Quotient (T num, T den)
{
 numerator=num;
 denominator=den;
}
//////////////
template <class T> Quotient<T>::Quotient (const Quotient<T> & origen)
{
 numerator=origen.numerator;
 denominator=origen.denominator;
}
/////////////////
/*
template <class T> Quotient<T> Quotient<T>::operator= (Quotient<T> & rat2)
{
return Quotient (rat2.numerator, rat2.denominator);
}
*/
/////////////////
template <class T> Quotient<T> Quotient<T>::operator* (Quotient<T> & rat2)
{
Quotient result(0.0,0.0);
if (denominator==rat2.numerator) 
{
result.numerator=numerator;
result.denominator=rat2.denominator;
}
else if (numerator==rat2.denominator) 
{
result.numerator=rat2.numerator;
result.denominator=denominator;
}
else
{
result.numerator=numerator*rat2.numerator;
result.denominator=denominator*rat2.denominator;
result.simplify();
}
return(result);
}
/////////////////
template <class T> bool Quotient<T>::operator< (Quotient<T> & rat2)
{
return (this->convert()< rat2.convert());
}
/////////////////
template <class T> bool Quotient<T>::operator== (Quotient<T> & rat2)
{
return (this->convert()== rat2.convert());
}
/////////////////
template <class T> bool Quotient<T>::operator> (Quotient<T> & rat2)
{
return (this->convert()> rat2.convert());
}

/////////////////
template <class T> bool Quotient<T>::operator<= (Quotient<T> & rat2)
{
return (this->convert()<= rat2.convert());
}
/////////////////
template <class T> Quotient<T> Quotient<T>::operator/ (Quotient<T> & rat2)
{
Quotient<T> result(0,0);
if (isUndefined() && rat2.isUndefined()) return result;
if (numerator==0 && rat2.numerator==0) return result;
if (rat2.numerator==1 && rat2.denominator==1) return Quotient<T>(1,1);
if (rat2.numerator==0)
{
	cout <<"\nError in Quotient::operator/ for " << this->print() <<" and " << rat2.print() <<", denominator is 0";
	end();
}
if (rat2.denominator==denominator) 
{
result.numerator=numerator;
result.denominator=rat2.numerator;
}
else
{
result.numerator=numerator*rat2.denominator;
result.denominator=denominator*rat2.numerator;
result.simplify();
}
return (result);
}
/////////////////
template <class T> Quotient<T> Quotient<T>::operator+ (Quotient<T> & rat2)
{
Quotient<T> result(0,0);
if (denominator==0 && numerator==0)
return rat2;
if (rat2.numerator==0 && rat2.denominator==0)
return *this;
if (denominator==rat2.denominator) 
{
result.numerator=numerator+rat2.numerator;
result.denominator=denominator;
}
else 
{
result.numerator=numerator*rat2.denominator+denominator*rat2.numerator;
result.denominator=denominator*rat2.denominator;
}
return (result);
}
/////////////////
template <class T> Quotient<T> Quotient<T>::operator- (Quotient<T> & rat2)
{
Quotient<T> result(-rat2.numerator, rat2.denominator);
return *this+result;
}
/////////////////
/*
template <class T> void Quotient<T>::operator= (Quotient<T> & rat2)
{
this->numerator=rat2.numerator;
this->denominator=rat2.denominator;
}
*/
//////////////////
template <class T> double Quotient<T>::log2()
{
 if (numerator==denominator) return (0);
 if (numerator==0) 
	 {
cout <<"\nError, not a number in Quotient::log2";
exit(0);
}
 else return (log_2((double)numerator)-log_2((double)denominator));//
}
//////////////////
template <class T> double Quotient<T>::convert ()
{
if (denominator==0.0) 
{
cout <<"\nError, not a number (denominator is 0) in Quotient::convert():" << print();
end();
}
if (numerator==denominator) return (1.0);
else 
return ((double)numerator/(double)denominator);
}
//////////////////
template <class T> unsigned long int Quotient<T>::getMCD (unsigned long int a, unsigned long int b)
{
//cout <<"\na: " << a <<" and b " << b;
unsigned long int f, s;
if (b==0) return a;
else
{
f=b;
s=a%b;
a=getMCD(f, s);
}
}
//////////////////
template <class T> void Quotient<T>::simplify ()
{
unsigned long int a=(unsigned long int) ceil(numerator);
unsigned long int b=(unsigned long int) ceil(denominator);
if (a!=0.0 && b!=0.0 && a-numerator==0.0 && b-denominator==0.0)
{
unsigned long int mcd=getMCD(a,b);
//cout <<"\nMCD de " << a <<" y " << b <<" is: " << mcd;
numerator=numerator/(double)mcd;
denominator=denominator/(double)mcd;
}
}
//////////////////
template <class T> bool Quotient<T>::isUndefined ()
{
if (numerator==0 && denominator==0)
return true; else return false;
}
//////////////////
template <class T> string Quotient<T>::print()
{
char line[100];
sprintf(line, " (%0.1f, %0.1f)\0", this->numerator, this->denominator);
//sprintf(line, " %s, (%d, %d)\0", line, this->numerator, this->denominator);

//sprintf(line, " (%s)", "hola\0");

return string(line);
//zaparr(line);
//return result;
}
//////////////////
 
template <class T> ostream& operator<<(ostream& out, Quotient<T>& e)
{
out << e.print();
return out;
}
}//end namespace
#endif
