/* File: Set.h */


#ifndef __Set_h__
#define __Set_h__



/**
    @memo Declaration of a ListOfPointers (FIFO)
    @doc
    */

//using namespace UTILS;

namespace BIOS
{

  template <class Cont, class T> class Container;


  /************************/
  /* ListOfPointers DEFINITION */
  /************************/


  /*
          @memo ListOfPointers 
   
  	@doc
          Definition:
          A Cont of ListOfPointers's features 
   
          Memory space: O(SizeP), which SizeP being the number of elements in the ListOfPointers
   
      @author Maria M. Abad Grau
  	@version 1.0
  */
//template <class T> typedef  Container<Cont, T> Container<Cont, T>;


// template <template <class T, typename STL2 > class Cont, class T, typename STL2=std::allocator<T> >



 


  template <class T> 
  struct Set
  {
    typedef Container<set<T>, T > Class;
  };

class Clique;
class Node;
class Attribute;
class Haplotype;
typedef Set<Clique*>::Class SetOfCliques;
typedef Set<Attribute*>::Class SetOfAttributes;
typedef Set<bool >::Class boolSet;
typedef Set<int>::Class intSet;
typedef Set<float>::Class floatSet;
typedef Set<double>::Class doubleSet;
typedef Set<string>::Class stringSet;
typedef Set<long long int>::Class longLongSet;


typedef Set<Integer*>::Class IntegerSet;
typedef Set<Node*>::Class NodeSet;







}; // end namespace
#endif

//#include "ListOfPointers.cpp"

/* Fin Fichero: ListOfPointers.h */
