/* File: SlidingWindows.h */


#ifndef __SlidingWindows_h__
#define __SlidingWindows_h__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo SlidingWindows

	@doc
        Definition:
									IT decomposes a region of regionLength snps, starting at snp "firstSNP" in slinding windows of size "windowSize" and offset "offset"        

        Memory space:

        @author Maria M. Abad Grau
	@version 1.0
*/


 
class SlidingWindows {


protected:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	

int regionLength, firstPosition;

int windowSize, offset, totalCompleteWindows, lastWindowSize;

int* totalOverlaps;

intSet** windowOverlaps;
   


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on SlidingWindows
        @memo Operations on SlidingWindows
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

SlidingWindows(int windowSize, int offset, int regionLength, int firstSNP=0);

		        /**
         @memo Copy constructor
         @param destino: Genotype where will be copy
         @param origen: Genotype to copy
         @doc
           Make a copy of Genotype
           Time complexity in time O(1).

		 */

  		  SlidingWindows ();

  		  ~SlidingWindows ();

		  
int getTotalCompleteWindows();

int getTotalWindows();

int getRegionLength();

int getWindowSize();

int getOffset();

int getFirstRelativePositionAtWindow (int snp);

int getFirstAbsolutePositionAtWindow (int snp);

int getSizeOfWindow(int windowPos);

void setLastWindowSize();

int getLastWindowSize();

int getTotalUsedSNPs();

void setTotalCompleteWindows();

void getAbsolutePos(int *out, int window);

void setWindowOverlaps();

intSet* getWindowOverlapsForPosition(int position);

int getTotalOverlapsForPosition(int position);

int getLastPositionUsedByCompleteWindows();

int getLastRelativePositionUsedByCompleteWindows();

int* getAbsolutePositions(int window);

friend ostream& operator<<(ostream& out, SlidingWindows& pm)
       {
out << "window size:" << pm.windowSize <<"\n";
out << "offset:" << pm.offset <<"\n";
out << "region length:" << pm.regionLength <<"\n";
out << "total complete windows:" << pm.totalCompleteWindows <<"\n";
if (pm.lastWindowSize<pm.windowSize) out << "plus a last window of length: " << pm.lastWindowSize<<"\n";
return out;
};

};  // End of class SlidingWindows




};  // End of Namespace

#endif

/* End of file: SlidingWindows.h */




