#ifndef Ddvector_CPP
#define Ddvector_CPP 1


// double precision vector, matrix arithmetic
// Dave Curtis, 1998


namespace BIOS { 


doublevec::doublevec(int s)
// Constructor, s is number of elements
 {
 if ((v=new double[s])==0)
  {
  dvec_error("Out of memory in doublevec(2)");
  sz=0;
  }
 else sz=s;
 }


doublevec::~doublevec()
// Destructor
 {
 if (v) delete v;
 }




#if 0
dv2d dsvd::svbksb(dv2d& b)
// Solve for X in AX=b where A is original matrix before decomposition
// Adapted from Numerical recipes in C, Press et al
   {
   dv2d x(W.wide,1);  // as high as W is wide
   int jj,j,i;
   double s;
   setU(); setV(); // could rewrite this later so won't need them
   int n=U.wide,m=U.high;
   doublevec tmp(n+1);
   for (j=0;j<n;j++) {
      s=0.0;
      if (W[j][j]) {
         for (i=0;i<m;i++) s += U[i][j]*b[i][0];
         s /= W[j][j];
      }
      tmp[j]=s;
   }
   for (j=0;j<n;j++) {
      s=0.0;
      for (jj=0;jj<n;jj++) s += V[j][jj]*tmp[jj];
      x[j][0]=s;
   }
return x;
}
#endif


doublevec::doublevec(doublevec const &othervec)
// Copy constructor
 {
 if ((v=new double[othervec.sz])==0)
  {
  dvec_error("Out of memory in doublevec(1)");
  sz=0;
  }
 else
  {
  sz=othervec.sz;
  for (int i=0;i<sz;++i) v[i]=othervec.v[i];
  }
 }

/*_________________________________________________________*/


doublevec::doublevec(void)
// Constructor of zero-size vector, to be resized later
 {
 sz=0;
 v=NULL;
 }

/*_________________________________________________________*/


doublevec doublevec::operator+(doublevec const & v2)
// Vector addition: SUM=A+B
 {
 doublevec sum(sz);
 for (int i=0;i<sz;++i)
    sum.v[i]=v[i]+v2.v[i];
 return sum;
 }
/*_________________________________________________________*/


doublevec doublevec::operator-(doublevec const & v2)
// Vector subtraction: SUM=A-B
 {
 doublevec sum(sz);
 for (int i=0;i<sz;++i)
    sum.v[i]=v[i]-v2.v[i];
 return sum;
 }

/*_________________________________________________________*/


doublevec& doublevec::operator=(doublevec const & othervec)
// Vector assignment: A=B
 {
 if (sz!=othervec.sz)
   {
   if (v) delete v;
   if ((v=new double[othervec.sz])==0)
     {
     dvec_error("Out of memory in doublevec(3)");
     sz=0;
     return *this;
     }
   else sz=othervec.sz;
   }
 for (int i=0;i<sz;++i)
    v[i]=othervec.v[i];
 return *this;
 }

/*_________________________________________________________*/


void doublevec::fprintf(FILE *fp,char *form)
// Print out whole vector
// Each element formatted according to form, which can be omitted
 {
 for (int i=0;i<sz;++i)
   ::fprintf(fp,form,v[i]);
 }


}

#endif
