#ifndef __GenericMeasure_h__
#define __GenericMeasure_h__

namespace BIOS {
	
  /**
     @memo GenericMeasure
     @doc
     Definition:
	
An abstract class for GenericMeasure 

     @author María Mar Abad Grau
     @version 1.0
	
	*/	
	
	class MeasureResults;
	
	class GenericCounts;

class GenericMeasure{


		public:
	


		/**
		*	Constructor
		*/		
		GenericMeasure();


		/**
		*	Destructor
		*/		
		virtual ~GenericMeasure()=0;

virtual GenericMeasure* clone()=0;

  virtual GenericMeasure* getNewGenericMeasure(GenericCounts* genericCounts, GenericCounts** training=NULL, GenericCounts** test=NULL)=0;
  
    virtual GenericMeasure* inferGenericMeasure(GenericCounts* genericCounts)=0;
  
//    virtual GenericCounts* getCounts(char* filename, int totalPermutations, int* pos, int size)=0;
  

		virtual MeasureResults* getResults()=0;
		
virtual stringList* getHeadFile()=0;		


  virtual string getName()=0;
virtual string getShortName(){ return getName(); } ;

  virtual bool operator==(GenericMeasure& otherMeasure) {throw NonImplemented(" bool operator==(GenericMeasure& otherMeasure)"); };



virtual  GenericMeasure* fromString(string s)=0;

friend ostream& operator<<(ostream& out, GenericMeasure& l) 
{
try
{
l.print(out); 
}
catch (BasicException& be){be.addMessage("\ncalled from ostream& operator<<(ostream& out, GenericMeasure& l)  "); throw;};
return out;
};

virtual void print(ostream&)=0;


	};



/*
{

}
*/

};

#endif
