#ifndef MDL_cpp//
#define MDL_cpp//



namespace BIOS 
{

/*______________________________________________________*/

template<class T> MDL<T>::MDL(BayesType bayesType, float alpha): MLEst<T>(bayesType, alpha)
{

/*
this->alpha=alpha;
this->bayesType=bayesType;
if (alpha==0) this->alpha=1;
if (bayesType==MLE) this->bayesType=UBalpha;
*/
}


/*______________________________________________________*/

template <class T> double MDL<T>::getMeasure(CPT *s1, CPT* s2)
{
cout <<"MDL<T>::getMeasure not defined yet";
end();
}

/*______________________________________________________*/

template<> double MDL<int>::getMeasure(CPT *pt, CPT* priors)
{
//It is used to compute MDL of x versus MDL of x given y 
// If s1 has no values, we compute MDL of x
//if not, we computeMDL of x given y
// MDL is recommended for a tradeoff between complexity and training accuracy (empirical error)
// For only marginals it is defined as MLE+log2(n)*(totalPositions-1)/2
// For conditionals is defined as MLE+log2(n)*[(parentsConf-1)+(childrenConf-1)*parentsConf]/2
double mdl=-MLEst<int>::getMeasure(pt, priors);//(=2xEntropy)
//cout <<"mdl is " << mdl;
double w=log2(pt->getTotalSample())/2;
int parentConfigurations, childrenConfigurations;
if (pt->getConditionals()==NULL)
mdl=mdl+w*(pt->getMarginals()->getSize()-1);
else
{
parentConfigurations=pt->getMarginals()->getSize();
childrenConfigurations=pt->getConditionals()->getSize()/pt->getMarginals()->getSize();
mdl=mdl+w*((parentConfigurations-1)+(childrenConfigurations-1)*parentConfigurations);
}
return mdl;
}

  /*______________________________________________________*/

template<class T> ostream& operator<<(ostream& out, MDL<T>& lista)
{
 
out << *lista.sample;

return out;
  }
} // end namespace
#endif
