#ifndef __MeasureTypeClass_h__
#define __MeasureTypeClass_h__


namespace BIOS {

enum MeasureType {
	mERM=0,
	mSRM=1, //filter
	mMDL=2, //filter
	mEntropy=3,
        mBayesianScore=4,
	mCorrelation=5,
	mSymmetricalUncertainty=6,
	mInformationGain=7
};





class MeasureTypeClass {


public:

MeasureType measureType;
 	
MeasureTypeClass(MeasureType measureType)
{
this->measureType=measureType;
}

}; 	


ostream& operator<<(ostream& out, MeasureTypeClass& p)
{
        out <<"Measure type:\t\t";
	switch (p.measureType)
	{
	case mERM: out <<"ERM"; break;
	case mSRM:  out <<"SRM"; break;
	case mMDL:  out <<"MDL"; break;
	case mEntropy:  out <<"Entropy"; break;
	case mBayesianScore:  out <<"Bayesian Score"; break;
	case mCorrelation:  out <<"Correlation"; break;
        case mSymmetricalUncertainty: out << "Symmetrical uncertainty"; break;
	case mInformationGain: out << "Information gain"; break;
	}
	return out;
}








}

#endif
