/* File: AlleleCPT.cpp */


#ifndef __AlleleCPT_cpp__
#define __AlleleCPT_cpp__


#include "AlleleCPT.h"

using namespace std;

namespace BIOS
{


  /*______________________________________________________*/

  AlleleCPT::AlleleCPT(intSample*  sample, intList *varList, intList *conditionalVarList, intList* dimensionList, BayesType bayesType, float alpha, ListOfAttributes* listOfAttributes):CPT()
   {

prior=false;
float alphaDenominator=listOfAttributes->getAlphaDenominator(bayesType, alpha, varList, conditionalVarList); 
AlleleProbabilityTable* pT= new AlleleProbabilityTable(sample, varList, dimensionList, listOfAttributes, NULL,  alphaDenominator);
if (!BIOS::empty(conditionalVarList))
{
this->marginals=pT->marginalize(conditionalVarList);
this->conditionals=pT->getConditional(conditionalVarList);
}
else 
{
this->marginals=new ProbabilityTable(*pT);
this->conditionals=NULL;
}
zap(pT);
distr=getProbabilityTable();
}
/*______________________________________________________*/

  AlleleCPT::~AlleleCPT() {};
 /*______________________________________________________*/

  void AlleleCPT::empty() {};

}//end namespace



#endif
