/* File: BidimensionalVarsTable.cpp */


#ifndef __BidimensionalVarsTable_cpp__
#define __BidimensionalVarsTable_cpp__


using namespace std;

namespace BIOS
{

 /*______________________________________________________*/

  template<class T> BidimensionalVarsTable<T>::BidimensionalVarsTable(intList *varList, intList* dimensionList):VarsTable<T>(varList, dimensionList), BidimensionalTable<T>()
  {
  set();
}
 /*______________________________________________________*/

  template<class T> void BidimensionalVarsTable<T>::set()
  {
   BidimensionalTable<T>::totalDimensions=VarsTable<T>::totalDimensions;
   BidimensionalTable<T>::table=VarsTable<T>::table;
   BidimensionalTable<T>::dimensionList=VarsTable<T>::dimensionList;
   BidimensionalTable<T>::size=VarsTable<T>::size;
   BidimensionalTable<T>::totalCounts=VarsTable<T>::totalCounts;
  }

 /*______________________________________________________*/

  template<class T> BidimensionalVarsTable<T>::BidimensionalVarsTable(int xSize, int ySize):VarsTable<T>(), BidimensionalTable<T>()
  {
	intList* varList=new intList(2);
	intList* dimensionList= new intList();
	dimensionList->insertElement(xSize);
	dimensionList->insertElement(ySize);
        VarsTable<T>::set(varList, dimensionList);
	set();
	zap(varList);
	zap(dimensionList);
}
/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getMeanXY()
//  E(xy) with consecutive values starting at 0, as it will be used only for cov and correlationCoeffcient (invariants to origen or scale change)
{
double mean=0;
for (int i=0;i<this->dimensionList(0);i++)
 for (int j=0;j<this->dimensionList(1);j++)
   mean=mean+this->getValue(i,j)*i*j;
return mean/this->totalCounts;
}
/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getTotalConditional(int var, int modality)
{
double sum=0;
for (int i=0;i<this->VarsTable<T>::dimensionList->getElement(abs(var-1));i++)
if (var==0) sum=sum+this->BidimensionalTable<T>::getValue(modality,i);
else sum=sum+this->BidimensionalTable<T>::getValue(i, modality);
return sum;
}
/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getMarginalMean(int var)
//  E(x) with consecutive values starting at 0, as it will be used only for cov and correlationCoeffcient (invariants to origen or scale change)
{
double mean=0, sum=0;
for (int i=0;i<this->BidimensionalTable<T>::dimensionList->GetElement(var);i++)
{
 sum=0;
 for (int j=0;i<this->BidimensionalTable<T>::dimensionList->GetElement(abs(var-1));j++)
  sum=sum+this->BidimensionalTable<T>::getValue(i,j);
 mean=mean+sum*i;
return mean/this->BidimensionalTable<T>::totalCounts;
}
}
/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getMarginalMeanOfSquares(int var)
//  E(var^2) with consecutive values starting at 0, as it will be used only for cov and correlationCoeffcient (invariants to origen or scale change)
{
double mean=0, sum=0;
for (int i=0;i<this->BidimensionalTable<T>::dimensionList(var);i++)
{
 sum=0;
 for (int j=0;i<this->BidimensionalTable<T>::dimensionList(abs(var-1));j++)
  sum=sum+this->BidimensionalTable<T>::getValue(i,j);
 mean=mean+sum*pow(i,2);
return mean/this->BidimensionalTable<T>::totalCounts;
}
}


template<class T> double BidimensionalVarsTable<T>::getCovariance()
// It can be computed as E(xy)-E(x)E(y)
{
return getMeanXY-getMarginalMean(0)*getMarginalMean(1);
}

/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getCorrelationCoefficient()
// Defined as cov(x,y)/(stDeviation(x) stDeviation(y)
{
return getCovariance/(getStDev(0)*getStDev(1));
}

/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getR2()
// Defined as cov(x,y)/(stDeviation(x) stDeviation(y)
{
return getCorrelationCoefficient^2;
}

/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getStDev(int var)
// It is invariant to origen or scale change
{
return this->getVarianze(var);
}
/*___________________________________________________*/

template<class T> double BidimensionalVarsTable<T>::getVariance(int var)
// It can be computed as E(var^2)-E(var)^2
{
return this->getMarginalMeanOfSquares(var)-pow(this->getMarginalMean(var),2);
}
/*___________________________________________________*/

template<class T> void BidimensionalVarsTable<T>::setValue(int i, int j, T value)
// It can be computed as E(var^2)-E(var)^2
{
this->BidimensionalTable<T>::setValue(i, j, value);
}

}
#endif
