/* File: Binomial.h */


#ifndef __Binomial_h__
#define __Binomial_h__



namespace BIOS {


/************************/
/* Binomial STATISTIC*/
/************************/


/**
        @memo Binomial

	@doc
        Definition:
        Binomial distribution of size Size 

        Memory space: O(Size). 

        @author Maria M. Abad
	@version 1.0
*/


 
class Binomial  {


protected:
    /** @name Implementation of class Binomial
        @memo Private part.
    */
double p;
int* values, pointer, n, Size;
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* PUBLIC FUNCTIONS (INTERFACE) */

public:

static double pdfBinomial(double val, int samples, double prob);
static double cpdfBinomial(double val, int samples, double prob);
Binomial(int samples, double prob);
Binomial(int samples);
~Binomial();
//int  * getValues(int n);
int getNextValue();
int random_binomial();
void setAllValues();
int* getFrequencies();
int getPointer();

};  // End of class Binomial

ostream& operator<<(ostream& out, Binomial& pm)
       {
throw NonImplemented("ostream& operator<<(ostream& out, Binomial& pm)");
return out;
};


};  // End of Namespace

#endif

/* End of file: Binomial.h */




