#include <iostream>
//#include <ostream>
//#include <fstream>
#include <string>
#include <math.h>


#ifndef __gamma_h__
#define __gamma_h__

/*********************************************************************
   Returns the imcomplete gamma functions P(a,x) and Q(a,x).
   C.A. Bertulani        May/15/2000
*********************************************************************/
namespace BIOS {

/*********************************************************************
   Returns the imcomplete gamma function
   P(a,x) = (int_0^x e^{-t} t^{a-1} dt)/Gamma(a) ,      (a > 0).
   C.A. Bertulani        May/15/2000
*********************************************************************/
double gammai(double a, double x);
/*********************************************************************
   Returns the imcomplete gamma function 
   Q(a,x) = 1-P(a,x)
		  = (int_x^infinity e^{-t} t^{a-1} dt)/Gamma(a) ,      (a > 0). 
   C.A. Bertulani        May/15/2000
*********************************************************************/
double gammq(double a, double x);
/*********************************************************************
   Returns the imcomplete gamma function P(a,x) evaluated by its series
   representation as gamser.
   Also returns ln(Gamma(a)) as gln.
   C.A. Bertulani        May/15/2000
*********************************************************************/
#define ITMAX 100
#define EPS 3.0e-7

void gser(double *gamser, double a, double x, double *gln);
}

#undef ITMAX
#undef EPS
/*********************************************************************
   Returns the imcomplete gamma function Q(a,x) evaluated by its 
   continued fraction representation as gammcf.
   Also returns ln(Gamma(a)) as gln.
   C.A. Bertulani        May/15/2000
*********************************************************************/
#define ITMAX 100			/* Maximum allowed double of iterations. */
#define EPS 3.0e-7			/* Relative accuracy */
#define FPMIN 1.0e-30		/* double near the smallest representable */
							/* floating point double. */

void gcf(double *gammcf, double a, double x, double *gln);
#undef ITMAX
#undef EPS
#undef FPMIN
/********************************************************************
   Returns the value of ln[Gamma(xx)] for xx > 0
********************************************************************/

double gamma_ln(double xx);
/*********************************************************************/
double gamma(double x);

/*********************************************************************/
double erf(double x);


#endif
