#ifndef __CommandLineParserGWAS_cpp__
#define __CommandLineParserGWAS_cpp__

namespace BIOS {

	CommandLineParserGWAS::CommandLineParserGWAS(int argc, char*argv[])
	{
		this->argc = argc;
		this->argv = argv;	

		this->parse();	
	};


	CommandLineParserGWAS::~CommandLineParserGWAS()
	{
		//free(pos);
	};

	void CommandLineParserGWAS::parse()
	{

		struct arg_str *sample_name = arg_str1(NULL,NULL,"<sample_name>","Input sample name.");
		struct arg_int *allele_order = arg_int0("Oo","order", "<allele order>","Allele order type. Default 2 which indicates that haplotypes are knwon");
		struct arg_int *sample_number = arg_int0("Nn","sample_number", "<sample number>","Total number of samples. Default 1");

		struct arg_int *w_width = arg_int0("Ww","width", "<window width>","Windows width. Default 10");
		struct arg_int *w_offset = arg_int0("Ff","offset", "<window offset>","Window offset. Default 1");

		struct arg_str *testMode = arg_str0("Tt","testMode","<test mode>","Test Mode (tHoldout, tTraining). Default tTraining");
		struct arg_int *npermu = arg_int0("Pp","permutations", "<Permutations>","Total number of permutations. Default 100");
	
		struct arg_lit *help  = arg_lit0(NULL,"help",       "print this help and exit");
		struct arg_end * end = arg_end(10);

		void * argtable[] = {sample_name, allele_order, sample_number, testMode, w_width, w_offset, npermu, help, end};	
	
		if (arg_nullcheck(argtable) != 0)
			printf("error: insufficient memory\n");

		// Default values	
		allele_order->ival[0] = 2;
		w_width->ival[0] = 10;
		w_offset->ival[0] = 1;
		sample_number->ival[0] = 1;
		testMode->sval[0] = "tTraining";
		npermu->ival[0] = 100;
	
		int nerrors = arg_parse(argc,argv,argtable);
	

		if (help->count > 0 )
		{
		    printf("\nUsage: %s",argv[0]);
		    arg_print_syntax(stdout,argtable,"\n");
		    //printf("\nProgram to calculate distances in samples.\n");
		    printf("The program accepts the following arguments.\n\n");
		    arg_print_glossary(stdout,argtable,"  %-25s %s\n");
			printf("\n");
		    
		    //exit (0);
			parsingOK = false;
			return;
		}	
	
		if (nerrors > 0){
			arg_print_errors(stdout,end,argv[0]);
			parsingOK = false;
			return;
			//exit(1);
		}

		alleleOrderType=(AlleleOrderType)allele_order->ival[0];
		window_width = (int)w_width->ival[0];
		window_offset = (int)w_offset->ival[0];
		totalSamples=sample_number->ival[0];
		permutations = (int)npermu->ival[0];

		path = string ( sample_name->sval[0] );
		string tmpTestMode = string ( testMode->sval[0] );
		fileName = string ( sample_name->sval[0] );
		size_t found;
		found = fileName.rfind("/");
		if (found!=string::npos)
			fileName.erase(0,found+1);	

		fileNameNoExtension = fileName;

		found = fileName.rfind(".");
		if (found!=string::npos)
			fileNameNoExtension.erase(found);	
		
		if ( !splitFileName() ){
			cerr << "Error CommandLineParserGWAS::splitFileName" << endl;
			parsingOK = false;
			return;
		}

		this->testMode = 3;
		if ( tmpTestMode == "tHoldout" )
			this->testMode = 2;

		arg_freetable(argtable,sizeof(argtable)/sizeof(argtable[0]));				
	
		parsingOK = true;
	};

	std::string CommandLineParserGWAS::ithSampleFileName(int i)
	{
		string out;

		out = path + string("_") + tos(i) + ".gou";

		return out;
	};

	bool CommandLineParserGWAS::splitFileName(){
		//PowerOneLocusRec0.0000000_RR8_RecOrRec_Size200
		size_t found, found2;

		found = fileName.find("Rec");
		if (found!=string::npos){
			test = fileName.substr(0 ,found);	
			recombination = fileName.substr(found+3, 9);	
		}
		else{
			return false;
		}

		found = fileName.find("_RR");
		if (found!=string::npos){
			found2 = fileName.find("_",  found +1 );
			RR = fileName.substr(found+3 ,found2-found-3);	

		}
		else{
			return false;
		}

		found = found2;
		found2 = fileName.find("_",  found +1 );

		if (found==string::npos){
			return false;
		}

		model = fileName.substr(found +1,found2-found-1);	
		return true;

	}



};


#endif

