/* File: CoupleGenotype.h */


#ifndef __CoupleSNPGenotype_h__
#define __CoupleSNPGenotype_h__

//#include <string.h>
//#include <cstdio>


//#include "PairGenotype.h"

namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class CoupleSNPGenotype: public PairSNPGenotype {


protected:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	

 Diplotype fatherGenotype, motherGenotype;
   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:


CoupleSNPGenotype (CoupleSNPGenotype * Source);

CoupleSNPGenotype (Diplotype  Source1, Diplotype Source2);

Diplotype getMotherGenotype();

Diplotype getFatherGenotype();



      /** @name Operations on Genotype 
        @memo Operations on a Genotype 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */





      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
      ~CoupleSNPGenotype ();



	
};  // End of class Genotype



};  // End of Namespace

#endif

/* End of file: Genotype.h */




