/* File: Diplotype.h */


#ifndef __Diplotype_h__
#define __Diplotype_h__


namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class Diplotype {


public:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	   	  
		   allele Left;
		   allele Right;
	  



public:
	//char line[10];

      /**
      @memo Declaration of type gender
      @doc It can have one of {1,2} values. 1 for male, 2 for female.
      */

	  
   /** @name Number of individuals (sample size)
        @doc Is the total number of individuals in the sample.
    */
   
   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

		void CheckRangeSNP(SNPPos SNP);



		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on Genotype 
        @memo Operations on a Genotype 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
	Diplotype();


//	Diplotype(const DiplotypeS & Dip);


      /**
         @memo Copy constructor
         @param destino: Genotype where will be copy
         @param origen: Genotype to copy
         @doc
           Make a copy of Genotype
           Time complexity in time O(1).
        */
	Diplotype (const Diplotype& Source);

	//Diplotype(DiplotypeS D);

	Diplotype (allele left, allele right);

Diplotype* clone();

      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
    ~Diplotype ();

      /**
         @memo Assignation
         @param g Genotype to copy.
         @return Reference to the receptor Genotype.
	 @doc
           Copy the Genotype in the receptor Genotype.
           Time complexity O(1).

      */
  //  Diplotype operator=(const Diplotype g);




      /**
         @memo Is equal
         @param g: Genotype to compare with.
	 @return
           Return true if all the Genotype is the same, false otherwise.
         @doc Time complexity O(1).

      */
      bool operator==(const Diplotype & g);
      /**
         @memo Is different
         @param g, position: Genotype to compare with.
	 @return
           Return true if the SNP is different, false otherwise.
         @doc Time complexity O(1).

      */
      bool operator!=(const Diplotype & g){cout <<"Not implemented yet"; exit(0);};

	  bool  operator>(const Diplotype & di){cout <<"Not implemented yet"; exit(0);};

	  bool  operator<(const Diplotype & di){cout <<"Not implemented yet"; exit(0);};

static void checkAllele(allele a);

	  SNPPos GetTotalSNPs();
   
      void OrderSNPs ();

      void OrderMajorFirst (allele MajorAllele);

      static void orderMajorFirst (allele& left, allele& right, allele MajorAllele);

	  allele getLeftAllele ();

  	  allele getRightAllele ();

	  void setLeftAllele (allele left);

  	  void setRightAllele (allele right);


	  bool IsEqual(Diplotype g);

	  
      /**
         @memo Check if the genotype is non missing.
         @param g: pointer to the genotype to check.
         @return bool
         @doc Return a false if one or both alleles in the genotype are missing,
         return a true if both are non missing. Complexity O(1).

      */
        bool isANonMissingSNP ();   
        static bool isANonMissingSNP (allele& left, allele & right);   
bool isAMissingSNP (bool left);
bool leftIsMissing ();
bool rightIsMissing ();


      /**
         @memo Check if the genotype is heterozygous
         @param g: pointer to the genotype to check.
         @return bool 
         @doc Return a false if the genotype snp is not heterozygous
         (it can be missing, homozygous wild type or homozygous mutant).
         return a true if the genotype snp is heterozygous.
         Complexity O(1).

      */
        bool isHeterozygous ();             

        bool isHeterozygous (allele majorAllele);

								static bool isHeterozygous (allele& left, allele& right, allele majorAllele);

								static bool isHeterozygous (allele& left, allele& right);

      //  bool isHeterozygous (allele oneAllele, allele otherAllele);             

//	bool IsHeterozygous (MultiallelicHetero i, allele* alleles, int totalAlleles);
      
		/**
         @memo Check if the genotype is homozygous for wild-type allele
         @param position: pointer to the genotype to check,
         allele to check homozygosity.
         @return bool 
         @doc Return a false if the genotype snp is not homozygous wild-type
         (it can be missing, homozygous mutant or heterozygous).
         return a true if the genotype snp is homozygous wild-type.
         Complexity O(1).

      */
        bool isHomozygous ();             

        static bool isHomozygous (allele& left, allele & right);  

/**
         @memo Check if the genotype is homozygous for mutant allele
         @param position: pointer to the genotype to check,
         allele to check homozygosity.
         @return bool 
         @doc Return a false if the genotype snp is not homozygous wild-type
         (it can be missing, homozygous mutant or heterozygous).
         return a true if the genotype snp is homozygous wild-type.
         Complexity O(1).

      */


        static bool isHomozygous (allele& left, allele& right, allele oneAllele);             

        //static bool isHomozygous1 (allele MajorAllele);             

								static bool isHomozygous1 (allele& left, allele& right, allele MajorAllele);             

        static bool isHomozygous2 (allele& left, allele& right, allele MajorAllele);             


/**
         @memo Check if the genotype is homozygous 
         @param position: pointer to the genotype to check,
         allele to check homozygosity.
         @return bool 
         @doc Return a false if the genotype snp is not homozygous 
         (it can be missing, or heterozygous).
         return a true if the genotype snp is homozygous.
         Complexity O(1).

      */
        
		void changeAlleles ();

		static void changeAlleles (allele& left, allele& right);

		//void markAlleles ();
static void markAlleles(allele& left, allele& right);
  


 	  /**
         @memo Increase the counter of the total number of known haplotypes between two positions.
         @param comb: pointer to a 5-integer array: 1: 11, 2:12, 3: 21, 4: 22
         @param IndGenotype: individual whose haplotype is going to be checked
         @param FirstSNP, LastSNP: the two loci
     */
     
//int getGenotypeCode ();

static int getGenotypeCode (allele& left, allele & right);

		bool isAMissingSNP ();

		string print(bool markUnphased=false);

		string print(HaplotypeType h);

		//void OrderRandomly(allele MajorAllele);

	static void orderRandomly(allele& left, allele & right, allele MajorAllele);

		bool IsMarked ();

	static	bool isMarked (allele& left, allele & right);

		void setAlleles (allele Left, allele Right);

		static void setAsKnown (allele& Left, allele& Right);

		void setAsKnown ();

    static Diplotype* fromString(string s)
{
throw NonImplemented("static Diplotype* fromString(string s)");
};

};  // End of class Diplotype




ostream& operator<<(ostream& out, Diplotype& diplotype);

/******************************************************************/

//template <> Container<vector, Diplotype>::iterator Container<vector, Diplotype>::removeNode(Container<vector, Diplotype>::iterator it); 
};  // End of Namespace

#endif

/* End of file: Genotype.h */




