
#ifndef __Excep_h__
#define __Excep_h__



namespace BIOS {




class MultiAllelic {
public:
unsigned long int pos;
MultiAllelic(){};
MultiAllelic(unsigned long int pos)
{
this->pos=pos;
}
  void PrintMessage(unsigned long int pos) {
                cout << "\nThere is a Multiallelic SNP at position " << pos<<".\n";
 }
        void PrintMessage(unsigned long int pos, unsigned int* Basis) {
                cout << "\nThere is a Multiallelic SNP at position " << pos<<".\n";
                for (int i=0; i<4; i++)
                 if (Basis[i]>0) cout <<"\n"<< Basis[i] << " counts of allele " << i;
	}
   void PrintMessage(string message) {
                cout << "\nThere is a Multiallelic SNP at pos " << pos << ", error at " << message  << ".\n";
	}
		        void PrintMessage() {
                cout << "\nThere is a Multiallelic SNP at pos " << pos << ".\n";
	}

};

class MonoAllelic {
public:
        void PrintMessage(unsigned long int pos) {
                cout << "\nThere is a Monoallelic SNP at position " << pos<<".\n";
	}
		        void PrintMessage() {
                cout << "\nThere is a Monoallelic SNP.\n";
	}

};



class Inconsistent: public BasicException {
public:
Inconsistent()
{
}
Inconsistent(const char* message):BasicException()
{
this->message=string(message);
}

        void PrintMessage(unsigned long int pos) {
                cout << "\nThere is an inconsistent SNP at position " << pos<<".\n";
	}
		        void PrintMessage() {
                cout << "\nThere is an inconsistent SNP at " << message << "\n";
	}

};

class UnorderedPos {
public:
        void PrintMessage() {
                cout << " Positions are not ordered.\n";
	}
};




class IncorrectParameters {
public:
        void PrintMessage() {
                cout << "\nEspecified number of individuals y/or number of SNPs do not match with those in the file.\n";
	}
};


class IncorrectAlgorithm {
string cad;
public:
IncorrectAlgorithm (){};
IncorrectAlgorithm (const char* cad) {this->cad=string(cad);}
        void PrintMessage() {

         cout << "Error, algorithm " << cad << " is not allowed";
	}
};


class IncorrectWay {
public:
        void PrintMessage() {

         cout << "Error, way must be e (for Export) or i (for import)";
	}
};



class NonHetero {
public:
        void PrintMessage(unsigned int position, int ind=-1) {

         cout << "Error, the position " << position << " is not heterozygotic";
		 if (ind>=0) cout << " for individual " << ind;
	}
};


class NonExist {
public:
        void PrintMessage(unsigned int position) {

         cout << "Error, the position " << position << " does not exist\n";
	}
};


class OverflowedSNP: public OutOfBounds {
public:

OverflowedSNP ( int first, int second, const char* message ): OutOfBounds(first, second, message)
{
};
 void PrintMessage() {

         cout << "OverflowedSNP exception, the SNP number " << first << " overpass the total number of SNPs: " << second <<" at " << message <<"\n";
	}
        void PrintMessage(unsigned long int SNP) {

         cout << "OverflowedSNP exception, the SNP number " << SNP << " overpass the total number of SNPs\n";
	}
		void PrintMessage(unsigned long int SNP, const char* message) {

         cout << "OverflowedSNP exception, the SNP number " << SNP << " overpass the total number of SNPs at " << message <<"\n";
	}
};


class NonSNP: public BasicException {
public:
string val;
const char* valChar;
//NonSNP(){};

NonSNP(int val, const char* message)
{
this->val=tos(val);
this->message=string(message);
}
NonSNP(const char* valChar, const char* message)
{
this->val=string(valChar);
this->message=string(message);
}

        void PrintMessage() {
                cout << val << " is not a nucleotide value at " << message << ".\n";
		exit(1);
		}


        void PrintMessage(const char* message) {
                cout << val << " is not a nucleotide value at " << message << ".\n";
		}
/*
		   void PrintMessage(unsigned long int value) {
                cout << value << " is not a nucleotide value.\n";
		exit(1);
	}
//	   void PrintMessage(short int value) {
//                cout << value << " is not a nucleotide value.\n";
//		exit(1);
//	   }
*/
};


class NonFound {
public:
        void PrintMessage() {

         cout << "Error, individual has not been found\n";
	}
};


class UnsolvedPhase: public BasicException {

int snp1, snp2;
public:
        UnsolvedPhase(int s1, int s2, string message):BasicException(message)
        {this->snp1=s1; this->snp2=s2;};
        void PrintMessage() {

         cout << "Error, phase non solved, snps are " << snp1 <<" and " << snp2 <<" at "<< message <<"\n";
	}
};

}

#endif
