#ifndef GWAS_cpp//
#define GWAS_cpp//






//using namespace UTILS;

namespace BIOS {

/*___________________________________________________________ */
/*
GWAS::GWAS(GenericMLTest** genericMLTests, char* fileSample, int totalSamples, TestModeClass *testMod, bool useOnlyHetero, int iniPos, int length, int width, int offset, ListOfGenericMeasures* measures, PairOfDoublesVector* alpha)
{
try
{
this->fileSample=fileSample;
this->genericMLTests=genericMLTests;
this->totalSamples=totalSamples;
int realSize=length;
if (length==-1) realSize=genericMLTests[0]->getSize();
this->sw=new SlidingWindows(width, offset, realSize);
this->measures=measures;
this->totalWindows=sw->getTotalCompleteWindows();
this->totalUsedSNPs= sw->getTotalUsedSNPs();
this->totalMeasures=measures->size();
this->alpha=alpha;
averageResults=NULL;
resultsForWindows=NULL;
cout <<"\nReading samples";
for (int i=0; i<totalSamples; i++)
{
//cout <<"setting samples:" << i <<"\n";
//cout << genericMLTests[i]->getFileName() <<"\n";
genericMLTests[i]->setSubsamples(iniPos, length); // cannot be done in the constructor of GenericMLTest because it uses virtual methods
if (i%10==0) cout <<"\nSample " << i+1;
}
setResults();
}
catch (BasicException& be){be.addMessage("\ncalled from GWAS::GWAS(GenericMLTest** genericMLTests, char* fileSample, int totalSamples, TestModeClass *testMod, ..."); throw;};
}

/*___________________________________________________________ */

GWAS::GWAS()
{
set();
}

/*___________________________________________________________ */

GWAS::GWAS(ListOfGenericMeasures* measures, char* fileSample, const char* resultsDir, int totalSamples, TestMode testMode, int numberOfFolds, int testModeForInsideMeasure,
int width, int offset, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha,  TestMode externalTestMode)
{
try
{
set(measures, fileSample, resultsDir, totalSamples, testMode, numberOfFolds, testModeForInsideMeasure, width, offset, totalPermutations, iniPos, length, measureFiles, useOnlyHetero, returnPVals, genotypeOrder, phaseAlg, emDistributions, emRestriction, alpha, externalTestMode);
}
catch (BasicException& be){be.addMessage("\ncalled from GWAS::GWAS(ListOfGenericMeasures* measures,, ..."); throw;};

}
/*___________________________________________________________ */
/*
void GWAS::setMeasureFiles(bool measureFiles)
{
this->measureFiles=measureFiles;
}


/*___________________________________________________________ */

GWAS::~GWAS()
{
for (int i=0; i<totalMeasures;i++)
{
zaparr(resultsForWindows[i], totalWindows); 
zaparr(averageResults[i], totalUsedSNPs);
}
zaparr(resultsForWindows, totalMeasures);
zaparr(averageResults, totalMeasures);
zap(sw);
zaparr(genericMLTests, totalSamples);
zap(testModeClass);
zap(hapExtractionConfiguration);
zap(alpha);
}

/*___________________________________________________________ */

void GWAS::set()
{
testModeClass=NULL;
hapExtractionConfiguration=NULL;
genericMLTests=NULL;
}

/*___________________________________________________________ */

void GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, int totalSamples, TestMode testMode, int numberOfFolds, int testModeForInsideMeasure, 
int width, int offset, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals, AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alphaBasic, TestMode externalTestMode)
{
try
{
this->returnPVals=returnPVals;
if (resultsDir!=NULL) strcpy(this->resultsDir,resultsDir);
else strcpy(this->resultsDir, getFilePath(fileSample));

this->measureFiles=measureFiles;
this->fileSample=fileSample;
this->totalSamples=totalSamples;
if (testMode!=tCrossValidation && testMode!=tLeaveOneOut) testModeClass=new TestModeClass(testMode);
else testModeClass=new TestModeClass(testMode, numberOfFolds);
hapExtractionConfiguration=new HapExtractionConfiguration(genotypeOrder, phaseAlg, emDistributions, emRestriction);
genericMLTests=new GenericMLTest*[totalSamples];
alpha=new PairOfDoublesVector();
if (alphaBasic!=NULL)
for (int i=0; i<alphaBasic->size(); i++)
 alpha->insertElement(new PairOfDoubles(-MAXFLOAT, alphaBasic->getElement(i)));
else
{
alpha->insertElement(new PairOfDoubles(-MAXFLOAT, 0.01));
alpha->insertElement(new PairOfDoubles(-MAXFLOAT, 0.05));
alpha->insertElement(new PairOfDoubles(-MAXFLOAT, 0.001));
alpha->insertElement(new PairOfDoubles(-MAXFLOAT, 0.005));
}
char wholefilename[256]; 
strcpy(wholefilename, fileSample);
averageResults=NULL;
resultsForWindows=NULL;
this->measures=measures;
this->totalMeasures=measures->size();
//cout <<"beforewidth:" << width <<",offset:" << offset << " and length: " << length <<", totalsamples: "<< totalSamples << "file:" << wholefilename << "\n";
int totalTrue=0;
for (int i=0; i<totalSamples; i++)
{
if (i%10==0) cout <<"\nSample " << i+1;
if (totalSamples!=1) sprintf(wholefilename, "%s%d.gou", fileSample, i);
genericMLTests[i]=NULL;
if (fileExists(wholefilename) && fileSize(wholefilename)!=0)
{
totalTrue++;
genericMLTests[i]=new TUMLTest(wholefilename, testModeClass, hapExtractionConfiguration, totalPermutations, useOnlyHetero, testModeForInsideMeasure);
if (length==-1 && i==0) length=genericMLTests[0]->getSize()-iniPos;
genericMLTests[i]->setSubsamples(iniPos, length); // cannot be done in the constructor of GenericMLTest because it uses virtual methods
}
else 
if (totalSamples==1)
throw ErrorFile(wholefilename, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i...");
}
if (totalTrue==0)
{
if (totalSamples!=1) sprintf(wholefilename, "%s%d.gou", fileSample, 0);
throw ErrorFile(wholefilename, "GWAS::set(ListOfGenericMeasures* measures, char* fileSample, const char*resultsDir, i...");
}
/*cout <<"inimiddleremoving\n";
zaparr(genericMLTests, totalSamples);
for (int x=0; x<100000; x++)
for (int y=0; y<2000; y++);
cout <<"endmiddlecchecking\n";

cout <<"inisec\n";
for (int x=0; x<100000; x++)
for (int y=0; y<20000; y++);
cout <<"endsec\n";
exit(0);
*/
//cout <<"width:" << width <<",offset:" << offset << " and length: " << length <<"\n";
this->sw=new SlidingWindows(width, offset, length);
this->totalWindows=sw->getTotalCompleteWindows();
this->totalUsedSNPs= sw->getTotalUsedSNPs();

if (testModeForInsideMeasure>0)
{
zap(testModeClass);
testModeClass=new TestModeClass(externalTestMode);
}
//cout <<"inisec\n";
//for (int x=0; x<100000; x++)
//for (int y=0; y<20000; y++);
//cout <<"endsec\n";
setResults();
}
catch (BasicException& be){be.addMessage("\ncalled from GWAS::set(ListOfGenericMeasures* measures, char* fileSample, int totalSamples, TestMode testMode, int width, int offset, int totalPermutations, i, ..."); throw;};
}

/*___________________________________________________________ */
/*
GenericCounts*  GWAS::getCounts(char* file, int*pos, int size)
{
TrioSample* ts=new TrioSample(file, pos, size);
GenericCounts* results=ts->getTUCounts(pos, size, hapExtractionConfiguration, useOnlyHetero, totalPermutations);
zap(ts);
return results;
}
/*___________________________________________________________ */

void  GWAS::setResults()
{
	try
	{
	 Container<vector<ofstream*>,ofstream*>* listOfStreams=NULL;
	 if (measureFiles) listOfStreams=getWindowsStreams(false, "detail");
	 resultsForWindows=new MeasureResults**[totalMeasures];
	 averageResults=new MeasureResults**[totalMeasures];
	 for (int k=0; k<totalMeasures; k++)
	 {
		resultsForWindows[k]=new MeasureResults*[totalWindows];
		averageResults[k]=new MeasureResults*[totalUsedSNPs];
	 }
	 int* pos;
	 MeasureResults*** temp, * temp2[totalSamples];
	 cout <<"\nTotal number of windows calculated: " << totalWindows<<endl;
  for (int i=0; i<totalWindows; i++)  // WINDOWS
	 {
		  // for each given window, repeat the process of calculating p-values
		  if ((i+1)%10==0) cout <<"window number: " << i+1 <<endl;
		  pos=sw->getAbsolutePositions(i);
		  temp=new MeasureResults**[totalSamples];
		  for (int j=0; j<totalSamples; j++)  // SAMPLES
		  {
				// for each sample file in disk (in the corresponding window) calculate p-values
				if (totalSamples>1 && (j+1)%10==0) cout <<"sample number: " << j+1 <<endl;
					if (genericMLTests[j]!=NULL)
				{
				  // genericMLTests has the data for each sample
				  genericMLTests[j]->setGenericCounts(pos, sw->getSizeOfWindow(i)); 
				  // calculate p-values for 'measures'
				  temp[j]=genericMLTests[j]->getResults(measures, listOfStreams);  // <-- P-VALUES
				  // free memory of tuCounts generated
				  genericMLTests[j]->emptyCounts();
				}
				else
				  temp[j]=NULL;
		  }
		  for (int k=0; k<totalMeasures; k++) 
		  {
    // for each measure it computes association rates if more than one sample is used
				for (int j=0; j<totalSamples; j++)
				  if (temp[j]!=NULL) temp2[j]=temp[j][k];
				  else temp2[j]=NULL;
				  
				if (totalSamples==1) 
				  if (temp2[0]==NULL) throw NullValue("the first sample cannot be null");
				  else resultsForWindows[k][i]=temp2[0]->clone(); 
				else resultsForWindows[k][i]=new MultipleSamplesRateResults(temp2, totalSamples, alpha, returnPVals);
				//zap(resultsForWindows[k][i]);
				//cout <<"measure:" << measures->getElement(k)->getName();
				//cout <<"pval:" << *resultsForWindows[k][i] <<"\n";
		  }
		  for (int j=0; j<totalSamples; j++)
			 zaparr(temp[j], totalMeasures);

		  zaparr(temp, totalSamples);
		  zaparr(pos);
		  //cout <<"iniSecond\n";
		  //for (int x=0; x<100000; x++)
		  //for (int y=0; y<20000; y++);
		  //cout <<"end\n";

	 } // LOOP FOR CALCULATION OF P-VALUES
	 // begin STATISTICS FOR RESULTS? 
	 {
		intSet* windowOverlaps;
		MeasureResults** mr=NULL;
		int totalOverlaps;
		for (int i=0; i<totalUsedSNPs; i++)
		{
		windowOverlaps=sw->getWindowOverlapsForPosition(i);
		totalOverlaps=windowOverlaps->size();
		mr=new MeasureResults*[totalOverlaps];
		for (int j=0; j<measures->size(); j++)
		{
		for (int k=0; k<totalOverlaps; k++)
		mr[k]=resultsForWindows[j][windowOverlaps->getElement(k)];
		averageResults[j][i]=mr[0]->getAverage(mr, totalOverlaps);
		}
		zaparr(mr); // delete pos but not the objects
		}
		if (measureFiles)
		for (Container<vector<ofstream*>,ofstream*>::iterator it=listOfStreams->begin(); it<listOfStreams->end(); it++)
		listOfStreams->getElement(it)->close();
	 }
	 // end STATISTICS FOR RESULTS?
	 
	}
	catch (BasicException& be){be.addMessage("\ncalled from GWAS::setResults()"); throw;};
}

/*___________________________________________________________ */

MeasureResults***  GWAS::getResultsForWindows()
{
return resultsForWindows;
}
/*___________________________________________________________ */

MeasureResults***  GWAS::getAverageResults()
{
return averageResults;
}
/*___________________________________________________________ */

MeasureResults**  GWAS::getResultsForWindowsForMeasure(int measureIndex)
{
return resultsForWindows[measureIndex];
}
/*___________________________________________________________ */

MeasureResults**  GWAS::getAverageResultsForMeasure(int measureIndex)
{
return averageResults[measureIndex];
}
/*___________________________________________________________ */

void  GWAS::printAverageResults(bool verticalOutput, const char* extension)
{
try
{
char filename[512], filename2[512], *single;

strcpy(filename, resultsDir);
single=removeDir(fileSample);
if (totalSamples>1) strcat(filename, single);
else 
{
strcat(filename, removeExtension(single));
strcat(filename, "_");
}

zap(single);

for (int i=0; i<totalMeasures;i++)
{
sprintf(filename2, "%saverageResultsForTestMode%s_SWOfSize%dAndOffsetOf%d_%s.", filename, testModeClass->print(testModeClass->tm).c_str(), sw->getWindowSize(), sw->getOffset(), measures->getElement(i)->getName().c_str()); 
if (extension==NULL) 
if (returnPVals) strcat(filename2, "pVal");
else strcat(filename2, "mult");
else strcat(filename2, extension);
OpenOutput(filename2, &OutputFile);
if (averageResults[0][0]==NULL) throw NullValue("GWAS::printAverageResults()");
if (verticalOutput) 
{
averageResults[0][0]->printHeading(OutputFile);
OutputFile << "\n";
}
for (int j=0; j<totalUsedSNPs; j++)
{
 averageResults[i][j]->print(OutputFile, verticalOutput);
 OutputFile << "\n";
 }
OutputFile.close();
cout <<"\nResults have been written in: " << filename2;
}
}
catch (BasicException& be){be.addMessage("\ncalled from GWAS::printAverageResults(bool verticalOutput, const char* dir, const char* extension)"); throw;};
}

/*___________________________________________________________ */

Container<vector<ofstream*>,ofstream*>*    GWAS::getWindowsStreams(bool oneFile, const char* extension)
{
Container<vector<ofstream*>,ofstream*>* listOfStreams=new Container<vector<ofstream*>,ofstream*>();

ofstream* os;

char filename[512], filename2[512], *single;

strcpy(filename, resultsDir);
single=removeDir(fileSample);
if (totalSamples>1) strcat(filename, single);
else 
{
  char * tmp = removeExtension(single);
strcat(filename, tmp);
delete tmp;
strcat(filename, "_");
}

zap(single);






if (oneFile)
{
sprintf(filename2, "%sresultsForTestMode%s_SWOfSize%dAndOffsetOf%d.", filename, testModeClass->print(testModeClass->tm).c_str(), sw->getWindowSize(), sw->getOffset()); 
if (extension==NULL) 
if (returnPVals) strcat(filename2, "pVal");
else strcat(filename2, "mult");
else strcat(filename2, extension);
os=new ofstream  (filename2, std::ios::out); 
listOfStreams->insertElement(os); 
cout <<"\nResults will be written in: " << filename2<<endl;
}
else
for (int i=0; i<totalMeasures;i++)
{
sprintf(filename2, "%sresultsForTestMode%s_SWOfSize%dAndOffsetOf%d_%s.", filename, testModeClass->print(testModeClass->tm).c_str(), sw->getWindowSize(), sw->getOffset(), measures->getElement(i)->getName().c_str()); 
if (extension==NULL) 
if (returnPVals) strcat(filename2, "pVal");
else strcat(filename2, "mult");
else strcat(filename2, extension);
os=new ofstream  (filename2, std::ios::out); 
listOfStreams->insertElement(os); 
cout <<"\nResults will be written in: " << filename2<<endl;
}
return listOfStreams;
}

/*___________________________________________________________ */

void   GWAS::printResultsForWindows(bool verticalOutput, bool oneFile, const char* extension, stringList* firstPartHeading, stringList* rowHeading)
{
if (firstPartHeading!=NULL)
{
	firstPartHeading->setOutputSeparator('\t');
	firstPartHeading->setDelimiters('\0', '\0');
}
if (rowHeading!=NULL){
	rowHeading->setOutputSeparator('\t');
	rowHeading->setDelimiters('\0', '\0');
}
Container<vector<ofstream*>,ofstream*>*listOfStreams=getWindowsStreams(oneFile, extension);
ofstream *outputFile=listOfStreams->getFirstElement();
char basicSeparator='\n';
if (oneFile && verticalOutput)  basicSeparator='\t';
// print heading
if (verticalOutput)
{
for (int i=0; i<totalMeasures;i++)
{
if (!oneFile) outputFile=listOfStreams->getElement(i);
if (firstPartHeading!=NULL && (!oneFile || i==0)) *outputFile << *firstPartHeading << "\t";
if (oneFile && i==0) *outputFile << "window\t";
resultsForWindows[0][0]->printHeadingPlus( testModeClass->getShortName() +"." + measures->getElement(i)->getShortName(),  *outputFile);
//if (i<(totalMeasures<1)) 
if (i<(totalMeasures-1)) *outputFile << basicSeparator;
}
//if (oneFile) 
*outputFile <<"\n";
}
// print body
for (int j=0; j<totalWindows; j++){
for (int i=0; i<totalMeasures;i++)
{
if (!oneFile) outputFile=listOfStreams->getElement(i);
if (rowHeading!=NULL  && (!oneFile || i==0)) *outputFile << *rowHeading << "\t" << j << "\t";
  resultsForWindows[i][j]->print(*outputFile, verticalOutput); 
if (i<(totalMeasures-1) || !verticalOutput) *outputFile << basicSeparator;
//if (oneFile) *outputFile <<"\t";
}
//if (oneFile) 
*outputFile <<"\n";
}
for (Container<vector<ofstream*>,ofstream*>::iterator it=listOfStreams->begin(); it<listOfStreams->end(); it++)
listOfStreams->getElement(it)->close();
zap(listOfStreams);
}

/*___________________________________________________________ */
/*
void  GWAS::printResultsForWindow()
{
char filename[256];
for (int i=0; i<totalMeasures;i++)
{
strcpy(filename, fileSample);
sprintf(filename, "%s_resultsForSWOfSize%dAndOffsetOf%d_%s.mult", fileSample, sw->getWindowSize(), sw->getOffset(), measures->getElement(i)->getName().c_str()); 
cout <<"Results have been written in: " << filename <<"\n";
OpenOutput(filename, &OutputFile);
resultsForWindows[0][0]->printHeading(OutputFile);
OutputFile << "\n";
for (int j=0; j<totalWindows; j++)
 OutputFile << *resultsForWindows[i][j] << "\n";
OutputFile.close();
}
}

/*___________________________________________________________ */
/*
MeasureResults**  GenericMLTest::getResults(ListOfGenericMeasures* measures, int*pos, int size)
{
MeasureResults*** results=new MeasureResults**[measures->size()], **finalResults=new MeasureResults*[measures->size()];
GenericMeasure** training=NULL, **test=NULL; 
char file[256], currentFile[256];
stringSample*sample, *result;
string t;
GenericCounts* genericCounts=NULL;
//GenericSample* gs;
for (int k=0; k<measures->size();k++)
{
results[k]=new MeasureResults*[testMod->numberOfFolds];
}
for (int i=0; i<testMod->numberOfFolds;i++)
{
cout <<"fold number: " << i <<"\n";
 training=new GenericMeasure*[measures->size()];
 test=new GenericMeasure*[measures->size()]; 
for (int j=0; j<2;j++)
{
if (j==0) t=string("dat"); else t=string("test");
 changeExtension(fileName, file, (t+tos(i)).c_str());


 for (int k=0; k<measures->size(); k++)
 if (j==0) 
 {
  if (k==0) {genericCounts=getCounts(file, pos, size);}
  training[k]=measures->getElement(k)->getNewGenericMeasure(genericCounts);
   cout <<"meuasreis:" << training[k]->getName()<<"\n";
      cout << *training[k]<<"\n";
 }
 else 
 {
 test[k]=training[k]->getNewGenericMeasure(genericCounts, true);
 results[k][i]=test[k]->getResults();
       cout <<"meuasreis:" << *test[k]<<"\n";
       cout << *results[k][i] <<"\n";
 }
 remove(currentFile);
 }
  zap(genericCounts);
  zaparr(training, measures->size()); zaparr(test, measures->size());
}
for (int k=0; k<measures->size();k++)
{
finalResults[k]=results[k][0]->getAverage(results[k], testMod->numberOfFolds);
zaparr(results[k], testMod->numberOfFolds);
}
zaparr(results, measures->size());
zaparr(pos);

return finalResults;
}
*/
} // end namespace
#endif
