/* File: GWAS.h */


#ifndef __GWAS_h__
#define __GWAS_h__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GWAS

	@doc
        Definition:
									IT decomposes a region of regionLength snps, starting at snp "firstSNP" in slinding windows of size "windowSize" and offset "offset"        

        Memory space:

        @author Maria M. Abad Grau
	@version 1.0
*/

//typedef TestMode;
 
class GWAS {


protected:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	
TestModeClass* testModeClass;
HapExtractionConfiguration* hapExtractionConfiguration;
GenericMLTest** genericMLTests;
PairOfDoublesVector* alpha;
SlidingWindows* sw;
int totalSamples;
MeasureResults*** resultsForWindows;// first pointer is for each measure, second pointer is for window index
MeasureResults*** averageResults;// first pointer is for each measure, second pointer is for SNP index
ListOfGenericMeasures* measures;
int totalUsedSNPs, totalWindows, totalMeasures;
char* fileSample;
bool measureFiles;
char resultsDir[512];
bool returnPVals;
   
private:

void setResults();
void set(ListOfGenericMeasures* measures, char* fileSample, const char* resultsDir, int totalSamples, TestMode testMode, int numberOfFolds, int testModeForInsideMeasure, int width, int offset, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals,
AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha, TestMode externalTestMode);


public:

  
  // List of params for the constructor
  
ListOfGenericMeasures* measures_;
char* fileSample_;
const char* resultsDir_;
int totalSamples_;
TestMode testMode_;
int numberOfFolds_;
int testModeForInsideMeasure_; 
int width_;
int offset_;
int totalPermutations_;
int iniPos_;
int length_;
bool measureFiles_;
bool useOnlyHetero_;
bool returnPVals_;
AlleleOrderType genotypeOrder_;
PhaseAlg phaseAlg_;
EMDistributions emDistributions_;
EMRestriction emRestriction_;
intList* alpha_;
TestMode externalTestMode_;
  




GWAS();
void set();
//void setMeasureFiles(bool measureFiles=true);

GWAS(char* fileSample, ListOfGenericMeasures* measures){

measures_ = measures;
fileSample_ = fileSample;
resultsDir_="./";
totalSamples_=1;
testMode_=tTraining;
numberOfFolds_=-1;
testModeForInsideMeasure_=true; 
width_=10;
offset_=1;
totalPermutations_=100;
iniPos_=0;
length_=-1;
measureFiles_=false;
useOnlyHetero_=true;
returnPVals_=false;
genotypeOrder_=BIOS::LeftRight;
phaseAlg_=weighted;
emDistributions_=UTDistributions;
emRestriction_=triosBasedRestriction;
alpha_=NULL;
externalTestMode_=tTraining;

}

void start(){
// 
try
{
set(measures_, fileSample_, resultsDir_, totalSamples_, testMode_, numberOfFolds_, testModeForInsideMeasure_, width_, offset_, totalPermutations_, iniPos_, length_, measureFiles_, useOnlyHetero_, returnPVals_, genotypeOrder_, phaseAlg_, emDistributions_, emRestriction_, alpha_, externalTestMode_);
}
catch (BasicException& be){be.addMessage("\ncalled from GWAS::start()"); throw;};
  
}

// testModeForInsideMeasure: 0,1,2 (0: false, 1: true and external is training default, 2: true and external is halfTraining)
GWAS(ListOfGenericMeasures* measures, char* fileSample, const char* resultsDir=NULL, int totalSamples=1, TestMode testMode=tTraining, int numberOfFolds=5, int testModeForInsideMeasure=true, 
int width=10, int offset=1, int totalPermutations=100, int iniPos=0, int length=-1, bool measureFiles=false, bool useOnlyHetero=true, bool returnPVals=false,
AlleleOrderType genotypeOrder=LeftRight, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction,   intList* alpha=NULL, TestMode externalTestMode=tTraining);
//GWAS(GenericMLTest** genericMLTest, char* fileSample, int totalSamples, TestModeClass *testMod, bool useOnlyHetero, int iniPos, int length, int width, int offset, ListOfGenericMeasures* measures, PairOfDoublesVector* alpha);
MeasureResults** getResultsForWindowsForMeasure(int measureIndex);// results for a measure
MeasureResults*** getResultsForWindows();// results for all windows
MeasureResults** getAverageResultsForMeasure(int measureIndex);// results for a SNP
MeasureResults*** getAverageResults();// results for all SNPs
~GWAS();
void  printAverageResults(bool verticalOutput=true, const char* extension=NULL);
void  printResultsForWindows(bool verticalOutput=true, bool oneFile=true, const char* extension=NULL, stringList* firstPartHeading=NULL, stringList* rowHeading=NULL);
Container<vector<ofstream*>,ofstream*>*    getWindowsStreams(bool oneFile, const char* extension);
};
} // end namespace
#endif


