/* File: Genoma.cpp */


#ifndef __Genoma_cpp__
#define __Genoma_cpp__


#include "Genoma.h"


namespace BIOS {

ostream& operator<<(ostream& out, Genoma& genoma)
       {
out << *genoma.getGenotype();
return out;
}


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////


Genoma::Genoma()
{
//line=NULL;
PG=NULL;
//DiplotypeList=NULL;
}

/*____________________________________________________________ */

Genoma::Genoma (Genoma * source)
{
//line=NULL;
genotype=source->genotype;
PG=new PairGenotype(source->PG);
ic=source->ic;
//DiplotypeList=NULL;
}
/*____________________________________________________________ */

Genotype* Genoma::getGenotype()
{
return genotype;
}
/*____________________________________________________________ */

Genoma::Genoma (Trio * T, IndCategory i)
{
ic=i;
if (ic!=offspring && ic!=mother && ic!=father)
{ cout <<"Error in Genoma::Genoma\n" << (int)ic;
	exit(0);
}

switch (ic)
{
case offspring:
	genotype=T->genotypeSample->getElement(T->getChildGenotype());
	PG=new PairGenotype(T->genotypeSample->getElement(T->getFatherGenotype()), T->genotypeSample->getElement(T->getMotherGenotype())); 
	break;
case father:
	genotype=T->genotypeSample->getElement(T->getFatherGenotype());
	PG=new PairGenotype(T->genotypeSample->getElement(T->getChildGenotype()), T->genotypeSample->getElement(T->getMotherGenotype()));
	break;
case mother:
	genotype=T->genotypeSample->getElement(T->getMotherGenotype());
	PG=new PairGenotype(T->genotypeSample->getElement(T->getChildGenotype()), T->genotypeSample->getElement(T->getFatherGenotype())); 
}
}
/*____________________________________________________________ */

Genoma::~Genoma ()
{
//zap(line);
zap(PG);
}


/*___________________________________________________*/

SNPPos Genoma::GetHaps (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, bool IsPartiallySolved, Transmission transmission)      
{
// it returns the number of haplotypes in the current genoma (0, 1 or 2) with allele1 at SNP1 and allele2 at SNP2
IndPos Total=getKnownHaps(SNP1, SNP2, allele1, allele2, allAlleles, transmission);

if (Total==0)
{ Total=GetInferredHap(SNP1, SNP2, allele1, allele2, transmission);
if (Total==0 && ic!=offspring) 
Total=GetPartiallySolved(SNP1, SNP2, allele1, allele2, allAlleles, IsPartiallySolved);
}

return Total;
};


/*___________________________________________________*/

SNPPos Genoma::GetUnsolvedHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, bool IsPartiallySolved, Transmission transmission)      
{

IndPos Total=GetInferredHap(SNP1, SNP2, allele1, allele2, transmission);

if (Total==0 && ic!=offspring && transmission==ut)	

Total=GetPartiallySolved(SNP1, SNP2, allele1, allele2, allAlleles, IsPartiallySolved);

return Total;
};


/*___________________________________________________*/

bool Genoma::CanBeInferred (SNPPos pos, AlleleOrderType alleleOrderMode)      
{
// Karnaugh map: 1111/1010/1100/1000  Rows and columns labels: OO, OH, HO, HH
// if is already known, return false
int i;

if (alleleOrderMode==LeftRight) return true;

if  (!Diplotype::isANonMissingSNP(genotype->DiplotypeArray[0][pos], genotype->DiplotypeArray[1][pos])) return false;
if (!Diplotype::isANonMissingSNP(PG->getFirstGenotype()->DiplotypeArray[0][pos], PG->getFirstGenotype()->DiplotypeArray[1][pos])) return false; 
if (!Diplotype::isANonMissingSNP(PG->getSecondGenotype()->DiplotypeArray[0][pos], PG->getSecondGenotype()->DiplotypeArray[1][pos])) return false; 

if  (Diplotype::isHeterozygous(genotype->DiplotypeArray[0][pos], genotype->DiplotypeArray[1][pos])
	&& Diplotype::isHeterozygous(PG->getFirstGenotype()->DiplotypeArray[0][pos], PG->getFirstGenotype()->DiplotypeArray[1][pos])
	&& Diplotype::isHeterozygous(PG->getSecondGenotype()->DiplotypeArray[0][pos], PG->getSecondGenotype()->DiplotypeArray[1][pos])) return false;

return true;

}
/*___________________________________________________*/

bool Genoma::CanBeInferred (const SNPPos* pos, SNPPos totalPos, AlleleOrderType alleleOrderMode)      
{
// Karnaugh map: 1111/1010/1100/1000  Rows and columns labels: OO, OH, HO, HH
// if is already known, return false
int i;

if (genotype->IsPhaseKnown(pos, totalPos, alleleOrderMode)) return false;

while (i<totalPos)
{
if  (!Diplotype::isANonMissingSNP(genotype->DiplotypeArray[0][pos[i]], genotype->DiplotypeArray[1][pos[i]])) return false;
if (!Diplotype::isANonMissingSNP(PG->getFirstGenotype()->DiplotypeArray[0][pos[i]], PG->getFirstGenotype()->DiplotypeArray[1][pos[i]])) return false; 
if (!Diplotype::isANonMissingSNP(PG->getSecondGenotype()->DiplotypeArray[0][pos[i]], PG->getSecondGenotype()->DiplotypeArray[1][pos[i]])) return false; 


if  (Diplotype::isHeterozygous(genotype->DiplotypeArray[0][pos[i]], genotype->DiplotypeArray[1][pos[i]])
	&& Diplotype::isHeterozygous(PG->getFirstGenotype()->DiplotypeArray[0][pos[i]], PG->getFirstGenotype()->DiplotypeArray[1][pos[i]])
	&& Diplotype::isHeterozygous(PG->getSecondGenotype()->DiplotypeArray[0][pos[i]], PG->getSecondGenotype()->DiplotypeArray[1][pos[i]])) return false;
i++;
}
return true;

}
/*___________________________________________________*/

bool Genoma::CanBeInferred (SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode) 
{
int pos[2];
pos[0]=SNP1;
pos[1]=SNP2;
return this->CanBeInferred(pos, 2, alleleOrderMode);
}



/*___________________________________________________*/

void Genoma::setLeftRight (SNPPos SNP, allele & left, allele & right)      
// it changes order of alleles in diplotype Dip by considering the other family member
{
if (Diplotype::isHomozygous(PG->getFirstGenotype()->DiplotypeArray[0][SNP], PG->getFirstGenotype()->DiplotypeArray[1][SNP]))
{
if (genotype->DiplotypeArray[0][SNP]!=PG->getFirstGenotype()->DiplotypeArray[0][SNP])
 Diplotype::changeAlleles(left, right);
}
else
if (Diplotype::isHomozygous(PG->getSecondGenotype()->DiplotypeArray[0][SNP], PG->getSecondGenotype()->DiplotypeArray[1][SNP]) && genotype->DiplotypeArray[1][SNP]!=PG->getSecondGenotype()->DiplotypeArray[0][SNP])
 Diplotype::changeAlleles(left, right);
}
/*___________________________________________________*/

bool Genoma::MustBeChanged (SNPPos SNP)      
{
if (Diplotype::isHomozygous(PG->getFirstGenotype()->DiplotypeArray[0][SNP], PG->getFirstGenotype()->DiplotypeArray[1][SNP]))
{
if (genotype->DiplotypeArray[0][SNP]!=PG->getFirstGenotype()->DiplotypeArray[0][SNP])
 return true;
}
else
if (Diplotype::isHomozygous(PG->getSecondGenotype()->DiplotypeArray[0][SNP], PG->getSecondGenotype()->DiplotypeArray[1][SNP]) && genotype->DiplotypeArray[1][SNP]!=PG->getSecondGenotype()->DiplotypeArray[0][SNP])
 return true;

return false;
}
/*___________________________________________________*/

SNPPos Genoma::getKnownHaps (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, Transmission transmission)      
{
// it returns the number of haplotypes in the sample with allele1 at SNP1 and allele2 at SNP2
int result=0;
if (isKnown(SNP1,SNP2)) 
{
 setLeftRight(SNP1, genotype->DiplotypeArray[0][SNP1], genotype->DiplotypeArray[1][SNP1]);
 setLeftRight(SNP2, genotype->DiplotypeArray[0][SNP2], genotype->DiplotypeArray[1][SNP2]);
bool left=true;
if ((ic==father || ic==mother)  || (ic==offspring && transmission==ut))
for (int i=0;i<2;i++)
if (transmission==ut || (i==0 && transmission==t) || (i==1 && transmission==u))
{
if (i==1) left=false;
if ((left && allele1==genotype->DiplotypeArray[0][SNP1] && allele2==genotype->DiplotypeArray[0][SNP2]) ||
(!left && allele1==genotype->DiplotypeArray[1][SNP1] && allele2==genotype->DiplotypeArray[1][SNP2]))
 result++;
}
}
return result;
}
/*___________________________________________________*/

bool Genoma::isKnown (SNPPos SNP1, SNPPos SNP2)      
{
return !genotype->IsHeterozygousHeterozygous(SNP1, SNP2);
}
/*___________________________________________________*/

SNPPos Genoma::GetInferredHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission, AlleleOrderType alleleOrderMode)      
{
int result=0;
if (CanBeInferred(SNP1,SNP2, alleleOrderMode)) 
{
 setLeftRight(SNP1, genotype->DiplotypeArray[0][SNP1], genotype->DiplotypeArray[1][SNP1]);
 setLeftRight(SNP2, genotype->DiplotypeArray[0][SNP2], genotype->DiplotypeArray[1][SNP2]);
bool left=true;
if (transmission==u) left=false; // right;
if ((ic==father || ic==mother) && transmission!=ut)
{
if ((left && allele1==genotype->DiplotypeArray[0][SNP1] && allele2==genotype->DiplotypeArray[0][SNP2]) ||
(!left && allele1==genotype->DiplotypeArray[1][SNP1] && allele2==genotype->DiplotypeArray[1][SNP2]))
 result= 1;
}
else if (ic==offspring && transmission!=ut) result=0;
else // transmission==ut
{
if ((allele1==genotype->DiplotypeArray[0][SNP1] && allele2==genotype->DiplotypeArray[1][SNP2]) ||
(allele1==genotype->DiplotypeArray[1][SNP1] && allele2==genotype->DiplotypeArray[0][SNP2]))
 result= 1;
}
}
return result;
}
/*___________________________________________________*/

SNPPos Genoma::GetPartiallySolved (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele **allAlleles, bool IsPartiallySolved)      
{
allele childAllele1=PG->getFirstGenotype()->DiplotypeArray[0][SNP1];
allele childAllele2=PG->getFirstGenotype()->DiplotypeArray[0][SNP2];
if (CanBePartiallySolved (SNP1, SNP2, IsPartiallySolved))
if (ic==father)
{
if ((allele1==childAllele1 && allele2==childAllele2) || (allele1!=childAllele1 && allele2!=childAllele2))
return 1;
}
else
{
if (ic==mother)
if ((allele1==childAllele1 && allele2!=childAllele2) || (allele1!=childAllele1 && allele2==childAllele2))
return 1;
}
return 0;
}

/*___________________________________________________*/

bool Genoma::CanBePartiallySolved (const SNPPos* pos, SNPPos totalPos, bool IsPartiallySolved) 
{
if (totalPos==2)
return CanBePartiallySolved(pos[0], pos[1], IsPartiallySolved);
else return false;
}
/*___________________________________________________*/

bool Genoma::CanBePartiallySolved (SNPPos SNP1, SNPPos SNP2, bool IsPartiallySolved)      
{
// it can be partially solved if both parents are double heterozygous and the child is heterohomo
return (ic==father || ic==mother) 
&& IsPartiallySolved 
&& genotype->IsHeterozygousHeterozygous(SNP1, SNP2) 
&& PG->getSecondGenotype()->IsHeterozygousHeterozygous(SNP1, SNP2) // couple
&& (genotype->DiplotypeArray[0][SNP1]==PG->getSecondGenotype()->DiplotypeArray[0][SNP1])
&& (genotype->DiplotypeArray[1][SNP1]==PG->getSecondGenotype()->DiplotypeArray[1][SNP1])
&& (genotype->DiplotypeArray[0][SNP2]==PG->getSecondGenotype()->DiplotypeArray[0][SNP2])
&& (genotype->DiplotypeArray[1][SNP2]==PG->getSecondGenotype()->DiplotypeArray[1][SNP2])
&& PG->getFirstGenotype()->IsHomozygousHeterozygous(SNP1, SNP2) // child
&& (((genotype->DiplotypeArray[0][SNP1]==PG->getFirstGenotype()->DiplotypeArray[0][SNP1])
&& (genotype->DiplotypeArray[1][SNP1]==PG->getFirstGenotype()->DiplotypeArray[1][SNP1]))
|| ((genotype->DiplotypeArray[0][SNP2]==PG->getFirstGenotype()->DiplotypeArray[0][SNP2])
&& (genotype->DiplotypeArray[1][SNP2]==PG->getFirstGenotype()->DiplotypeArray[1][SNP2])));
}
/*____________________________________________________________ */

PairGenotype* Genoma::getPairGenotype()
{
return PG;
}

/*____________________________________________________________ */

void Genoma::changeTransmittedAlleles(SNPPos SNP, bool father)
{
	// for those heterozygous positions, allele transmitted is the current non transmitted
allele Left, Right;
Genotype* genotypeRelative;
if (father) genotypeRelative=PG->getFirstGenotype(); else genotypeRelative=PG->getSecondGenotype(); 

Left=genotypeRelative->DiplotypeArray[0][SNP];
Right=genotypeRelative->DiplotypeArray[1][SNP];

if (father) genotype->SetAlleles(Right, genotype->DiplotypeArray[1][SNP], SNP);
else genotype->SetAlleles(genotype->DiplotypeArray[0][SNP], Right, SNP);
genotypeRelative->SetAlleles(Right, Left, SNP);
}

/*____________________________________________________________ */

void Genoma::ChangeAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 genotype->ChangeAlleles(SNP);

}
/*____________________________________________________________ */

void Genoma::markAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 genotype->markAlleles(SNP);

}
/*__________________________________________________________*/
/*
Diplotype* Genoma::getDiplotype(SNPPos SNP)
{
return genotype->getDiplotype(SNP);
}
/*__________________________________________________________*/

};  // End of Namespace

#endif

/* End of file: Genoma.h */




