/* File: Genoma.h */


#ifndef __Genoma_h__
#define __Genoma_h__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genoma for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/

//class Diplotype;

class Trio;

class TrioGenotype;
 
class Genoma {


protected:

    /** @name Implementation of class Genoma
        @memo Private part.
    */
      /**
      @memo A pointer to the vector of left alleles
      @doc  Each left allele contains a value {0,1,2,3,4}
      */

	//  typedef vector<Diplotype> *DL;
	  
//	  vector<Diplotype> * DiplotypeList;

         
IndCategory ic;
PairGenotype *PG;
Genotype* genotype;

//char*line;
      /**
      @memo Declaration of type gender
      @doc It can have one of {1,2} values. 1 for male, 2 for female.
      */

	  
   /** @name Number of individuals (sample size)
        @doc Is the total number of individuals in the sample.
    */
   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

      void CheckRangeSNP(SNPPos SNP);

      void OrderSNPs ();

      void PrintCompleteGenoma();




		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on Genoma 
        @memo Operations on a Genoma 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
		  Genoma();


      /**
         @memo Copy constructor
         @param destino: Genoma where will be copy
         @param origen: Genoma to copy
         @doc
           Make a copy of Genoma
           Time complexity in time O(1).
        */
		  Genoma (Genoma* Source);
	
		  Genoma (Trio * trio, IndCategory i);

		  Genoma (Genotype * G, Phenotype  P, TrioGenotype & TrioG);


		        /**
         @memo Copy constructor
         @param destino: Genoma where will be copy
         @param origen: Genoma to copy
         @doc
           Make a copy of Genoma
           Time complexity in time O(1).
        */
	
		  Genoma (Genoma& Source, unsigned int *Sampling);



      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */


      ~Genoma ();

    
	  SNPPos GetUnsolvedHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele ** allAlleles, bool IsPartiallySolved=false, Transmission transmission=ut);    

   SNPPos GetHaps (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele** allAlleles, bool IsPartiallySolved=false, Transmission transmission=ut);        

	  //bool erred (SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode);      

	  bool CanBePartiallySolved (SNPPos SNP1, SNPPos SNP2, bool IsPartiallySolved);      

   bool CanBePartiallySolved (const SNPPos* pos, SNPPos totalPos, bool IsPartiallySolved);      


	  void setLeftRight (SNPPos SNP, allele& left, allele & right);      

  //double getLengthMeasure (SNPPos position, SNPPos position2, Genoma* genoma2, allele** allAlleles, int* totalAlleles,  AmbiguousArray* tableGenotypes, MultidimensionalEmptyTable<int>*tableHaplotypes, MultidimensionalTable<double>* hapFreqs=NULL);      

	//double getLengthMeasure (const SNPPos* pos, SNPPos totalPos, Genoma* genoma2, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, MultidimensionalEmptyTable<int>*tableHaplotypes, MultidimensionalTable<double>* hapFreqs=NULL); 

	  SNPPos GetInferredHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, Transmission transmission=ut, AlleleOrderType alleleOrderMode=MajorFirst);

   SNPPos getKnownHaps (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele ** allAlleles, Transmission transmission=ut);   

	  SNPPos GetPartiallySolved (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele ** allAlleles, bool IsPartiallySolved);      

	  Genoma (const Genotype & G, const Phenotype & P);

	  PairGenotype* getPairGenotype();

	  Genotype* getGenotype();

//	  SNPPos IsMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype & D1, Diplotype & D2);      

	  bool CanBeSolved (SNPPos SNP1, SNPPos SNP2, allele* MajorAllele, bool IsPartiallySolved);  

   bool isKnown (SNPPos SNP1, SNPPos SNP2);      
  
	//  bool CanBeInferred (SNPPos SNP, allele MajorAllele, AlleleOrderType alleleOrderMode);  

	bool CanBeInferred (const SNPPos* pos, SNPPos totalPos, AlleleOrderType alleleOrderMode);      

	bool CanBeInferred (SNPPos pos, AlleleOrderType alleleOrderMode);      

	bool CanBeInferred (SNPPos pos, SNPPos pos2, AlleleOrderType alleleOrderMode);      

	  bool MustBeChanged (SNPPos SNP);      

	  void ChangeAlleles(SNPPos SNP);

	  void markAlleles(SNPPos SNP);

	  //Diplotype* getDiplotype(SNPPos SNP);

	//  GenotypeCode GetGenotypeCode(SNPPos SNP, SNPPos SNP2, allele** allAlleles, AlleleOrderType alleleOrderMode);

	//  char* PrintGenotypeCode(SNPPos SNP, SNPPos SNP2, allele* MajorAllele);

	  IndCategory GetIndCategory() {return ic;};

	  void changeTransmittedAlleles(SNPPos SNP, bool father);

//			bool CanBeInferred (SNPPos SNP, allele MajorAllele);

//longLongList* getHapCountsUsingTrios (const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, Transmission transmission, int phaseMethod, AmbiguousArray* tableGenotypes, MultidimensionalEmptyTable<int>*tableHaplotypes, MultidimensionalTable<double>* hapFreqs); 

//Pair<int*> getHapCountsArrayUsingTrios (const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, Transmission transmission,  MultidimensionalTable<double>* hapFreqs); 

//Pair<int*>* solvePhaseUsingEM (const SNPPos*pos, SNPPos totalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, MultidimensionalEmptyTable<int>*tableHaplotypes, MultidimensionalTable<double>* hapFreqs);

/*
long long int getGenotypeCounts (const SNPPos Pos[], SNPPos TotalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, MultidimensionalEmptyTable<int>*tableHaplotypes); 

int*  getGenotypeCountsArray(const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, MultidimensionalEmptyTable<int>*tableHaplotypes); 

*/
};  // End of class Genoma


};  // End of Namespace

#endif

/* End of file: Genoma.h */




