/* File: GenotypeCounters.h */


#ifndef __GenotypeCounters_cpp__
#define __GenotypeCounters_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



/*____________________________________________________________ */

GenotypeCounters* GenotypeCounters::clone()
{
return new GenotypeCounters((GenotypeCounters&)*this);
} 
/*_________________________________________________________________*/

GenotypeCounters::GenotypeCounters(GenotypeCounters& source)
{
this->includeMissing=source.includeMissing;
this->totalPos=source.totalPos;
this->totalGenotypes=source.totalGenotypes;
this->genomaSample=source.genomaSample;
genotypeCountsMale=NULL;
genotypeCountsFemale=NULL;
//fatherPedigrees=NULL;
//motherPedigrees=NULL;
SNPAbsFreqsMale=NULL;
SNPAbsFreqsFemale=NULL;
genotypeArray=NULL;
pos=NULL;
//if (source.genotypeFreqs!=NULL) genotypeFreqs=new HeteroListPair<long long int, double>(*source.genotypeFreqs);
//if (source.genotypeAbsFreqsTab!=NULL) genotypeAbsFreqsTab=new MultidimensionalTable<double>(*source.genotypeAbsFreqsTab);
if (source.totalPos>0)
{
pos=Initialize(totalPos,0);
for (int i=0; i<totalPos; i++)
pos[i]=source.pos[i];
}
if (source.genotypeCountsMale!=NULL) genotypeCountsMale=new longLongList(*source.genotypeCountsMale);
if (source.genotypeCountsFemale!=NULL) genotypeCountsFemale=new longLongList(*source.genotypeCountsFemale);
//if (source.fatherPedigrees!=NULL) fatherPedigrees=new intList(*source.fatherPedigrees);
//if (source.motherPedigrees!=NULL) motherPedigrees=new intList(*source.motherPedigrees);

if (source.genotypeArray!=NULL) genotypeArray=new GenotypeArray(*source.genotypeArray);
double** sourceSNPAbsFreqs=source.SNPAbsFreqsMale, **SNPAbsFreqs;
for (int gender=0; gender<2; gender++)
{
if (parent==1) {sourceSNPAbsFreqs=source.SNPAbsFreqsFemale;}
if (sourceSNPAbsFreqs!=NULL)
{
if (gender==0) {SNPAbsFreqsMale=new double*[this->totalPos]; SNPAbsFreqs=SNPAbsFreqsMale;} 
else {SNPAbsFreqsFemale=new double*[this->totalPos]; SNPAbsFreqs=SNPAbsFreqsFemale;} 
for (int i=0; i<this->totalPos; i++)
{
 SNPAbsFreqs[i]=new double[genotypeArray->totalAlleles[i]];
 for (int j=0; j<genotypeArray->totalAlleles[i]; j++) SNPAbsFreqs[i][j]=sourceSNPAbsFreqs[i][j];
if (gender==0) SNPAbsFreqsMale[i]=SNPAbsFreqs[i]; 
else SNPAbsFreqsFemale[i]=SNPAbsFreqs[i]; 
}
}
else if (gender==0) SNPAbsFreqsMale=NULL; else SNPAbsFreqsFemale=NULL;
}
}

/*_________________________________________________________________*/

GenotypeCounters::GenotypeCounters(SNPPos Pos[], SNPPos TotalPos,  GenomaSample * samp, int affectation, bool includeMissing) 
{
try
{
genomaSample=samp;
genotypeCountsMale=NULL;
genotypeCountsFemale=NULL;
//fatherPedigrees=NULL;
//motherPedigrees=NULL;
genotypeArray=NULL;
SNPAbsFreqsMale=NULL;
SNPAbsFreqsFemale=NULL;
pos=NULL;
//cout << "allele order mode:" << samp->genotypeSample->AlleleOrderMode;
//exit(0);
set (Pos, TotalPos, samp, affectation, includeMissing);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::GenotypeCounters(SNPPos Pos[]..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::GenotypeCounters(SNPPos Pos[]..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from GenotypeCounters::GenotypeCounters(SNPPos Pos[]..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::GenotypeCounters(SNPPos Pos[]..."); throw;};
}

/*_________________________________________________________________*/

GenotypeCounters::GenotypeCounters()
{
genotypeCountsMale=NULL;
genotypeCountsFemale=NULL;
//fatherPedigrees=NULL;
//motherPedigrees=NULL;
genotypeArray=NULL;
SNPAbsFreqsMale=NULL;
SNPAbsFreqsFemale=NULL;
includeMissing=false;
totalPos=0;
pos=NULL;
genomaSample=NULL;


}
/*_______________________________________________________________*/

 void GenotypeCounters::empty()
{
zap(genotypeCountsMale);
zap(genotypeCountsFemale);
//zap(fatherPedigrees);
//zap(motherPedigrees);
zap(genotypeArray);

for (int i=0; i<totalPos; i++)
{
if (SNPAbsFreqsMale!=NULL) zaparr(SNPAbsFreqsMale[i]);
if (SNPAbsFreqsFemale!=NULL) zaparr(SNPAbsFreqsFemale[i]);
}

zaparr(SNPAbsFreqsMale);
zaparr(SNPAbsFreqsFemale);
zaparr(pos);
}

/*_______________________________________________________________*/

MultidimensionalTable<double>*  GenotypeCounters::getGenotypeAbsFreqs(gender gend) //, BayesType Bayes, float distance, float alpha) 
{
try
{
longLongList* list;
intList* dimList=new intList();
long long int size=1;
for (int i=0; i<this->totalPos; i++)
{
size=size*getTotalGenotypes(genotypeArray->totalAlleles[i]);
 dimList->insertElement(getTotalGenotypes(genotypeArray->totalAlleles[i]));
}
#ifdef _CMP_MAC_
if (size>INT_MAX)
#else
if (size>MAXINT)
#endif	
{
cout <<"Try a shorter windows\n";
throw NoMemory("getGenotypeAbsFreqs()");
}
double freq;
MultidimensionalTable<double> *result=new MultidimensionalTable<double>(dimList);
zap(dimList);
if (gend==unknown) throw BadFormat("MultidimensionalTable<double>*  GenotypeCounters::getGenotypeAbsFreqs(gender gend)");
for (int i=0; i<2; i++)
if ((gend==male && i==0) || (gend==female && i==1) || gend==everyGender)
{
if (i==0) list=genotypeCountsMale; else list=genotypeCountsFemale; 
for (longLongList::iterator it=list->begin(); it<list->end(); it++)
if (list->getElement(it)!=-1)//missing when includeMissing=false are disregarded; homozygous when tdt=true are disregarded
{
//freq=AddBayesGen(1, Bayes, distance, alpha, totalGenotypes);
result->addValue(list->getElement(it), 1);
}
}
return result;
}
catch (BasicException & e) {e.addMessage("\n called from GenotypeCounters::getGenotypeAbsFreqs(gender gend)"); throw; }
}


/*_________________________________________________________________*/

 void GenotypeCounters::set(SNPPos Pos[], SNPPos totalPos, GenomaSample * samp, int affectation, bool includeMissing)  
{
try
{
this->totalPos=totalPos;
this->pos=NULL;
if (totalPos>0)
{
this->pos=Initialize(totalPos,0);
for (int i=0; i<totalPos; i++)
this->pos[i]=Pos[i];
}
else
{
this->totalPos=samp->genotypeSample->GetTotalSNPs();
this->pos=Initialize(this->totalPos,0);
for (int i=0; i<this->totalPos; i++)
this->pos[i]=i;
}
this->includeMissing=includeMissing;
set(samp, affectation);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::set(SNPPos Pos[]..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::set(SNPPos Pos[]..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::set(SNPPos Pos[]..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from GenotypeCounters::set(SNPPos Pos[]..."); throw;};
}
/*_______________________________________________________________*/

 void GenotypeCounters::setGenotypeTableDimensions(GenomaSample * samp)
{
try
{
intList* dimList=new intList();
for (int i=0; i<totalPos; i++)
{
//cout <<"pos at " << i << ": " << pos[i] << " ";
//cout <<"total alleles:" << samp->genotypeSample->totalAlleles[pos[i]] <<"\n";
 dimList->insertElement(getTotalGenotypes(samp->genotypeSample->totalAlleles[pos[i]]));
}
//cout <<"dimList:" << *dimList <<"\n";
//if (samp!=NULL) if (samp->genotypeSample!=NULL) cout <<"NONULL\n";
genotypeArray=new GenotypeArray(dimList, pos[0], samp->genotypeSample->totalAlleles, samp->genotypeSample->allAlleles);
zap(dimList);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::setGenotypeTableDimensions(GenomaSample* sample..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::setGenotypeTableDimensions(GenomaSample* sample..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::setGenotypeTableDimensions(GenomaSample* sample..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from GenotypeCounters::setGenotypeTableDimensions(GenomaSample* sample..."); throw;};
}
/*_______________________________________________________________*/
/*
 void GenotypeCounters::setGenotypeTable()
{
longLongList * genotypeCounts;
for (int i=0; i<2; i++)
{
if (i==0) genotypeCounts=genotypeCountsFather; else genotypeCounts=genotypeCountsMother;
for (longLongList::iterator it=genotypeCounts->begin(); it!=genotypeCounts->end(); it++)
 genotypeArray->addValue(genotypeCounts->getElement(it), 1);
}
}
/*_______________________________________________________________*/

 longLongList*GenotypeCounters::permuteInGender(bool male)
{
// It returns a new list of genotype codes for each individual randomly changing between left/right allele
long int value, value2;
int left;
longLongList* result=new longLongList(), *temp;
if (male) 
temp=genotypeCountsMale;
else temp=genotypeCountsFemale;
for (longLongList::iterator it=temp->begin(); it<temp->end(); it++)
{
value=temp->getElement(it);
left=ranbinom(1, 0.5);
if (left)
{
result->insertElement(value);
}
else
{
value2=genotypeArray->changePhase(value);
result->insertElement(value2);
//cout << "\npermutation: orig:"  << value << "new:" << value2;
}
}
return result;
}

/*___________________________________________________________________________________________________*/

 void GenotypeCounters::setSNPFreqs()  
{
try
{
SNPAbsFreqsMale=new double*[totalPos];
SNPAbsFreqsFemale=new double*[totalPos];
int al1, al2, al3, al4;
double totalSNP=0, freq=0;
for (int i=0; i<totalPos; i++)
{
 SNPAbsFreqsMale[i]=Initialize(genotypeArray->totalAlleles[i], 0.0);
 SNPAbsFreqsFemale[i]=Initialize(genotypeArray->totalAlleles[i], 0.0);
}

int i=0, *position=NULL, *position2=NULL;
if (genotypeCountsMale==NULL)
throw NullValue("GenotypeCounters::setSNPFreqs()");

if (genotypeCountsFemale==NULL)
throw NullValue("GenotypeCounters::setSNPFreqs()");
//if (genotypeCountsMale->size() != genotypeCountsFemale->size())
//throw OutOfBounds(genotypeCountsMale->size(), genotypeCountsFemale->size(), "GenotypeCounters::setSNPFreqs()");
for (int i=0; i<genotypeCountsMale->size(); i++)
if (genotypeCountsMale->getElement(i)>=0)
{
position=genotypeArray->getPositions(genotypeCountsMale->getElement(i));
for (int j=0; j<totalPos; j++)
{
 al1=getAllelePos(position[j], j, true, genotypeArray);
 al2=getAllelePos(position[j], j, false, genotypeArray);
 SNPAbsFreqsMale[j][al1]=SNPAbsFreqsMale[j][al1]+1;
 SNPAbsFreqsMale[j][al2]=SNPAbsFreqsMale[j][al2]+1;
}
zaparr(position);
}
for (int i=0; i<genotypeCountsFemale->size(); i++)
if (genotypeCountsFemale->getElement(i)>=0)
{
position2=genotypeArray->getPositions(genotypeCountsFemale->getElement(i));
for (int j=0; j<totalPos; j++)
{
 al3=getAllelePos(position2[j], j, true, genotypeArray);
 al4=getAllelePos(position2[j], j, false, genotypeArray);
 SNPAbsFreqsFemale[j][al3]=SNPAbsFreqsFemale[j][al3]+1;
 SNPAbsFreqsFemale[j][al4]=SNPAbsFreqsFemale[j][al4]+1;
}
zaparr(position2);
}
}
catch (ORLLI & e) {e.addMessage("\n called from GenotypeCounters::setSNPFreqs()"); throw; }
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::setSNPFreqs()"); throw;}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::setSNPFreqs"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::setSNPFreqs"); throw;}
}
/*_______________________________________________________________*/
/*
 longLongList*GenotypeCounters::updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother)
{
// It updates the permutations in the children
longLongList* result=new longLongList();
long int valueMother, valueFather, valueChild;
int alMother, alFather, *positionsFather, *positionsMother, *positionsChild;
for (int cont=0; cont<genotypeCountsFather->size(); cont++)
{
valueMother=genotypeCountsMother->getElement(cont);
valueFather=genotypeCountsFather->getElement(cont);
positionsFather=genotypeArray->getPositions(valueFather);
positionsMother=genotypeArray->getPositions(valueMother);
positionsChild=genotypeArray->getPositions(valueChild);
for (int i=0; i<totalPos; i++)
if (genotypeArray->isAKnownPosition (positionsFather[i], i)) 
if (genotypeArray->isAPositionWithDifferentValues(positionsFather[i], i) || genotypeArray->isAPositionWithDifferentValues(positionsMother[i], i)) 
{
alFather=genotypeArray->getKnownValue (positionsFather[i], i, true);
alMother=genotypeArray->getKnownValue (positionsMother[i], i, true);
positionsChild[i]=genotypeArray->getAmbiguousPos (alFather, alMother, i);
}
valueChild=genotypeArray->getPos(positionsChild);
zaparr(positionsFather);
zaparr(positionsMother);
zaparr(positionsChild);
result->insertElement(valueChild);
}
return result;
}
/*_______________________________________________________________*/

GenotypeCounters*GenotypeCounters::getPermutation()
{
longLongList
* tempGenotypeCountsMale=permuteInGender(true),
* tempGenotypeCountsFemale=permuteInGender(false);


GenotypeCounters* result=clone();
zap(result->genotypeCountsMale);
zap(result->genotypeCountsFemale);
result->genotypeCountsMale=tempGenotypeCountsMale;
result->genotypeCountsFemale=tempGenotypeCountsFemale;
return result;
}
/*_______________________________________________________________*/

 void GenotypeCounters::setTotalGenotypes()
{
try
{
longLongList* l;
totalGenotypes=0;
for (int gend=0; gend<2; gend++)
{
if (gend==0) l=genotypeCountsMale; else l=genotypeCountsFemale;
for (longLongList::iterator it=l->begin(); it<l->end(); it++)
if (l->getElement(it)>=0) totalGenotypes++;
}
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::setTotalGenotypes"); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::setTotalGenotypes()"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::setTotalGenotypes"); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from 3 GenotypeCounters::ssetTotalGenotypes"); throw;};
}
/*_________________________________________________________________*/

void GenotypeCounters::set(GenomaSample* sample, int affectation)  
{
try
{
setGenotypeTableDimensions(sample);
setCounters(sample, affectation);
setTotalGenotypes();
setSNPFreqs();
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::set(GenomaSample* sample..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::set(GenomaSample* sample..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::set(GenomaSample* sample..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from GenotypeCounters::set(GenomaSample* sample..."); throw;};
}



/*____________________________________________________________ */

void GenotypeCounters::setCounters (GenomaSample* sample, int affectation)  
{
try
{
genotypeCountsMale=sample->getGenotypeCounts(pos, totalPos, male, affectation, genotypeArray, false, includeMissing);
genotypeCountsFemale=sample->getGenotypeCounts(pos, totalPos, female, affectation, genotypeArray, false, includeMissing);
//fatherPedigrees=sample->getPedigreeID(father);
//motherPedigrees=sample->getPedigreeID(mother);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from GenotypeCounters::setCounters"); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from GenotypeCounters::setCounters"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from GenotypeCounters::setCounters"); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from GenotypeCounters::setCounters"); throw;};
//cout <<"mother gens:\n" << *genotypeCountsMother;
}



};  // End of Namespace

#endif

/* End of file: GenotypeCounters.h */




