/* File: Haplotype.cpp */


#ifndef __Haplotype_cpp__
#define __Haplotype_cpp__

//using namespace UTILS;


namespace BIOS {



void Haplotype::checkRangeSNP(SNPPos SNP)
{
if (SNP<0 || SNP>=size()) throw OutOfBounds(SNP, size(), "Haplotype::CheckRangeSNP(SNPPos SNP)");
}

/*_____________________________________________________*/

void Haplotype::checkBase(SNPPos SNP)
{
if (alleleArray==NULL) throw NullValue("Haplotype::checkBase(SNPPos SNP)");
if ((int)alleleArray[SNP]<1 || (int)alleleArray[SNP]>5) throw NonSNP((int)alleleArray[SNP], "Haplotype::checkBase(SNPPos SNP)");
}

/*_____________________________________________________*/

Haplotype::Haplotype(){alleleArray=NULL; totalSNPs=0;}
	
/*
Haplotype::Haplotype(base* source, SNPPos TotalSNPs)
{
setHaplotypeArray(source, TotalSNPs);
};
*/

/*_____________________________________________________*/

Haplotype::Haplotype(SNPPos totalPos)
{
alleleArray=NULL;
totalSNPs=totalPos;
if (totalPos>0) alleleArray=Initialize(totalPos, (base)5);
}

/*_____________________________________________________*/

Haplotype::Haplotype(base * alleleArray, SNPPos size)
{
setHaplotypeArray (alleleArray, size);
}

/*_____________________________________________________*/


Haplotype::Haplotype(const Haplotype & source)
{
totalSNPs=source.totalSNPs;
alleleArray=NULL;
setHaplotypeArray(source.alleleArray, totalSNPs);
}
/*_____________________________________________________*/

Haplotype::~Haplotype ()
{
zaparr(alleleArray);
}
/*
Haplotype& Haplotype::operator=(const Haplotype& g)
{
return *this;
}
*/
/*_____________________________________________________*/

int Haplotype::size()
{
return totalSNPs;
}

/*_____________________________________________________*/

double Haplotype::getDistance(Haplotype* other, int position, bool toLeft)
{
  double result;
  
  if ( position < 0 || position > size()-1 )
	 throw OutOfBounds (position, this->size(), "Haplotype::getDistance(...) ");
  
  if ( toLeft ){
	result=position+1;
	 for (int i=position; i>=0; i--)
	 {
		if (alleleArray[i]!=other->alleleArray[i]) return result;
		result--;
	 }	
  }
  else{
	 result=size()-position;
	 for (int i=position; i<size(); i++)
	 {
		if (alleleArray[i]!=other->alleleArray[i]) return result;
		result--;
	 }
  }
  
  return result;
}

/*_____________________________________________________*/



bool Haplotype::operator==(Haplotype & g)
{
if (g.alleleArray==NULL || this->alleleArray==NULL) 
throw NullValue("bool Haplotype::operator==(Haplotype & g)");
if (g.size()!=size()) return false;
for (int i=0; i<size();i++)
if (g.alleleArray[i]!=this->alleleArray[i]) return false;
return true;
};
;
/*_____________________________________________________*/

    
bool Haplotype::operator!=(Haplotype & g)
{
return !(g==*this);
}

/*_____________________________________________________*/




base* Haplotype::getHaplotypeArray ()
{
return alleleArray;
}

base& Haplotype::operator[] (int position)
{
return alleleArray[position];
}

/*_____________________________________________________*/



bool Haplotype::isMissing(SNPPos position)
{
if (alleleArray[position]==5) return true; else return false;
}

/*_____________________________________________________*/



bool Haplotype::hasAMissingPosition()
{
for (int i=0; i<size(); i++)
if (isMissing(i)) return true; 
return false;
}


/*_____________________________________________________*/

	  
void Haplotype::setHaplotypeArray (base *array, SNPPos totalSNPs)
{
this->totalSNPs=totalSNPs;
this->alleleArray=NULL;
if (totalSNPs>0) alleleArray=new base[totalSNPs];
for (int i=0; i<totalSNPs;i++)
{
this->alleleArray[i]=array[i];
checkBase(i);
}
}

/*_____________________________________________________*/


void Haplotype::setAllele(base b, SNPPos SNP)
{
checkRangeSNP(SNP);
alleleArray[SNP]=b;
checkBase(SNP);
}

/*_____________________________________________________*/



base Haplotype::getAllele(SNPPos SNP)
{
return alleleArray[SNP];
}

/*_____________________________________________________*/


Haplotype* Haplotype::fromString(string s)
{
Haplotype* result=new Haplotype(s.length());
for (int i=0; i<s.length();i++)
 result->setAllele((base)(ConvertAllele(tos(s[i]).c_str())), i);
 return result;
//throw NonImplemented("Haplotype::fromString(string s)");
}
/*_____________________________________________________*/

	  
Haplotype* Haplotype::filter (int *positions, int length)
{
Haplotype* result=new Haplotype(length);
for (int i=0; i<length;i++)
{
if (positions[i]<0 || positions[i]>=size())
 throw OutOfBounds(positions[i], size(), "Haplotype::filter (int *positions, int length)");
result->alleleArray[i]=this->alleleArray[positions[i]];
}
return result;
}
/*_____________________________________________________*/


		bool  Haplotype::operator>(const Haplotype & ge){cout <<"Not implemented yet"; exit(0);};;
/*_____________________________________________________*/


		bool  Haplotype::operator<(const Haplotype & ge){cout <<"Not implemented yet"; exit(0);};;

/*_____________________________________________________*/

void Haplotype::print()
{
	cout << *this <<endl;
}


};  // End of Namespace

#endif

/* End of file: Haplotype.h */




