/* File: HaplotypesForEachIndividual.h */

#ifndef __HaplotypesForEachIndividual_h__
#define __HaplotypesForEachIndividual_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo HaplotypeForEachIndividual 
	@doc
    
 
        @author Maria M. Abad Grau
	@version 1.0
*/


	class HaplotypesForEachIndividual
{
public:
char outputSeparator;
bool delimiters, printTransmitted, printUntransmitted;
// -1 in a hap means the genotype was missing
// -2 in a hap means is unphased
long long int leftHaplotype;
long long int rightHaplotype;





void check(){if ((leftHaplotype<0 && leftHaplotype!=rightHaplotype) || (rightHaplotype<0 && leftHaplotype!=rightHaplotype)) throw OutOfRange<int>(leftHaplotype, "HaplotypesForEachIndividual.check()");};
bool isKnown() {this->check(); return leftHaplotype>=0 && rightHaplotype>=0;}
HaplotypesForEachIndividual(){outputSeparator='\n';delimiters=false; printTransmitted=true; printUntransmitted=true;}
HaplotypesForEachIndividual(long long int leftHaplotype, long long int rightHaplotype, int indCount, char outputSeparator='\n', bool delimiters=false, bool printTransmitted=true, bool  printUntransitted=true)
{
this->leftHaplotype=leftHaplotype; this->rightHaplotype=rightHaplotype; this->outputSeparator=outputSeparator; this->delimiters=delimiters; this->printTransmitted=printTransmitted; this->printUntransmitted=printUntransmitted;
};
~HaplotypesForEachIndividual(){};
};
	
/*______________________________________________________*/

ostream& operator<<(ostream& out, HaplotypesForEachIndividual& pm)
       {
   out << pm.leftHaplotype << pm.outputSeparator << pm.rightHaplotype << pm.outputSeparator;

return out;
};


typedef Container<vector<HaplotypesForEachIndividual*>, HaplotypesForEachIndividual*>  HaplotypesForEachIndividualList;
/*______________________________________________________*/

   ostream& operator<<(ostream& out, HaplotypesForEachIndividualList& lista)
  {
 out <<lista.leftDelimiter;
    HaplotypesForEachIndividualList::iterator p=lista.getFirst();
 while (p!=lista.end())
    {
         out << *p;
         p=lista.getNext(p); 
        if (p!=lista.end()) out <<lista.outputSeparator; 
else 
{
out <<lista.rightDelimiter;
}
    }
     out <<"\n";
 
    return out;
  }




};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




