/* File: ImportFormat.h */


#ifndef __ImportFormat_cpp__
#define __ImportFormat_cpp__









namespace BIOS {

/*____________________________________________________________ */

void ImportFromPHASE (char *filename, char* filename2, unsigned int size, SNPPos TotalSNPs)
{
unsigned int i2;
cout <<"Importing from PHASE file " << filename << "\n";
int sizeS=8*TotalSNPs+200;
InputFile.open (filename, ifstream::in);
if (!InputFile)
	throw ErrorFile(filename, "ImportFromPHASE");
	char *genotypebuf, *cad, *cad2, *cad3;
    if ((genotypebuf=new char[sizeS])==NULL)
     throw NoMemory();
	if ((cad2=new char[sizeS])==NULL)
     throw NoMemory();
	if ((cad3=new char[sizeS])==NULL)
     throw NoMemory();
	 bool found=false;
	 cout <<"totalSNPS:" << TotalSNPs <<"\n";
	do
	{
		InputFile.getline (genotypebuf, sizeS);
	cad=strtok (genotypebuf," \t");
	if (cad!=NULL)
	if (*cad=='B')
	{
	sscanf (cad, "%s", cad2);
	cad=strtok (NULL," \t");
	sscanf (cad, "%s", cad3);
//if ((strcmp(cad2, "BEGIN\0")==0) && (strcmp (cad3, "BESTPAIRS1\0")==0))
if ((strcmp(cad2, "BEGIN\0")==0) && (strcmp (cad3, "GENOTYPES\0")==0))
		found = true;
	}		
	}
	while ((InputFile.peek()!=EOF) && (!found));
if (!found)
{
	cout << "Incompatible format for PHASE output";
	exit(0);
}
OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename2, "'ImportFromPhase");
unsigned int alle;
unsigned short int *typ;
intList::iterator pL, pR;
if ((typ=new unsigned short int[TotalSNPs])==NULL)
 throw NoMemory();
intList* leftHap, *rightHap;
for (unsigned int i=0;i<size;i++)
{
        leftHap=new intList();
	rightHap=new intList();
	InputFile.getline (genotypebuf,8*TotalSNPs, '\n');
	for (unsigned short int side=0;side<2;side++)
	{
	InputFile.getline (genotypebuf, sizeS, '\n');
	for (i2=0; i2<TotalSNPs; i2++)
	{
	if (i2==0)
     cad = strtok (genotypebuf," \t");
    else cad = strtok (NULL," \t");
	if (cad==NULL) cout <<"\nError in SNP " << i2;
	if ((*cad=='(') || (*cad==')') || (*cad=='[') || (*cad==']'))
		cad=cad+1;

	alle=atoi(cad);
        if (side==0) leftHap->insertElement(alle); else rightHap->insertElement(alle);
	} // for each SNP

	}

    OutputFile << i << " " << i << " 1 0 0 0 " << i;	//idFam, id, sex,affectation,father, mather, id2
    pL=leftHap->getFirst();
    pR=rightHap->getFirst();
    while (pL!=leftHap->end())
    {	
     OutputFile << " " << leftHap->getElement(pL) <<" " << rightHap->getElement(pR);
     pL=leftHap->getNext(pL); pR=rightHap->getNext(pR);
     }
zap(leftHap);
zap(rightHap);
OutputFile <<"\n";
}// end for each size
InputFile.close();
OutputFile.close();
zap(genotypebuf);
zap(cad2);
zap(cad3);
cout<< "\nresult has been recorded in file " << filename2 <<"\n";
}


/*____________________________________________________________ */

void ImportFromSNPHAP (char *filename, char* filename2, unsigned int Size, SNPPos TotalSNPs)
{
unsigned int i2;

cout <<"Importing from SNPHAP\n";




InputFile.open (filename, ifstream::in);
if (!InputFile)
	throw ErrorFile(filename, "ImportFromSNPHAP");

	char *genotypebuf, *cad, *cad2;
    if ((genotypebuf=new char[8*TotalSNPs])==NULL)
     throw NoMemory();


//     unsigned long int pos;
	 bool found=false;

	 InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
	 InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
	 InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
	
char alle;


OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename2, "ImportFromSNPHAP");
unsigned int i=0;

do
{
InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
//cout << genotypebuf <<"\n";
cad = strtok (genotypebuf,"(");
if (atoi(cad)>(i+1))
{
	OutputFile <<"\n";
	OutputFile <<"\n";
	i++;

}
i++;

for (int side=0; side<2; side++)
{
if (side==1)
{
InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
cad = strtok (genotypebuf,"(");
}
 cad = strtok (NULL,")");
 cad = strtok (NULL," ");
 for (i2=0; i2<TotalSNPs; i2++)
 {
  sscanf (cad+i2, "%c", &alle);
  OutputFile << alle; 
 }

 OutputFile <<"\n";
}

} 
while (i<Size);
// end for each individual
//exit(0);

InputFile.close();

delete genotypebuf;

}


/*____________________________________________________________ */

void ImportFromHTYPER (char *filename, char *filename2, unsigned int Size, SNPPos TotalSNPs, FormatType Algorithm)
{

	unsigned int i2;



InputFile.open (filename, ifstream::in);
if (!InputFile || InputFile.peek()==EOF)
	throw ErrorFile(filename, "ImportFromHTYPER");


	char *genotypebuf, *genotypebuf2, *cad;
    if ((genotypebuf=new char[8*TotalSNPs])==NULL)
     throw NoMemory();
    if ((genotypebuf2=new char[8*TotalSNPs])==NULL)
     throw NoMemory();


	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
   	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
   	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
   	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
   	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');

char alle;




OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename2, "ImportFromHTYPER");
int cont=1;

	for (int i=0; i<Size; i++)
	{
	if (Algorithm==PLEM) 
	{
		InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
    	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
		cont=atoi(genotypebuf+strlen(genotypebuf)-1);
//	cout <<cont << "\n";

//cout <<genotypebuf << "\n";
//cout <<"len:" << strlen(genotypebuf) <<"\n";
	}
	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
    for (int side=0; side<2; side++)
{
	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
 	
	 for (i2=0; i2<TotalSNPs; i2++)
	{
 
  alle=genotypebuf[i2];
   OutputFile << alle; 

	}
 OutputFile << "\n"; 	
}	
	if (Algorithm==PLEM) 
	for (int c=1;c<cont;c++)
		{
			    	InputFile.getline (genotypebuf2, 8*TotalSNPs, '\n');
			    	InputFile.getline (genotypebuf2, 8*TotalSNPs, '\n');
			    	InputFile.getline (genotypebuf2, 8*TotalSNPs, '\n');

		}
	
	}
InputFile.close();
OutputFile.close();
delete genotypebuf, genotypebuf2;

}

/*____________________________________________________________ */

void ImportFromMSAMPLE (char *filename, char *filename2, bool fixedNumberOfSNPs, long int nsites) //, const long int InitialPos, const unsigned int Length)
{
SNPPos TotalSNPs;
cout <<"Importing from MSAMPLE at file " << filename << "to file " << filename2 <<"\n";

unsigned int i2, NonRepeated=0;


InputFile.open (filename, ifstream::in);
if (!InputFile)
	throw ErrorFile(filename, "ImportFromMSAMPLE");

	char *genotypebuf, *genotypebuf2, *genotypebuf3, *cad, *cad2, *oldcad;
	bool *ChosenPosition;


// this buffer will contain the positions and afterwards, genotypes
	// positions can require about 10 chars
    if ((genotypebuf3=new char[200])==NULL)
     throw NoMemory();
	if ((cad=new char[10])==NULL)
     throw NoMemory();
	if ((cad2=new char[10])==NULL)
     throw NoMemory();
	if ((oldcad=new char[10])==NULL)
     throw NoMemory();
	 bool found=false;

     InputFile.getline (genotypebuf3, 200, '\n');//command line

	 while  (InputFile.peek()!='s')
     InputFile.getline (genotypebuf3, 200, '\n');
     
	 InputFile.getline (genotypebuf3, 200, '\n');

	cad = strtok (genotypebuf3," \t");
	if (strcmp(cad, "segsites:")!=0)
	{
		cout <<"Error in file format. Line beginning with \"segsites:\" was expected";
		exit(0);
	}
	cad = strtok (NULL," \t");
	TotalSNPs=atoi(cad);
cout <<"totalSNPS: " << TotalSNPs <<"\n";
// this buffer will contain the positions and afterwards, genotypes
	// positions can require about 10 chars
    if ((genotypebuf=new char[100*TotalSNPs])==NULL)
     throw NoMemory();

	if ((genotypebuf2=new char[100*TotalSNPs])==NULL)
     throw NoMemory();


	if ((ChosenPosition=new bool[TotalSNPs])==NULL)
     throw NoMemory();

 for(unsigned int i=0;i<TotalSNPs;i++)
  ChosenPosition[i]=false;


char filename3[128];

changeExtension (filename, filename3, "pou");
//cout <<"here\n";
OutputFile.open (filename3, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename3, "ImportFromMSAMPLE");


InputFile.getline (genotypebuf, 100*TotalSNPs, '\n'); // probs
//exit(0);
//cout <<genotypebuf << "\n";
//cout <<"here2\n";
  cad = strtok (genotypebuf," \t");
 //if (strncmp(cad, "prob:", 5)==0) // the line was prob:
  {
  InputFile.getline (genotypebuf, 100*TotalSNPs, '\n'); // positions
  cad = strtok (genotypebuf," \t");
 }
//cout <<"here3\n";
unsigned int WrittenPositions=0;
for (i2=0; i2<TotalSNPs; i2++)
{   
	cad = strtok (NULL," \t");

//cout <<cad << " ";
//exit(0);


//if ((i2>=InitialPos) && (WrittenPositions<Length))

 if (strcmp(cad, "n")==0) // no pos
  OutputFile << i2 << "\n";//????
 else
 {

	if ((i2==0) || (strcmp(cad, oldcad)!=0))
	{
	OutputFile << round(atof(cad)*nsites) << "\n";
	strcpy(oldcad, cad);
	NonRepeated++;
	WrittenPositions++;
	ChosenPosition[i2]=true;
	}	 
}

}
OutputFile.close();

cout << "Position file " << filename3 << " has been generated\n";

// if (i2>=6)




OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename2, "ImportFromMSAMPLE");

	 unsigned int cont;
	 unsigned int size=0;
	while  (InputFile.peek()!=EOF && InputFile.peek()!=EOF)

	{
    InputFile.getline (genotypebuf, 15+TotalSNPs, '\n');
	InputFile.getline (genotypebuf2, 15+TotalSNPs, '\n');
//cout <<genotypebuf <<"\n";
//cout <<genotypebuf2 <<"\n";
//cout <<"size: " << size <<"\n";
     size++;
     OutputFile << size << " " << size << " 0 0 0 0 " << size << " ";	
	
	 int cont=0;
	 for (i2=0; i2<TotalSNPs; i2++)
   	   if (ChosenPosition[i2]==true)
	 {
	 if (*(genotypebuf+i2)=='0')
	 OutputFile << "1 "; 
	 else
	 OutputFile << "2 "; 
	 if (*(genotypebuf2+i2)=='0')
	 OutputFile << "1"; 
	 else
	 OutputFile << "2"; 
	 //if (cont<(Length-1))
      OutputFile << " "; 
//	 else
	 cont++;
	 }
	  OutputFile << "\n"; 

	}; // end while
InputFile.close();
OutputFile.close();

cout << "File " << filename << " has been saved in dHAP format at " << filename2 <<"\n";
//if (TotalSNPs>NonRepeated)
cout << "Final number of non-repeated SNPs " << WrittenPositions << "\n";

zap (genotypebuf);
//zap(cad2);
//zap(cad);
zap(genotypebuf2);
zap(ChosenPosition);
zap(genotypebuf3);

}
/*____________________________________________________________ */

void ImportFromCOSI (char *filename, char *filename2, SNPPos TotalSNPs) 
{
cout <<"Importing from COSI (Broad Institute) at file " << filename << "\n";
unsigned int i2, NonRepeated=0;


InputFile.open (filename, ifstream::in);
if (!InputFile)
	throw ErrorFile(filename, "ImportFromCOSI");

	char *genotypebuf;
   if ((genotypebuf=new char[10+4*TotalSNPs])==NULL)
     throw NoMemory();

   
OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename2, "ImportFromCOSI");

	 unsigned int cont;
	 unsigned int size=0;
	while  (InputFile.peek()!=EOF)

	{
    InputFile.getline (genotypebuf, 10+4*TotalSNPs, '\n');
     size++;
     OutputFile << size << " " << size << " 1 2 0 0 " << size << " ";	
	
	 int cont=0;
	 for (i2=0; i2<TotalSNPs; i2++)
   		 {
	 if (genotypebuf[i2*4]=='2')
	 OutputFile << "1 "; 
	 else
	 OutputFile << "2 "; 
	 if (genotypebuf[i2*4+2]=='2')
	 OutputFile << "1"; 
	 else
	 OutputFile << "2"; 
     OutputFile << " "; 
	 cont++;
	 }
	  OutputFile << "\n"; 

	}; // end while
InputFile.close();
OutputFile.close();

cout << "File " << filename << " has been saved in dHAP format at " << filename2 <<"\n";
cout <<"There were " << size <<" individuals and " << TotalSNPs <<" SNPs.\n";

zap (genotypebuf);


}
/*____________________________________________________________ */

void ImportFromHAP (char *filename, char *filename2, SNPPos TotalSNPs) 
{
cout <<"Importing from COSI (Broad Institute) at file " << filename << "\n";

unsigned int i2, NonRepeated=0;

InputFile.open (filename, ifstream::in);
if (!InputFile)
	throw ErrorFile(filename, "ImportFromHAP");

	char *genotypebuf, *genotypebuf2;
   if ((genotypebuf=new char[10+TotalSNPs])==NULL)
     throw NoMemory();

	if ((genotypebuf2=new char[10+TotalSNPs])==NULL)
     throw NoMemory();

   
OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile(filename2, "ImportFromHAP");

	 unsigned int cont;
	 unsigned int size=0;
	while  (InputFile.peek()!=EOF)

	{
    InputFile.getline (genotypebuf, 10+TotalSNPs, '\n');
	InputFile.getline (genotypebuf2, 10+TotalSNPs, '\n');

     size++;
     OutputFile << size << " " << size << " 1 2 0 0 " << size;	
	
	 int cont=0;
	 for (i2=0; i2<TotalSNPs; i2++)
   		 {
	 if (genotypebuf[i2]=='2')
	 OutputFile << "1 "; 
	 else
	 OutputFile << "2 "; 
	 if (genotypebuf2[i2]=='2')
	 OutputFile << "1"; 
	 else
	 OutputFile << "2"; 
     OutputFile << " "; 
	 cont++;
	 }
	  OutputFile << "\n"; 

	}; // end while
InputFile.close();
OutputFile.close();
zaparr (genotypebuf);
zaparr(genotypebuf2);
cout << "File " << filename << " has been saved in dHAP format at " << filename2 <<"\n";




}
/*____________________________________________________________ */

void ImportFromML (const char filename[256], char filename2[256], SNPPos TotalSNPs) 
{
cout <<"Importing from MLT at file " << filename << "\n";

stringSample* source=new stringSample(filename);




if (TotalSNPs!=source->getFirstElement()->size())
{
cout <<"Error in ImportFromMLT, TotalSNPs is " << TotalSNPs << " while source file has " << source->getFirstElement()->size() << " SNPs";
}

stringSample::iterator p=source->getFirst();
OutputFile.open (filename2, ifstream::out);
int size=0;
stringList* row=NULL;
while (p!=source->end())
	{
size++;
    row=source->getElement(p);
     OutputFile << size << " " << size << " 0 2 0 0 " << size;	//idFam, id, father, mather, sex (unknown),affectation (unknown), id
	
	
for (int i2=0; i2<TotalSNPs; i2++)
   		 {
if (row->getElement(i2).length()!=1)
{
cout <<"Error in ImportFromML in source file";
end();
}
switch (row->getElement(i2)[0])
{
case '0':  OutputFile << " 1 2"; break;
case '1':  OutputFile << " 1 1"; break;
case '2':  OutputFile << " 2 2"; break;
case '?':  OutputFile << " 0 0"; break;
default: 
cout <<"Error 2 in ImportFromMLT in source file";
end();
}
	
	 }
	  OutputFile << "\n"; 
p=source->getNext(p);
	}; // end while
OutputFile.close();
delete(source);
cout << "File " << filename << " has been saved in Makeped format at " << filename2 <<"\n";
}
/*____________________________________________________________ */

void ImportFromMLC (char *filename, const char *filename2, SNPPos TotalSNPs) 
{
cout <<"Importing from MLC at file " << filename << "\n";

stringSample* source=new stringSample(filename);


if (TotalSNPs!=source->getFirstElement()->size()-1)
{
cout <<"Error in ImportFromMLT, TotalSNPs is " << TotalSNPs << " while source file has " << source->getFirstElement()->size()-1 << " SNPs";
}

stringSample::iterator p=source->getFirst();
OutputFile.open (filename2, ifstream::out);
int size=0;
stringList* row=NULL;
while (p!=source->end())
	{
size++;
    row=source->getElement(p);
     OutputFile << size << " " << size << " 0 0 0 " << row->getLastElement()  << " " << size;	//idFam, id, father, mother, sex (unknown), affectation, id2 
	
	
for (int i2=0; i2<TotalSNPs; i2++)
   		 {
if (row->getElement(i2).length()!=1)
{
cout <<"Error in ImportFromMLC in source file";
end();
}
switch (row->getElement(i2)[0])
{
case '0':  OutputFile << " 1 2"; break;
case '1':  OutputFile << " 1 1"; break;
case '2':  OutputFile << " 2 2"; break;
case '?':  OutputFile << " 0 0"; break;
default: 
cout <<"Error 2 in ImportFromMLC in source file";
end();
}
	
	 }
	  OutputFile << "\n"; 
p=source->getNext(p);
	}; // end while
OutputFile.close();
delete(source);
cout << "File " << filename << " has been saved in Makeped format at " << filename2 <<"\n";
}
/*____________________________________________________________ */

void ImportFromPED (char *filename, char *filename2, SNPPos TotalSNPs) 
{
cout <<"Importing from PED at file " << filename << "\n";


unsigned long int i2, NonRepeated=0;


InputFile.open (filename, ifstream::in);
if (!InputFile)
 throw ErrorFile(filename, "ImportFromPED");

stringList *row;

 char *genotypebuf;


   if ((genotypebuf=new char[100+TotalSNPs*4])==NULL)
     throw NoMemory();



   
OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
 throw ErrorFile(filename2, "ImportFromPED");

string s;
 while  (InputFile.peek()!=EOF)
 {

  InputFile.getline (genotypebuf, 100+TotalSNPs*4, '\n');
s=string(genotypebuf);
row=getStringVector (genotypebuf, " \t,");

 
 for (i2=0; i2<6; i2++)
  OutputFile << row->getElement(i2) << " "; 

  OutputFile << row->getElement(1) << " "; 
 
  int cont=0;
  for (i2=0; i2<(TotalSNPs*2); i2++)
{  
 OutputFile << row->getElement(i2+6);
 if (i2<(TotalSNPs*2-1)) OutputFile << " "; 
 else OutputFile << "\n"; 
}
zap(row);
 }; // end while
InputFile.close();
OutputFile.close();
zaparr (genotypebuf);
cout << "File " << filename << " has been saved in dHAP format at " << filename2 <<"\n";




}
/*____________________________________________________________ */

void ImportFromWTCCC (char *filename, char *filename2) 
{
// Preconditions: it requires a one-column file with positions (.rs) and other with 3 columns:  individual IDs, sex and affectation (.ped)
char filepos[256], fileped[256], fileError[256];
cout <<"Importing from WTCCC at file " << filename << "\n";
changeExtension (filename, filepos, "rs");
changeExtension (filename2, fileError, "err");
stringList *pos=new stringList (filepos);
SNPPos totalSNPs=pos->size();
changeExtension (filename, fileped, "ped");

stringSample* samples=new stringSample (fileped);
cout << "There are " << totalSNPs << " positions and " << samples->size() << "  individuals in the sample\n";
   
OutputFile2.open (fileError, ifstream::out);
OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
 throw ErrorFile(filename2, "ImportFromWTCCC");



TextFile* tf=NULL;
string ind, sex, affectation;
stringList* currentLine=NULL;
IndPos i=0;
string posId;
bool completeRound;
int filePos=0;
bool foundInd;
long int line=0;
bool end;
string allele;
string gene;
map<string, string>* genotypes=NULL;
map<string, string>::iterator it3;
for (stringSample::iterator it=samples->begin(); it<samples->end(); it++)
{
cout << "Ind " << i+1 <<"\n";
ind=samples->getElement(it)->getFirstElement();
sex=samples->getElement(it)->getElement(1);
affectation=samples->getElement(it)->getLastElement();
OutputFile << ind << " " << i+1 << " 0 0 " << sex << " " << affectation << " " << i+1 << " "; 
genotypes=new map<string, string>();
tf=new TextFile(filename);
line=0;
end=false;
foundInd=false;
currentLine=tf->readLine();
while (currentLine!=NULL && !end)
{
if (ind==(currentLine->getElement(1)))
{
gene=currentLine->getElement(2);
gene=gene+currentLine->getElement(3);
(*genotypes)[currentLine->getElement(0)]=gene;
foundInd=true;
}
if (ind!=(currentLine->getElement(1)) && foundInd)
end=true;
zap(currentLine);
currentLine=tf->readLine();
line++;
}
for (stringList::iterator it2=pos->begin(); it2<pos->end(); it2++)
{
posId=pos->getElement(it2);
it3=genotypes->find(posId);
if (it3==genotypes->end())
{
OutputFile2 << "ERROR: Pos " << posId <<" not found for ind " << ind <<"\n";
OutputFile << "?" << " " << "?";
}
else OutputFile << it3->second.c_str()[0] << " " << it3->second.c_str()[1];
if (it2<pos->end()-1) OutputFile << " "; 
else OutputFile << "\n";
}
zap(genotypes);
i++;
zap(tf);
}
zap(pos);
zap(samples);
OutputFile.close();
OutputFile2.close();
cout << "File " << filename << " has been saved in makeped format at " << filename2 <<"\n";




}

/*____________________________________________________________ */

void ImportFromHUDSON (char *filename)
{
// a first line must be introduced with the total nmber of SNPs
// lst two lines must be removed
	/*
cout <<"Importing from HUDSON at file " << filename << "\n";


unsigned int i2;
ifstream InputFile; 




InputFile.open (filename, ifstream::in);
if (!InputFile)
	throw ErrorFile();

	char *genotypebuf, *genotypebuf2, *cad, *cad2;
    if ((genotypebuf=new char[100000])==NULL)
     throw NoMemory();
	if ((genotypebuf2=new char[100000])==NULL)
     throw NoMemory();
	if ((cad=new char[10])==NULL)
     throw NoMemory();
	if ((cad2=new char[10])==NULL)
     throw NoMemory();


 //    unsigned long int pos;
	 bool found=false;
	 unsigned long int TotalSNPs;

   	InputFile.getline (genotypebuf, 200, '\n');
	cad = strtok (genotypebuf," \t");
//	cad = strtok (NULL," \t");
	TotalSNPs=atoi(cad);



char *filename2;

if ((filename2=new char[64])==NULL)
 throw NoMemory();

filename2=strtok(filename, ".");

strncat(filename2, ".pos\0", 4);//


OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile();

  cad = strtok (genotypebuf," \t");
  for (i2=0; i2<TotalSNPs; i2++)
   OutputFile << i2 << "\n";


OutputFile.close();

cout << "Position file " << filename2 << " has been generated\n";




filename2=strtok(filename, ".");

strncat(filename2, ".txt\0", 4);//


OutputFile.open (filename2, ifstream::out);
if (!OutputFile)
	throw ErrorFile();


	 unsigned int size=0;

	 
	while  (InputFile.peek()!=EOF)
	{
    InputFile.getline (genotypebuf, 200, '\n'); // number
	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
    InputFile.getline (genotypebuf2, 200, '\n'); // number
    InputFile.getline (genotypebuf, 200, '\n'); // number
	InputFile.getline (genotypebuf, 8*TotalSNPs, '\n');
    InputFile.getline (genotypebuf2, 200, '\n'); // number
	InputFile.getline (genotypebuf2, 8*TotalSNPs, '\n');

	size++;

    OutputFile << size << " " << size << " 1 2 0 0 " << size << " ";	
	
	 for (i2=0; i2<TotalSNPs; i2++)
	 {
	 OutputFile << ConvertAllele(*(genotypebuf+i2)) << " "; 
 	 OutputFile << ConvertAllele(*(genotypebuf2+i2)); 
	 if (i2<(TotalSNPs-1))
      OutputFile << " "; 
	 else
	  OutputFile << "\n"; 
	 }
	}; // end while
InputFile.close();
OutputFile.close();

cout << "File " << filename2 << " has been saved in dHAP format\n";


delete genotypebuf, cad2, cad, genotypebuf2, filename, filename2;
*/
}
/*____________________________________________________________ */




};  // Fin del Namespace

#endif
/* Fin Fichero: ImportFormat.h */
/* File: ImportFormat.h */
