/* File: InferredHaplotypes.h */

#ifndef __InferredHaplotypes_h__
#define __InferredHaplotypes_h__

//using namespace stats;

namespace BIOS
{


	/************************/
	/* SNP'S MultimarkerMeasure DEFINITION */
	/************************/


	/**
	        @memo InferredHaplotype
		@doc
	  
	  
	        @author Maria del Mar Abad Grau
		@version 1.0
	*/


	class InferredHaplotypes: public HaplotypesForEachIndividual
	{
		public:
			int indCount;
			double freq;
			InferredHaplotypes() :HaplotypesForEachIndividual()
			{
				outputSeparator='-'; delimiters=true; printTransmitted=true; printUntransmitted=true;
			};
			InferredHaplotypes ( long long int leftHaplotype, long long int rightHaplotype, int indCount, double freq, char outputSeparator, bool delimiters=false, bool printTransmitted=true, bool  printUntransitted=true ) : HaplotypesForEachIndividual ( leftHaplotype, rightHaplotype, indCount )
			{
				this->outputSeparator=outputSeparator; this->delimiters=delimiters; this->printTransmitted=printTransmitted; this->printUntransmitted=printUntransitted;
				this->freq=freq;
				this->indCount=indCount;
			};
			~InferredHaplotypes() {};
			static InferredHaplotypes* fromString ( string s )
			{
				throw NonImplemented ( "static InferredHaplotypes* fromString(string s)" );
			};
			InferredHaplotypes* clone() { return new InferredHaplotypes ( *this );};
			bool operator== ( InferredHaplotypes& other ) {throw NonImplemented ( "InferredHaplotypes::operator==(InferredHaplotypes& other)" );};

	};
	/*______________________________________________________*/

	ostream& operator<< ( ostream& out, struct InferredHaplotypes& pm )
	{
		if ( pm.delimiters )  out << "L-R: [";
		out << pm.leftHaplotype << pm.outputSeparator << pm.rightHaplotype;
		if ( pm.delimiters ) out <<"]: ";
		out << pm.indCount;
		if ( pm.delimiters ) out << "(";
		out << pm.freq;
		if ( pm.delimiters ) out <<")";
		return out;
	};

	typedef Container<vector<InferredHaplotypes*>, InferredHaplotypes*>  InferredHaplotypesList;
	/*______________________________________________________*/

	ostream& operator<< ( ostream& out, InferredHaplotypesList& lista )
	{
		//out <<lista.leftDelimiter;
		InferredHaplotypesList::iterator p=lista.getFirst();
		while ( p!=lista.end() )
		{
			if ( *p!=NULL ) out << **p; else cout << "null value";
			p=lista.getNext ( p );
			if ( p!=lista.end() ) out <<"\n";
			else
			{
//				out << lista.rightDelimiter;
				out <<"\n";
			}
		}
		out <<"\n";

		return out;
	}


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




