/* File: LongHaplotype.cpp */


#ifndef __LongHaplotype_cpp__
#define __LongHaplotype_cpp__

//using namespace UTILS;


namespace BIOS {


/*_____________________________________________________*/

LongHaplotype::LongHaplotype():Haplotype(){}
	
/*
Haplotype::Haplotype(base* source, SNPPos TotalSNPs)
{
setHaplotypeArray(source, TotalSNPs);
};
*/

/*_____________________________________________________*/

LongHaplotype::LongHaplotype(SNPPos totalPos):Haplotype(totalPos)
{
}

/*_____________________________________________________*/

LongHaplotype::LongHaplotype(base * alleleArray, SNPPos size):Haplotype(alleleArray, size)
{
}

/*_____________________________________________________*/


LongHaplotype::LongHaplotype(const LongHaplotype & source): Haplotype(source)
{
}

/*_____________________________________________________*/

double LongHaplotype::getDistance(LongHaplotype* other, int position, bool toLeft)
{
// position and toLeft are not used, this class has been created to provide another way of computing distances
  double result;
  
  if ( other->size() != size() )
	 throw OutOfBounds (other->size(), this->size(), "Haplotype::getDistance(...) ");
  

	result=0;
	 for (int i=0; i<size(); i++)
	 {
		if (alleleArray[i]!=other->alleleArray[i]) result++;
		  }
  
  return result;
}

};  // End of Namespace

#endif

/* End of file: Haplotype.h */




