/* File: MonolociMeasure.h */


#ifndef __MonolociMeasure_cpp__
#define __MonolociMeasure_cpp__






namespace BIOS {



/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



///////////////////
//// public ////////
///////////////////
/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalAllele(const SNPPos & SNP, const allele allele1, int distance)
{
double total=sample->genotypeSample->GetTotalAllele(SNP, allele1, sample->Marked);
total=AddBayesAllele(total, Bayes, distance, alpha);
return total;
}

/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalFreqAllele(const SNPPos & SNP, const allele allele1, int distance)
{
	double total=GetTotalAllele(SNP, allele1);
	double total2=0;
	for (int i=0; i<4; i++)
	 total2=total2+GetTotalAllele(SNP, (allele)(i+1));
	total2=AddBayesAllele(total2, Bayes, distance, alpha);
 if (total2>0)
 return total/total2;
 else return 0;
}

/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalMissing(const SNPPos & SNP)
{
	return sample->genotypeSample->getTotalMissing(SNP, sample->Marked);
	
}

/*____________________________________________________________ */

template<class T> double MonolociMeasure<T>::GetTotalKnown(const SNPPos & SNP)
{
	return sample->genotypeSample->getTotalNonMissing(SNP, sample->Marked);
	
}


};  // End of Namespace

#endif

/* End of file: MonolociMeasure.h */




