
/* File: GetMultimarkerMeasuresByBlocks.cpp */


#ifndef __MultimarkerMeasuresByBlocks_cpp__
#define __MultimarkerMeasuresByBlocks_cpp__



/*______________________________________________________________________________*/



namespace BIOS {



/*___________________________________________________________________________*/

doubleList** MultimarkerMeasuresByBlocks::getPermutationResults (TrioCountersHapUAndT *TM, int totalPermutations, int totalPermutationMeasures, bool maxHap, intList* ignoreMeasures)
{
double* measuresP;
TrioCountersHapUAndT *TMP=NULL;
doubleList** distr= new doubleList*[totalPermutationMeasures];
for (int i=0; i<totalPermutationMeasures; i++)
 distr[i]=new doubleList();
for (int j=0;j<totalPermutations;j++)// 1000
{
if (j%10==0) cout <<  "permutation" << j+1 <<"\n";;
TMP=TM->getPermutation();
if (TMP->haplotypeCounts!=NULL) 
{
measuresP=GetMultimarkerMeasures::getMeasureValues(TMP, totalPermutationMeasures, maxHap, ignoreMeasures);
//measuresP=Initialize(totalMeasures, 0.0);
for (int i=0; i<totalPermutationMeasures; i++)
 distr[i]->insertElement(measuresP[i]);
zaparr(measuresP);
zap(TMP);
}
}
return distr;
}
/*_______________________________________________________________________*/

void MultimarkerMeasuresByBlocks::updateMeasures (TrioCountersHapUAndT *TM, int totalPermutations, int totalMeasures, int totalPermutationMeasures, int subblockSize, const int * const pos, int iniBlock, const double * const measures, double **measuresP, bool maxHap, intList* ignoreMeasures, bool useOnlyKnownDistributions, bool onlyHetero) throw (NonProb,NonDefined)
{
double*distribution=NULL, p, totalUsedDifferentHaplotypesInG1, totalUsedHaplotypesInG1;
//for (int i=0; i<totalMeasures; i++)
//if (((i<2 || i==16) && (phaseAlg!=2)) || (i>=2 && i<16))
doubleList** distr=NULL;
if (useOnlyKnownDistributions==false) distr=getPermutationResults(TM, totalPermutations, totalPermutationMeasures, maxHap, ignoreMeasures);
doubleList* weights;
for (int i=0; i<totalMeasures; i++)
if (ignoreMeasures==NULL || ignoreMeasures->findElement(i)==ignoreMeasures->end()) 
{
p=-1;
if (i<totalPermutationMeasures)
{
if (!useOnlyKnownDistributions)
{
distr[i]->sort();
//cout << "\n"<< getAlgorithmName(i) << ": " << measures[i] << " versus " << *distr[i];
distribution=distr[i]->getTable();
p=getPValue(distribution, distr[i]->size(), measures[i]);
}
}
else
switch (i)
{
case 17: case 18: case 25: case 26: case 34: case 35:
p=pdfTestChiSquare(measures[i], 1); break;
case 19: case 20: case 21: case 22: case 23: case 24: case 27: case 30:
p=pdfTestChiSquare(measures[i], (int)TM->totalUsedDifferentHaplotypes-1); break;
case 29:p=pdfTestChiSquare(measures[i], 9); break;
case 28: case 31: case 32:
if (i==28) weights=TM->getWeightsInWTDT(parent);
if (i==31) weights=TM->getWeightsInWTDT(parent,1);
if (i==32) weights=TM->getWeightsInWTDT(parent,2);
p=pdfTestWeightedChiSquare(measures[i], weights); 
zap (weights);
break;
}


if ((p>(1+zero) || p<(0-zero))) cout <<"error in p" << p <<"for measure:" << i <<"\n";

if (i==25)//grouping
{
 OutputFile2 << *TM->getG2Results(true, p, pos[0]+iniBlock);
 OutputFile3 << *TM->getG2Results(false, p, pos[0]+iniBlock);
}
if (i==27) // exact TDT
{
OutputFile4 << *TM->getTDTFreqsResults(pos[0]+iniBlock);
}


for (int j=0;j<subblockSize;j++)
{
if (measuresP[pos[j]][i]==-1.0) measuresP[pos[j]][i]=0;
measuresP[pos[j]][i]=measuresP[pos[j]][i]+p;
//if (i==(totalMeasures-1)) cout <<"\nupdated measure at pos: " << pos[j]-iniBlock;
}
if (!useOnlyKnownDistributions && i<totalPermutationMeasures) 
{
zap(distr[i]);
zaparr(distribution);
}
}// for each measure
 zaparr(distr);
//OutputFile <<"\n";

} // for each subblock with snps

/*_______________________________________________________________________*/

void MultimarkerMeasuresByBlocks::printResults (int totalMeasures, int size, const int* const totalOverlaps, const int* const totalOverlapsLogTDT, double **measuresP, intList* ignoreMeasures)
{
double alpha;


for (int i=0; i<totalMeasures; i++)
if (ignoreMeasures==NULL || ignoreMeasures->findElement(i)==ignoreMeasures->end()) 
{
 OutputFile << GetMultimarkerMeasures::getAlgorithmName(i);
if (i<(totalMeasures-1)) OutputFile <<"\t";  
}
OutputFile <<"\n";
if (measuresP==NULL) 
OutputFile << "singleSNP\n";
else 
for (int s=0;s<size; s++)
{
//cout <<"\ntotal overlaps snp " << s+1 <<": " << totalOverlaps[s];
for (int i=0; i<totalMeasures; i++)

if (ignoreMeasures==NULL || ignoreMeasures->findElement(i)==ignoreMeasures->end()) 
{
// OutputFile << getAlgorithmName(i);
 if (i!=29) alpha=measuresP[s][i]/(double)totalOverlaps[s];
else 
{
if (totalOverlapsLogTDT[s]>0) alpha=measuresP[s][i]/(double)totalOverlapsLogTDT[s];
else alpha=-1;
}
//cout <<"bef alpha is:" << alpha;
// if (alpha<0.9) alpha=0; else alpha=0.1+floor(100*(alpha-0.9))/10;
//cout <<"now alpha is:" << alpha;
  OutputFile << alpha <<"\t";
 //OutputFile <<"\t" << getAlgorithmName(i);
// OutputFile << " p:\t" << alpha  <<"\t" ;
}
OutputFile <<"\n";

}
}

/*_______________________________________________________________________*/

void MultimarkerMeasuresByBlocks::getMeasures (char* filename, stringSample* blocks,  int windowOffset, int width, bool knownPhase, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction, int totalMeasures, int totalPermutationMeasures, int totalPermutations, AlleleOrderType alleleOrderType, int totalSNPs, bool maxHap, intList* ignoreMeasures, bool useOnlyKnownDistributions, bool onlyHetero, SNPPos firstPosition, SNPPos lastPosition)  throw (OutOfRange<long long int>, OutOfRange<int>, OutOfRange<int>, NonProb, NoMemory, NonDefined, ZeroValue, NoWindow)
{
try
{
TrioSample* sample=NULL;
intList* regionSizes=NULL, *regionInitialSNPs=NULL;
int totalWindows, size, *absolutePos, *relativePosWithinBlock, *relativePos;
absolutePos=new int[width];
relativePosWithinBlock=new int[width];
relativePos=new int[width];
double* measures=NULL;
TrioCountersHapUAndT *TM=NULL;
double **measuresP=NULL;
int *totalOverlaps=NULL, *totalOverlapsLogTDT=NULL;
TrioCountersHapUAndT *TMKnown=NULL;
int totalBlocks=1;
if (lastPosition==-1) lastPosition=totalSNPs-1;
totalSNPs=lastPosition-firstPosition+1;
regionSizes=new intList();
regionInitialSNPs=new intList();
if (blocks!=NULL) 
{
totalBlocks=blocks->size();
for (int i=0; i<totalBlocks;i++)
{
regionSizes->insertElement(blocks->getElement(i)->size());
regionInitialSNPs->insertElement(atoi(blocks->getElement(i)->getFirstElement().c_str())-1);
}
}
else
{
regionSizes->insertElement(totalSNPs);
regionInitialSNPs->insertElement(firstPosition);
}
 OutputFile2 << *TrioCountersHapUAndT::getHeadFileG2();
 OutputFile3 << *TrioCountersHapUAndT::getHeadFileG2();
 OutputFile4 << *TrioCountersHapUAndT::getHeadFileTDTFreqs();
SlidingWindows *sw=NULL;
for (int i=0; i<totalBlocks;i++)
{
sw=new SlidingWindows(width, windowOffset, regionSizes->getElement(i), regionInitialSNPs->getElement(i));
size=sw->getRegionLength();
measuresP=new double*[size];
for (int j=0; j<size; j++)
measuresP[j]=Initialize(totalMeasures, -1.0);
totalOverlaps=Initialize(size, 0);
totalOverlapsLogTDT=Initialize(size, 0);
totalWindows=sw->getTotalCompleteWindows();
//cout <<"totalwindows: " << totalWindows <<"\n";
for (int b=0; b<totalWindows; b++)
{
if (blocks!=NULL) cout <<"\nBlock " << i+1 <<", subblock " << b+1 <<"\n";
cout <<"\nWindow: " << sw->getFirstRelativePositionAtWindow(b)+1 <<"\n";
for (int j=0;j<width;j++)
{
absolutePos[j]=sw->getFirstAbsolutePositionAtWindow(b)+j;
relativePos[j]=j;
relativePosWithinBlock[j]=sw->getFirstRelativePositionAtWindow(b)+j;
 totalOverlaps[relativePosWithinBlock[j]]++;
 totalOverlapsLogTDT[relativePosWithinBlock[j]]++;
}
sample=new TrioSample(filename, absolutePos, width, alleleOrderType);

TM=new TrioCountersHapUAndT(relativePos, width, sample, allAffectation, phaseAlg, emDistributions, emRestriction, false, onlyHetero);

if (TM->haplotypeCounts!=NULL)
{
measures=GetMultimarkerMeasures::getMeasureValues(TM, totalMeasures, maxHap, ignoreMeasures);
if (totalMeasures>=30 && measures[29]==-1) 
for (int j=0;j<width;j++)
 totalOverlapsLogTDT[relativePosWithinBlock[j]]--;
//cout <<"measures computed for size: " << width <<"starting at " << pos[0] <<"\n";
updateMeasures(TM, totalPermutations, totalMeasures, totalPermutationMeasures, width, relativePosWithinBlock, regionInitialSNPs->getElement(i), measures, measuresP,  maxHap, ignoreMeasures, useOnlyKnownDistributions, onlyHetero);
//zaparr(measures);
} // TM!=NULL
else 
{
TM=NULL;
OutputFile2 << "haplotypesNotFound\n";
OutputFile3 << "haplotypesNotFound\n";
OutputFile4 << "haplotypesNotFound\n";
cout << "not known haplotypes found\n";
}
zap(TM);

cout <<*sample <<"\n",
zap(sample);
} // for each window
printResults(totalMeasures, size, totalOverlaps, totalOverlapsLogTDT, measuresP, ignoreMeasures);
for (int k=0; k<size; k++)
zaparr(measuresP[k]);//, totalMeasures);
zaparr(measuresP);//, size);
zaparr(totalOverlaps);//, size);
zaparr(totalOverlapsLogTDT);// size);
zap(sw);
} // for each block
zaparr(absolutePos);
zaparr(relativePos);
zaparr(relativePosWithinBlock);
zap(regionInitialSNPs);
zap(regionSizes);
}
catch (OverflowedSNP & os) {os.addMessage("\ncalled from MultimarkerMeasuresByBlocks::getMeasures"); throw;}
catch (BasicException & be) {be.addMessage("\ncalled from MultimarkerMeasuresByBlocks::getMeasures"); throw;};
}

} // end namespace

#endif




