/* File: PairGenotype.h */


#ifndef __PairGenotype_cpp__
#define __PairGenotype_cpp__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the First, one for the Second. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/




/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

PairGenotype::PairGenotype ()
{
}
/*____________________________________________________________ */

PairGenotype::PairGenotype (PairGenotype * Source)
{
FirstGenotype=Source->FirstGenotype;
SecondGenotype=Source->SecondGenotype;
}
/*____________________________________________________________ */

PairGenotype::PairGenotype (Genotype * Source1, Genotype * Source2)
{
FirstGenotype=Source1;
SecondGenotype=Source2;
}

/*____________________________________________________________ */

Genotype* PairGenotype::getFirstGenotype ()
{
	return FirstGenotype;
}
/*____________________________________________________________ */

Genotype* PairGenotype::getSecondGenotype ()
{
	return SecondGenotype;
}
/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Homozygous1 (SNPPos position, allele ** allAlleles)      
{
return Diplotype::isHomozygous1(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHomozygous1(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]);
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous2Homozygous2 (SNPPos position, allele ** allAlleles)      
{
return Diplotype::isHomozygous2(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHomozygous2(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]);
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Homozygous2 (SNPPos position, allele ** allAlleles)      
{
return 
(Diplotype::isHomozygous1(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHomozygous2(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]))
||
(Diplotype::isHomozygous2(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHomozygous1(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]));
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Heterozygous (SNPPos position, allele ** allAlleles)      
{
return 
(Diplotype::isHomozygous1(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHeterozygous(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]))
||
(Diplotype::isHeterozygous(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHomozygous1(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]));
};
/*___________________________________________________*/

bool PairGenotype::IsHomozygous2Heterozygous (SNPPos position, allele ** allAlleles)      
{
return 
(Diplotype::isHomozygous2(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHeterozygous(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]))
||
(Diplotype::isHeterozygous(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHomozygous2(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]));
};

/*___________________________________________________*/

bool PairGenotype::IsHomozygousHeterozygous (const SNPPos position, allele ** allAlleles)      
{
return IsHomozygous1Heterozygous(position, allAlleles)
		|| IsHomozygous2Heterozygous(position, allAlleles);
};
/*___________________________________________________*/

bool PairGenotype::IsHeterozygousHeterozygous (const SNPPos position, allele ** allAlleles)      
{
return Diplotype::isHeterozygous(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && Diplotype::isHeterozygous(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]);
};


/*___________________________________________________*/

bool PairGenotype::IsMissingMissing (const SNPPos position)      
{
return !Diplotype::isANonMissingSNP(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position]) && !Diplotype::isANonMissingSNP(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position]);
};


/*___________________________________________________*/

bool PairGenotype::IsHomozygous1Missing (const SNPPos position, allele ** allAlleles)      
{
return (Diplotype::isHomozygous1(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && !Diplotype::isANonMissingSNP(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position]))
||
   (!Diplotype::isANonMissingSNP(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position]) && Diplotype::isHomozygous1(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]));
};

/*___________________________________________________*/

bool PairGenotype::IsHomozygous2Missing (const SNPPos position, allele ** allAlleles)      
{
return (Diplotype::isHomozygous2(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && !Diplotype::isANonMissingSNP(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position]))
||
   (!Diplotype::isANonMissingSNP(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position]) && Diplotype::isHomozygous2(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]));
};
/*___________________________________________________*/

bool PairGenotype::IsHeterozygousMissing (const SNPPos position, allele ** allAlleles)      
{
return (Diplotype::isHeterozygous(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position], allAlleles[position][0]) && !Diplotype::isANonMissingSNP(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position]))
||
   (!Diplotype::isANonMissingSNP(FirstGenotype->DiplotypeArray[0][position], FirstGenotype->DiplotypeArray[1][position]) && Diplotype::isHeterozygous(SecondGenotype->DiplotypeArray[0][position], SecondGenotype->DiplotypeArray[1][position], allAlleles[position][0]));
};


};  // End of Namespace

#endif

/* End of file: PairGenotype.h */




