#ifndef __PairwiseMeasuresResults_cpp__
#define __PairwiseMeasuresResults_cpp__






namespace BIOS
{


	/************************/
	/* SNP'S MultiallelicPairwiseMeasuresResults DEFINITION */
	/************************/

	/*______________________________________________________________*/

	template<class T> char* PairwiseMeasuresResults<T>::PrintConfiguration()
	{
		char* p=line;
		sprintf ( line,"file source:%s,Bayes type:%d,IndCategory:%d,Phase mode:%d\n",filename,BayesMode,ic,AlleleOrderMode );
		return p;
	}
	/*______________________________________________________________*/

	template<class T> char* PairwiseMeasuresResults<T>::PrintHeading ( int type,bool basic )
	{
		char* p=line;
		switch ( type )
		{
			case 0:
				if ( !basic )
					strcpy ( line,"SNP1,Position1,rsNumber1,TypeSNP1,SNP2,Position2,rsNumber2,TypeSNP2,n(A),n(a),n(B),n(b),n(HH)(individuals),n(AB),n(Ab),n(aB),n(ab),f(A),f(B),f(a),f(b),f(AB),D,maxD,DPrime,DPrimeLowerBound,DPrimeUpperBound,R2,YulesQ,rho\n" );
				else
					strcpy ( line,"SNP1,Position1,TypeSNP1,SNP2,Position2,TypeSNP2,DPrime,R2\n" );

				break;
			case 1:
				OutputFile << "Average distance (kb)" << "\t" <<  "number of comparisons" << "\t" << "DPrime\tr2" << "\t" << "YulesQ" <<"\n";
				break;
			case 2:
				break;
		}
		return p;
	}
	/*______________________________________________________________*/

	template<class T> char* PairwiseMeasuresResults<T>::setCommon ( int type,char filename2[256],bool PrintConf,double& MaximumDistance,bool basic )
	{
		OpenOutput ( filename2,&OutputFile );
		OpenOutput ( fileLogs,&logs );

		changeExtension ( filename,filepos,"pou" );
		Pos=new Positions ( filepos );

		gs=new T ( filename,NULL, 0, ic, AlleleOrderMode );

		TotalSNPs=GetTotalSNPs ( filename );
		if ( MaximumDistance==0.0 ) MaximumDistance=Pos->GetDistance ( 0,TotalSNPs-1 );

		if ( lastPosition==0 )
			lastPosition=Pos->getLastElement()->pos;

		MM = new MonolociMeasure<T> ( gs, ( BayesType ) 0,alphaBayes );
		MM2=NULL;
		if ( Selection )
		{
			gs2=new T ( fileSelection,NULL, 0, ic, AlleleOrderMode );
			MM2 = new MonolociMeasure<T> ( gs2, ( BayesType ) 0,alphaBayes );
		}

		if ( PrintConf ) OutputFile <<PrintConfiguration();
		OutputFile << PrintHeading ( type,basic );
	}
	/*______________________________________________________________*/

	template<> char* PairwiseMeasuresResults<TrioSample>::setCommon ( int type,char filename2[256],bool PrintConf,double& MaximumDistance,bool basic )
	{
		OpenOutput ( filename2,&OutputFile );
		OpenOutput ( fileLogs,&logs );
		changeExtension ( filename,filepos,"pou" );
		Pos=new Positions ( filepos );
		gs=new TrioSample ( filename, NULL, 0, AlleleOrderMode, false );
		TotalSNPs=GetTotalSNPs ( filename );
		if ( MaximumDistance==0.0 ) MaximumDistance=Pos->GetDistance ( 0,TotalSNPs-1 );
		if ( lastPosition==0 )
			lastPosition=Pos->getLastElement()->pos;

		MM = new MonolociMeasure<TrioSample> ( gs, ( BayesType ) 0,alphaBayes );
		MM2=NULL;
		if ( Selection )
		{
			gs2=new TrioSample ( fileSelection,NULL, 0, AlleleOrderMode, false );
			MM2 = new MonolociMeasure<TrioSample> ( gs2, ( BayesType ) 0,alphaBayes );
		}
		if ( PrintConf ) OutputFile <<PrintConfiguration();
		OutputFile << PrintHeading ( type,basic );
	}
	/*______________________________________________________________*/

	template<class T> PairwiseMeasuresResults<T>::PairwiseMeasuresResults ( char filenam[256],float maf,BayesType BayesMod,float alphaBayes,bool onlyConsecutives,IndCategory i,int phas,AlleleOrderType AlleleOrderMod,PhaseAlg phaseAlg, float alph,bool invarian,double firstPosition,double lastPosition,char* filesel )
	{
		Pos=NULL;
		MM=NULL;
		MM2=NULL;
		gs=NULL;
		gs2=NULL;
		strcpy ( filename,filenam );
		changeExtension ( filename,fileLogs,"log" );
		MAF=maf;
		BayesMode=BayesMod;
		this->alphaBayes=alphaBayes;
		this->onlyConsecutives=onlyConsecutives;
  this->phaseAlg=phaseAlg;
		ic=i;
		phase=phas;
		alpha=alph;
		invariant=invarian;
		AlleleOrderMode=AlleleOrderMod;
		this->lastPosition=lastPosition;
		this->firstPosition=firstPosition;
		if ( filesel==NULL )
			Selection=false;
		else
		{
			strcpy ( fileSelection,filesel );
			Selection=true;
		}


	}
	/*______________________________________________________________*/

	template<class T> PairwiseMeasuresResults<T>::~PairwiseMeasuresResults()
	{
	}
	/*______________________________________________________________*/

	template<class T> string PairwiseMeasuresResults<T>::getAverageResults()
	{
		string s=string ( "Total counts:\n" );
		s=s+tos ( AvDPrime/totalPairs );
		return s;
	}
	/*______________________________________________________________*/

	template<class T> bool PairwiseMeasuresResults<T>::isInside ( double position )
	{
		return ( position>=firstPosition && position<=lastPosition );
	}
	/*______________________________________________________________*/

	template<class T> void PairwiseMeasuresResults<T>::PrintClassicPairwisesMeasures ( char filename2[256],bool PrintConf,double MaximumDistance,bool basic )
	{
		try
		{
			setCommon ( 0,filename2,PrintConf,MaximumDistance,basic );
			PrintClassicPairwisesMeasuresInside1 ( MaximumDistance,basic );
			cout << "\nInformation about pairwise measures has been saved in file " << filename2 <<"\n";
			cout << "\nA log file was created with name " << fileLogs <<"\n";

			OutputFile.close();
			logs.close();
		}
		catch ( BasicException & nv ) {nv.addMessage("\n called from void PairwiseMeasuresResults<T>::PrintClassicPairwisesMeasures ( char filename2[256],bool PrintConf,double MaximumDistance,bool basic )"); throw; }
		OutputFile.close();
	};
	/*________________________________________________________________________________*/

	template<class T> void PairwiseMeasuresResults<T>::PrintClassicPairwisesMeasuresInside1 ( double MaximumDistance,bool basic )
	{
		AvDPrime=0;
		totalPairs=0;
		Positions::iterator p=Pos->getFirst(),p2;
		int SNP=0,SNP2;
		while ( p!=Pos->end() )
		{
			if ( SNP%10000==0 ) cout <<"snp:" << SNP+1 << "\n";
			if ( !isInside ( Pos->getElement ( p )->pos ) ) logs << "SNP " << SNP+1 << "(" << Pos->PrintPosition ( p ) <<") is outside range\n";
			else if ( !invariant && ( ( gs->genotypeSample->totalAlleles[SNP]==1 || MM->GetTotalFreqAllele ( SNP,gs->genotypeSample->allAlleles[SNP][1] ) <MAF ) ) ) logs << "SNP " << SNP+1 << "(" << Pos->PrintPosition ( p ) <<") has MAF lower than " << MAF <<"\n";
			else  if ( Selection && ( ( gs2->genotypeSample->totalAlleles[SNP]==1 ||  MM2->GetTotalFreqAllele ( SNP,gs2->genotypeSample->allAlleles[SNP][1] ) <MAF || MM2->GetTotalFreqAllele ( SNP,gs2->genotypeSample->allAlleles[SNP][0] ) <MAF ) ) )
				logs << "SNP " << SNP+1 << "(" << Pos->PrintPosition ( p ) <<") has MAF lower than " << MAF << " in selection file\n"; else
				PrintClassicPairwisesMeasuresInside2 ( p,SNP,MaximumDistance,basic );

			SNP++;
			p=Pos->getNext ( p );
		} // end first while
	}


	/*________________________________________________________________________________*/

	template<class T> void PairwiseMeasuresResults<T>::PrintClassicPairwisesMeasuresInside2 ( Positions::iterator p,int SNP,double MaximumDistance,bool basic )
	{

		T* partialSample=NULL;

		HapCounters* TM;

		BidimensionalTable<double>* multiallelicFreqsUT=NULL;

		double DPrime;
		Positions::iterator p2=Pos->getNext ( p );
		int  SNP2=SNP+1;
		bool isConsecutive=true;
		MultiallelicPairwiseMeasure *PM=NULL;
		int posi[2], distance;
		bool includeMissing=false;
		while ( p2!=Pos->end() && ( Pos->GetDistance ( SNP,SNP2 ) <MaximumDistance ) && ( !onlyConsecutives || isConsecutive ) )
		{
   distance=Pos->GetDistance ( SNP,SNP2 ); 
			// cout <<"subsnp:" << SNP2 <<"\n";
			posi[0]=SNP;
			posi[1]=SNP2;

			partialSample=new T ( filename,posi, 2, ic, AlleleOrderMode );

			if ( !isInside ( Pos->getElement ( p2 )->pos ) ) logs << "SNP " << SNP2+1 << "(" << Pos->PrintPosition ( p2 ) <<") is outside range\n";
			else if ( !invariant && ( gs->genotypeSample->totalAlleles[SNP2]==1 || MM->GetTotalFreqAllele ( SNP2,gs->genotypeSample->allAlleles[SNP2][1] ) <MAF ) ) logs << "SNP2 " << SNP2+1 << "(" << Pos->PrintPosition ( p2 ) <<") has MAF lower than " << MAF <<"\n";
			else
				if ( Selection && ( ( gs2->genotypeSample->totalAlleles[SNP2]==1 || MM2->GetTotalFreqAllele ( SNP2,gs2->genotypeSample->allAlleles[SNP2][1] ) <MAF ||
				                      MM2->GetTotalFreqAllele ( SNP2,gs2->genotypeSample->allAlleles[SNP2][0] ) <MAF ) ) )
					logs << "SNP " << SNP2+1 << "(" << Pos->PrintPosition ( p2 ) <<") has MAF lower than " << MAF << " in selection file\n";
				else
				{
					isConsecutive=false;

					GenotypeCounters*	tc=new GenotypeCounters ( NULL, 0, partialSample, allAffectation, includeMissing );
					TM = new HapCounters ( tc, phaseAlg, BayesMode, alphaBayes, distance );



					multiallelicFreqsUT=TM->getMultiallelicFreqs ( 0, 1);
							PM=new MultiallelicPairwiseMeasure ( multiallelicFreqsUT );


			
if (1==0)
if (SNP==0 && SNP2==1)
{
cout << "alpha is:" << alphaBayes <<", bayes mode is: " << BayesMode << " and distance is: " << distance << "\n";
cout << "hapsfreqs:" << *TM->hapByFreqs << "\n";
cout <<"freqs:" << *multiallelicFreqsUT;
cout <<"original freqs:\n" << *TM->haplotypeFreqsTab; 
cout << "male haps: " <<*TM->maleHaps << "\n";
cout << "female haps: " <<*TM->femaleHaps << "\n";
//cout <<"\nfemale:\n" << *TM->haplotypeFreqsTabPairs->Second; 
exit(0);
}
					PrintLD ( PM,p,p2,SNP,SNP2,MaximumDistance,basic, MM, TM->totalMeiosis, gs->genotypeSample->size() );
					zap ( TM );
					zap ( PM );
					zap ( tc );

				} // end for each SNP2 a real SNP
			p2=Pos->getNext ( p2 );
			SNP2++;
			zap ( partialSample );
		} // end second while
	}
	/*________________________________________________________________________________*/

	template<> void PairwiseMeasuresResults<TrioSample>::PrintClassicPairwisesMeasuresInside2 ( Positions::iterator p,int SNP,double MaximumDistance,bool basic )
	{

		TrioCountersHapUAndT* TM=NULL;
		TrioSample* partialSample=NULL;
		BidimensionalTable<double>* multiallelicFreqsUT=NULL;
		TrioCounters*	tc=NULL;
		double DPrime;
		Positions::iterator p2=Pos->getNext ( p );
		int  SNP2=SNP+1;
		bool isConsecutive=true;
		MultiallelicPairwiseMeasure *PM=NULL;
		int posi[2];
		bool includeMissing=false;
  int distance;
		while ( p2!=Pos->end() && ( Pos->GetDistance ( SNP,SNP2 ) <MaximumDistance ) && ( !onlyConsecutives || isConsecutive ) )
		{
			posi[0]=SNP;
			posi[1]=SNP2;
   cout <<"subsnp:" << SNP2 <<"\n";
			partialSample=new TrioSample ( filename, posi, 2, AlleleOrderMode, false );
   distance=Pos->GetDistance ( SNP,SNP2 ); 
			if ( !isInside ( Pos->getElement ( p2 )->pos ) ) logs << "SNP " << SNP2+1 << "(" << Pos->PrintPosition ( p2 ) <<") is outside range\n";
			else if ( !invariant && ( gs->genotypeSample->totalAlleles[SNP2]==1 || MM->GetTotalFreqAllele ( SNP2,gs->genotypeSample->allAlleles[SNP2][1] ) <MAF ) ) logs << "SNP2 " << SNP2+1 << "(" << Pos->PrintPosition ( p2 ) <<") has MAF lower than " << MAF <<"\n";
			else
				if ( Selection && ( ( gs2->genotypeSample->totalAlleles[SNP2]==1 || MM2->GetTotalFreqAllele ( SNP2,gs2->genotypeSample->allAlleles[SNP2][1] ) <MAF ||
				                      MM2->GetTotalFreqAllele ( SNP2,gs2->genotypeSample->allAlleles[SNP2][0] ) <MAF ) ) )
					logs << "SNP " << SNP2+1 << "(" << Pos->PrintPosition ( p2 ) <<") has MAF lower than " << MAF << " in selection file\n";
				else
				{
					isConsecutive=false;

					//		cout << "snp:" << SNP << "and snps2:" << SNP2 <<"\n";
					tc=new TrioCounters ( NULL, 0, partialSample, allAffectation, includeMissing );
					TM = new TrioCountersHapUAndT ( tc, phaseAlg, UTDistributions, noRestriction, BayesMode, alphaBayes, distance );
multiallelicFreqsUT=TM->getMultiallelicFreqs ( 0, 1, ut, ic );

					PM=new MultiallelicPairwiseMeasure ( multiallelicFreqsUT );
if (1==0)
if (SNP==0 && SNP2==3)// 1 and 9
{
cout << "alpha is:" << alphaBayes <<", bayes mode is: " << BayesMode << " and distance is: " << distance << "\n";
cout << "hapsfreqs:" << *TM->hapByFreqs << "\n";
cout <<"freqs:" << *multiallelicFreqsUT;
cout <<"hapcounts:\n" << *TM->haplotypeCounts <<"\n";
cout << "haps:" << *TM->haplotypeFreqsTab <<"\n";
/*cout <<"original freqs:\nfatherT:\n" << *TM->haplotypeFreqsTabPairParents->First->First; 
cout <<"\nFatherU:\n" << *TM->haplotypeFreqsTabPairParents->First->Second; 
cout <<"\nMotherT:\n" << *TM->haplotypeFreqsTabPairParents->Second->First; 
cout <<"\nMotherU:\n" << *TM->haplotypeFreqsTabPairParents->Second->Second; 
*/
		cout << "\nfab is:" << PM->getFreq ( 0,0 );
		cout << "\nfa is:" << PM->getSNP1Freq ( 0 );
		cout << "\nfb is:" << PM->getSNP2Freq ( 0 );
			cout << "\ndprmme is: " << T2x2.GetDPrime ( PM->getFreq ( 0,0 ),PM->getSNP1Freq ( 0 ),PM->getSNP2Freq ( 0 ) );
			cout << "\nd is: " << T2x2.GetD ( PM->getFreq ( 0,0 ),PM->getSNP1Freq ( 0 ),PM->getSNP2Freq ( 0 ) );
}
					PrintLD ( PM,p,p2,SNP,SNP2,MaximumDistance,basic, MM, TM->totalMeiosis, gs->genotypeSample->size() );
					zap ( TM );
					zap ( PM );
					zap ( tc );
				} // end for each SNP2 a real SNP
			p2=Pos->getNext ( p2 );
			SNP2++;
			zap ( partialSample );
		} // end second while
	}
	/*________________________________________________________________________________*/

	template<class T> void PairwiseMeasuresResults<T>::PrintLD ( MultiallelicPairwiseMeasure *PM,Positions::iterator p,Positions::iterator p2,int SNP,int SNP2,double MaximumDistance,bool basic, MonolociMeasure<T>* MM, double totalHaplotypes, double totalSample )
	{
		try
		{

			fA=PM->getSNP1Freq ( 0 );
			fB=PM->getSNP2Freq ( 0 );




			fAB=PM->getFreq ( 0,0 );
			DPrime=T2x2.GetDPrime ( fAB,fA,fB );
			AvDPrime=AvDPrime+DPrime;
			totalPairs=totalPairs+1;
			//OutputFile
			OutputFile << SNP+1 << "," << Pos->PrintPosition ( p )  << ",";
			if ( !basic ) OutputFile << Pos->getRSNumber ( p )  << ",";
			OutputFile  << UnconvertAllele ( gs->getMajorAllele ( SNP,ic ) ) << "/"
			<< UnconvertAllele ( gs->getMinorAllele ( SNP,ic ) ) << ","
			<< SNP2+1 << "," << Pos->PrintPosition ( p2 )  << ",";
			if ( !basic ) OutputFile << Pos->getRSNumber ( p2 )  << ",";
			OutputFile  << UnconvertAllele ( gs->getMajorAllele ( SNP2,ic ) ) << "/"
			<< UnconvertAllele ( gs->getMinorAllele ( SNP2,ic ) ) << ",";
			if ( !basic )
				OutputFile << MM->GetTotalAllele ( SNP, gs->getMajorAllele ( SNP,ic ) ) << ","
				<< MM->GetTotalAllele ( SNP, gs->getMinorAllele ( SNP,ic ) ) << ","
				<< MM->GetTotalAllele ( SNP2, gs->getMajorAllele ( SNP2,ic ) ) << ","
				<< MM->GetTotalAllele ( SNP, gs->getMinorAllele ( SNP,ic ) ) << ","
				<< totalSample-totalHaplotypes*2 << ","
				<< PM->getFreq ( 0,0 ) *totalHaplotypes <<","
				<< PM->getFreq ( 0,1 ) *totalHaplotypes <<","
				<< PM->getFreq ( 1,0 ) *totalHaplotypes  <<","
				<< PM->getFreq ( 1,1 ) *totalHaplotypes  <<","
				<< fA <<","
				<< fB <<","
				<< 1-fA <<","
				<< 1-fB <<","
				<< fAB <<","
				<< T2x2.GetD ( fAB,fA,fB ) <<","
				<< T2x2.GetMaxD ( fAB,fA,fB ) <<",";

			sprintf ( line,"%1.4f,",DPrime );
			OutputFile << line;
			if ( !basic )
			{
				lowerbound=50-alpha/2;
				upperbound=50+alpha/2;


				if ( DPrime==1 )
				{
					lowerbound=100-alpha;
					upperbound=100;
				}
				if ( DPrime==0 )
				{
					lowerbound=0;
					upperbound=alpha;
				}

				//pair=T2x2.GetQuantilesDPrime(lowerbound,upperbound,fA,fB,PM->GetnAB(),PM->GetnAb(),PM->GetnaB(),PM->Getnab(),
				//PM->GetTotalUnKnown(),BayesMode);

				//     lowerbound=pair.First;
				//     upperbound=pair.Second;
				//     sprintf(line,"%1.2lf,%1.2lf,",lowerbound,upperbound);
				sprintf ( line,"N/A,N/A," );
				OutputFile << line;
			}
			sprintf ( line,"%1.4f",T2x2.GetR2 ( fAB,fA,fB ) );
			OutputFile << line;
			if ( !basic )
			{
				sprintf ( line,",%1.4f,%1.4f",T2x2.GetQ ( fAB,fA,fB ),T2x2.GetRho ( fAB,fA,fB ) );
				OutputFile << line;
			}
			OutputFile << '\n';
		}
		catch ( MultiAllelic ma ) {ma.PrintMessage ( "at PairwiseMeasuresResults<T>::PrintLD" );}
		catch ( ZeroValue zv ) {zv.PrintMessage ( "at PairwiseMeasuresResults<T>::PrintLD" );};
	}


	/*________________________________________________________________________________*/
	/*
	 template<class T> void PairwiseMeasuresResults<T>::printLDDecay ( char filename2[256],double MaximumDistance,SNPPos SlideSize,SNPPos SlideOverlap,bool PrintConf=true )
	 {
	  MultiallelicPairwiseMeasure *PM;
	  double DPrime;
	  SNPPos SlideGap=SlideSize-SlideOverlap;
	  SNPPos LastSNPInWindow,SNP=0,LastComparison,comparisons;
	  float pos,trueDistance;

	  bool EndReached=false,OverDistance=false;

	  setCommon ( 1,filename2,PrintConf,MaximumDistance );

	  if ( MaximumDistance==0.0 || MaximumDistance>Pos->GetDistance ( 0,TotalSNPs-1 ) )
	   MaximumDistance=Pos->GetDistance ( 0,TotalSNPs-1 );




	  cout <<"MaximumDistance:" << MaximumDistance <<"\n";
	  int posi[2];
	  do
	  {
	   if ( distance>MaximumDistance ) EndReached=true;
	   comparisons=0;
	   DPrime=0.0,lowerbound=0,upperbound=0,r2=0,YulesQ=0;
	   cout << "Distance: " << distance << "\n";
	   for ( SNPPos SNP2=0; SNP2< ( TotalSNPs-1 );SNP2++ )
	   {
	    if ( isInside ( Pos->getElement ( SNP2 )->pos ) )

	     if ( gs->GetTotalMissing ( SNP2,ic ) ==0 )
	      if ( invariant || MM->GetTotalFreqAllele ( SNP2,gs->genotypeSample->allAlleles[SNP2][1] ) >MAF )
	       if ( !Selection || MM2->GetTotalFreqAllele ( SNP2,gs2->genotypeSample->allAlleles[SNP2][1] ) >MAF )
	       {
	        SNP3=SNP2+1;
	        OverDistance=false;
	        do
	        {
	         trueDistance=Pos->GetDistance ( SNP2,SNP3 );
	         if ( trueDistance> ( distance+SlideOverlap ) ) OverDistance=true;
	         if ( trueDistance> ( distance-SlideOverlap ) && trueDistance<= ( distance+SlideOverlap ) )
	          if ( isInside ( Pos->getElement ( SNP3 )->pos ) )

	           if ( gs->GetTotalMissing ( SNP3,ic ) ==0 )
	            if ( invariant || MM->GetTotalFreqAllele ( SNP3,gs->genotypeSample->allAlleles[SNP3][1] ) >MAF )
	             if ( !Selection || MM2->GetTotalFreqAllele ( SNP3,gs2->genotypeSample->allAlleles[SNP3][1] ) >MAF )

	             {
	              posi[0]=SNP2;
	              posi[1]=SNP3;
	              PM = new MultiallelicPairwiseMeasure ( posi,gs,ic,everyGender, allAffectation,  BayesMode,alphaBayes,trueDistance,AlleleOrderMode );
	              fA=PM->GetfA();
	              fB=PM->GetfB();
	              fAB=PM->GetfAB();
	              DPrime=DPrime+T2x2.GetDPrime ( fAB,fA,fB );
	              r2=r2+T2x2.GetR2 ( fAB,fA,fB );
	              YulesQ=YulesQ+T2x2.GetQ ( fAB,fA,fB );

	              comparisons++;

	              zap ( PM );
	             } // end for each SNP3 with freq>MAF
	         SNP3++;
	        } // end for each pair with the right distance
	        while ( SNP3<TotalSNPs && OverDistance==false );
	       } // end if freq>MAF
	   } // end for each SNP2
	   OutputFile << distance/ ( double ) 1000  << "\t" << comparisons << "\t";
	   if ( comparisons>0 )
	    sprintf ( line,"%1.2lf\t%1.2lf\t%1.2lf\n",DPrime/comparisons,r2/comparisons,YulesQ/comparisons );
	   else sprintf ( line,"-\n" );
	   OutputFile << line;
	   distance=distance+SlideGap;
	   //exit(0);
	  }
	  while ( EndReached==false );
	  OutputFile.close();
	  zap ( MM );
	  zap ( MM2 );
	  //zap(gs);
	  //zap(gs2);
	  zap ( Pos );

	  cout << "\nInformation about LD Decay has been saved in file " << filename2 <<"\n";
	 }/*________________________________________________________________________________*/
	/*
	 template<class T> void PairwiseMeasuresResults<T>::printSlidingWindows ( char filename2[256],double MaximumDistance,SNPPos SlideSize,SNPPos SlideOverlap,bool PrintConf=true )
	 {
	  MultiallelicPairwiseMeasure *PM;
	  double DPrime;
	  SNPPos SlideGap=SlideSize-SlideOverlap;
	  SNPPos LastSNPInWindow,SNP=0,LastComparison,comparisons;
	  float pos,trueDistance;

	  bool EndReached=false,OverDistance=false;

	  setCommon ( 1,filename2,PrintConf,MaximumDistance );

	  if ( MaximumDistance==0.0 || MaximumDistance>Pos->GetDistance ( 0,TotalSNPs-1 ) )
	   MaximumDistance=Pos->GetDistance ( 0,TotalSNPs-1 );



	  cout <<"MaximumDistance:" << MaximumDistance <<"\n";
	  try
	  {
	   Positions::iterator i=Pos->getFirst(),j;

	   bool EndReached=false;
	   printf ( "width:%7.2f\n",MaximumDistance );
	   do
	   {
	    if ( Pos->IsEndReached ( i,SlideSize ) )
	    {
	     EndReached=true;
	     LastSNPInWindow=TotalSNPs-1;
	    }
	    else
	    {
	     LastSNPInWindow=SNP+Pos->GetTotalSNPs ( i,SlideSize );
	     pos=Pos->getElement ( i )->pos;
	    }
	    j=i;
	    comparisons=0;
	    if ( SNP%1000==0 )
	     cout << SNP+1 << "\n";
	    int posi[2];
	    DPrime=0.0,lowerbound=0,upperbound=0,r2=0;
	    for ( SNPPos SNP2=SNP; SNP2<=LastSNPInWindow;SNP2++ ) // until the end of the window
	     if ( isInside ( Pos->getElement ( SNP2 )->pos ) )

	      if ( gs->GetTotalMissing ( SNP2,ic ) ==0 )
	       if ( invariant || MM->GetTotalFreqAllele ( SNP2,gs->genotypeSample->allAlleles[SNP2][1] ) >MAF )
	        if ( !Selection || MM2->GetTotalFreqAllele ( SNP2,gs2->genotypeSample->allAlleles[SNP2][1] ) >MAF )
	        {
	         LastComparison=SNP2+Pos->GetTotalSNPs ( j,MaximumDistance );
	         if ( LastSNPInWindow<LastComparison ) LastComparison=LastSNPInWindow;
	         for ( SNPPos SNP3=SNP2+1; SNP3<LastComparison;SNP3++ ) // until max distance allowed
	          if ( isInside ( Pos->getElement ( SNP3 )->pos ) )

	           if ( gs->GetTotalMissing ( SNP3,ic ) ==0 )
	            if ( invariant || MM->GetTotalFreqAllele ( SNP3,gs->genotypeSample->allAlleles[SNP3][1] ) >MAF )
	             if ( !Selection || MM2->GetTotalFreqAllele ( SNP3,gs2->genotypeSample->allAlleles[SNP3][1] ) >MAF )
	             {
	              distance=Pos->GetDistance ( SNP2,SNP3 );
	              posi[0]=SNP2;
	              posi[1]=SNP3;
	              PM = new MultiallelicPairwiseMeasure( posi,gs,ic,everyGender, allAffectation, BayesMode,alphaBayes,distance,AlleleOrderMode );
	              if ( PM->GetfA() <1 && PM->GetfB() <1 ) // to avoid different missing counters between both SNPs
	              {
	               fA=PM->GetfA();
	               fB=PM->GetfB();
	               fAB=PM->GetfAB();
	               MLDPrime=MLDPrime+T2x2.GetMaxDPrime ( fA,fB,PM->GetnAB(),PM->GetnAb(),PM->GetnaB(),PM->Getnab(),PM->GetTotalUnKnown() );
	               pair=T2x2.GetQuantilesDPrime ( 50-alpha/2,50+alpha/2,fA,fB,PM->GetnAB(),PM->GetnAb(),PM->GetnaB(),PM->Getnab(),PM->GetTotalUnKnown() );
	               lowerbound=lowerbound+pair.First;
	               upperbound=upperbound+pair.Second;
	               DPrime=DPrime+T2x2.GetDPrime ( fAB,fA,fB );
	               r2=r2+T2x2.GetR2 ( fAB,fA,fB );
	               comparisons++;
	              } // end for each SNP3 with freq>MAF
	              zap ( PM );
	             } // end if freq>MAF
	         j=Pos->getNext ( j );
	        } // end for each SNP2
	    OutputFile << SNP+1 << "\t" <<  pos  << "\t" << comparisons << "\t";
	    if ( comparisons>0 )
	     sprintf ( line,"%1.2lf\t%1.2lf\t%1.2lf\t%1.2lf\t%1.2lf\n",DPrime/comparisons,r2/comparisons,MLDPrime/comparisons,lowerbound/comparisons,upperbound/comparisons );
	    else sprintf ( line,"-\n" );
	    OutputFile << line;
	    SNP=SNP+Pos->GetTotalSNPs ( i,SlideGap );
	    i=Pos->MoveToPos ( i,SlideGap );
	   }
	   while ( ( SNP< ( TotalSNPs-1 ) ) && ( EndReached==false ) );
	  }
	  catch ( OutOfRange<int> ori ) {ori.PrintMessage ( SNP );}
	  catch ( NonSNP ns ) {ns.PrintMessage ( ( string ( "at PairwiseMeasuresResults<T>::printSlidingWindows in SNP " ) +tos ( SNP ) ).c_str() );}
	  catch ( NullValue nv ) {nv.PrintMessage("at PairwiseMeasuresResults<T>::printSlidingWindows in SNP ");}
	  OutputFile.close();
	  cout << "\nInformation about sliding windows has been saved in file " << filename2 <<"\n";
	 };
	*/

}
;  // End of Namespace

#endif

/* End of file: PairwiseMeasuresResults.h */



