/* File: Phenotype.cpp */


#ifndef __Phenotype_cpp__
#define __Phenotype_cpp__



#include "Phenotype.h"



namespace BIOS {

 

/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


//


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

Phenotype::Phenotype (const PhenotypeS & PS)
{
phenotype=PS;
}
/*____________________________________________________________ */

Phenotype* Phenotype::clone()
{
return new Phenotype(*this);
}

/*____________________________________________________________ */

bool Phenotype::isMale ()
{
return phenotype.Gender==1;
}
/*____________________________________________________________ */

bool Phenotype::isFemale ()
{
return phenotype.Gender==2;
}
/*____________________________________________________________ */

bool Phenotype::isAChild ()
{
return phenotype.Father!=0 || phenotype.Mother!=0;
}
/*____________________________________________________________ */

bool Phenotype::isAParent(PhenotypeSample * sample)
{
return isAFather(sample) || isAMother(sample);
}
/*____________________________________________________________ */

bool Phenotype::isAMother(PhenotypeSample * sample)
{
return isAFounder(sample) && isFemale();
}
/*____________________________________________________________ */

bool Phenotype::isAFather(PhenotypeSample * sample)
{
return isAFounder(sample) && isMale();
}
/*____________________________________________________________ */

bool Phenotype::isUnrelated(PhenotypeSample * sample)
{
return !isAFounder(sample) && !isAChild();
}
/*____________________________________________________________ */

bool Phenotype::isARelative(PhenotypeSample * sample)
{
return isAFounder(sample) || isAChild();
}
/*____________________________________________________________ */

bool Phenotype::isAFounder(PhenotypeSample * sample)
{
// it is not a child (does not have parents) and does have offspring
return !isAChild() && hasOffspring(sample);
}
/*____________________________________________________________ */

bool Phenotype::hasOffspring(PhenotypeSample* sample)
{
Phenotype * p;
for (PhenotypeSample::iterator it=sample->begin(); it!=sample->end(); it++)
{
p=*it;
if (p->getPedigree()==this->getPedigree() && (p->getFather()==this->getCode() || p->getMother()==this->getCode()))  return true;
}
return false;
}
/*____________________________________________________________ */

IndCategory Phenotype::getIndCategory(PhenotypeSample * sample)
{
 IndCategory result;
 if (isAFather(sample)) return father;
 if (isAMother(sample)) return mother;
 if (isAChild()) return offspring;
 return unrelated;
}

/*____________________________________________________________ */

bool Phenotype::isAffected ()
{
 return phenotype.isAffected();
}
/*____________________________________________________________ */

affectation Phenotype::getAffectation ()
{
 return phenotype.getAffectation();
}

/*____________________________________________________________ */

string Phenotype::PrintPhenotype ()
{
//strcpy(line,"\0");
//cout <<"j";
//exit(0);
char line[100]="\0";
//cout <<phenotype.Code;// << phenotype.Code;// << phenotype.Father << phenotype.Mother;
//phenotype.Gender, phenotype.Affectation, phenotype.Code2;
//exit(0);
sprintf(line, "%d %d %d %d %d %d %d\0", phenotype.Pedigree, phenotype.Code, phenotype.Father, phenotype.Mother,
phenotype.Gender, phenotype.getAffectation(), phenotype.Code2);
string p=string(line);
return p;
}
/*____________________________________________________________ */

void Phenotype::SetPhenotype (const PhenotypeS & PS)
{
	phenotype=PS;
}


/*____________________________________________________________ */

bool  Phenotype::operator>(Phenotype & phe)
{
	return ((phenotype.Pedigree==phe.getPedigree() && phenotype.Code>phe.getCode()) || phenotype.Pedigree>phe.getPedigree());
}
/*____________________________________________________________ */

bool  Phenotype::operator<(Phenotype & phe)
{
	return ((phenotype.Pedigree==phe.getPedigree() && phenotype.Code<phe.getCode()) || phenotype.Pedigree<phe.getPedigree());
}
/*____________________________________________________________ */

bool  Phenotype::operator==(Phenotype & phe)
{
	return (phenotype.Pedigree==phe.getPedigree() && phenotype.Code==phe.getCode());
}

/*___________________________________________________________ */

Phenotype* Phenotype::fromString (string s)
{
	Phenotype::PhenotypeS pS;
	char pedigree[256], code[256], father[256], mother[256], code2[256];
	int pos;
//sscanf(s.c_str(), "%s%s%s%s%d%d%s", &(pS.Pedigree), &(pS.Code), &(pS.Father), &(pS.Mother), 	&(pS.Gender), &(pS.Affectation), &(pS.Code2));

sscanf(s.c_str(), "%s%s%s%s%d%d%s", &(pedigree), &(code), &(father), &(mother), 	&(pS.Gender), &(pS.Affectation), &(code2));
	
	
	
	pos=findFirstDigit(string(pedigree));
	pS.Pedigree=atoi(&pedigree[pos]);
	pos=findFirstDigit(string(code));
	pS.Code=atoi(&code[pos]);
	pos=findFirstDigit(string(father));
	pS.Father=atoi(&father[pos]);
  pos=findFirstDigit(string(mother));
	pS.Mother=atoi(&mother[pos]);
	pos=findFirstDigit(string(code2));
	pS.Code2=atoi(&code2[pos]);
	
	return (new Phenotype(pS));
}


};  // Fin del Namespace

#endif

/* Fin Fichero: Phenotype.h */
