/* File: Phenotype.h */


#ifndef __Phenotype_h__
#define __Phenotype_h__

//#include <iostream.h>
//#include <cassert>
//#include <fstream.h>
//#include "string.h"

//#include <cstdio>

#include "Exceptions.h"

//using namespace UTILS;


namespace BIOS {

  /**
      @memo Declaration of type of individual
      @doc It can have one of {0,1} values. 0 for parent, 1 for children, 2 for everybody.
      */



	 /**
      @memo typefile
      @doc It represents the type of file, phase or TDT
      */
   //  typedef enum typefile {phase=0, TDT=1};

//   const short unsigned int male=1;
//   const short unsigned int female=2;
//   const short unsigned int unaffected=0;
//   const short unsigned int affected=2;


/************************/
/* Phenotype DEFINITION */
/************************/


/**
        @memo Phenotype for SNPs

	@doc
        Definition:
        A set of Phenotype's features for each individual

        Memory space: O(SizeP), which SizeP being the number of individuals in the sample

    @author Maria M. Abad
	@version 1.0
*/

//#define everyGender -1
//#define allAffectation -1

typedef enum  {unknown=0, male=1, female=2, everyGender=3}  gender;

typedef enum  {unknownAff=0, unaffected=1, affected=2, allAffectation=3} affectation;

class PhenotypeSample;

class Phenotype {


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */



	
      /* PUBLIC FUNCTIONS (INTERFACE) */

      public:


      struct PhenotypeS {

      /**
      @memo Pedigree
      @doc It contains the family code
      */
      int Pedigree;

      /**
      @memo Code
      @doc It contains a Phenotype code
      */
      int Code;

      /**
      @memo Father
      @doc It contains the father's code of this Phenotype
      */
      int Father;

      /**
      @memo Mother
      @doc It contains the mother's code of this Phenotype
      */
      int Mother;


      /**
      @memo Gender
      @doc It contains the gender of this Phenotype
      */
      gender Gender;//male: 1; female: 2

      /**
      @memo Affectation
      @doc It contains the affectation of this Phenotype
      */

      affectation Affectation;// non affected: 1; affected: 2

     /**
      @memo Code2
      @doc It contains a second Phenotype code
      */
      int Code2;
bool isAffected(){return Affectation==2;};
affectation getAffectation(){return Affectation;};
   };  // end structure PhenotypeS

     /** @name Implementation of class Phenotype

    */
 
	  
    /**
       @memo if there is Phenotype information in the sample
       @doc  boolean, 1: yes, 0, no
    */

private:

struct PhenotypeS phenotype;

	public:
/*
         @memo Check if is a child.
         @param The pointer to the current individual's Phenotype
         @return return a boolean reporting if is a child
         Time complexity O(1)

      */

Phenotype(const PhenotypeS &phen);

Phenotype* clone();

        bool isAChild ();


	    bool isAFather (PhenotypeSample * sample);
        
		bool isAMother (PhenotypeSample * sample);
        
		bool isAParent (PhenotypeSample * sample);

		bool isARelative (PhenotypeSample * sample);

				 /**
         @memo Check if is male// 
         @param The pointer to the current individual's Phenotype
         @return return a boolean reporting if is a child
         Time complexity O(1)

      */
        bool isMale ();

								 /**
         @memo Check if is female // 
         @param The pointer to the current individual's Phenotype
         @return return a boolean reporting if is a child
         Time complexity O(1)

      */
        bool isFemale ();

								 /**
         @memo Check if is affected // affected is 2
         @param The pointer to the current individual's Phenotype
         @return return a boolean reporting if is affected
         Time complexity O(1)

      */
        bool isAffected ();

        bool isAFounder(PhenotypeSample * sample);

        bool isUnrelated(PhenotypeSample * sample);

								bool hasOffspring(PhenotypeSample * sample);

		string PrintPhenotype ();

		PhenotypeS GetPhenotype (){return phenotype;};

		 int getCode(){return phenotype.Code;};

		 int setCode(int code){phenotype.Code=code;};

		 int setCode2(int code){phenotype.Code2=code;};

		 int getCode2(){return phenotype.Code2;};

		 int getPedigree(){return phenotype.Pedigree;};

 int getFather(){return phenotype.Father;};

int getMother(){return phenotype.Mother;};

   gender getGender() {return phenotype.Gender;};

   void setGender(gender g) {phenotype.Gender=g;};

		void SetPhenotype (const PhenotypeS & PS);

		bool  operator>(Phenotype & phe);

		bool  operator<(Phenotype & phe);

		bool  operator==(Phenotype & phe);

 IndCategory getIndCategory(PhenotypeSample * sample);

   affectation getAffectation(); //{return phenotype.getAffectation();};
		 
int setAffectation(affectation aff){phenotype.Affectation=aff;};

//Phenotype(){line=NULL;};
~Phenotype(){};

static Phenotype* fromString(string s);

};  // End of class Phenotype

     ostream& operator<<(ostream& out, Phenotype& phenotype)
       {
       out <<phenotype.PrintPhenotype();
							return out;
                                                         }
 

};  // Fin del Namespace

#endif

/* Fin Fichero: Phenotype.h */
