/* File: PhenotypeSample.h */


#ifndef __PhenotypeSample_h__
#define __PhenotypeSample_h__






//using namespace UTILS;


namespace BIOS {

  /**
      @memo Declaration of type of individual
      @doc It can have one of {0,1} values. 0 for parent, 1 for children, 2 for everybody.
      */



	 /**
      @memo typefile
      @doc It represents the type of file, phase or TDT
      */


/************************/
/* PhenotypeSample DEFINITION */
/************************/


/**
        @memo PhenotypeSample for SNPs

	@doc
        Definition:
        A set of PhenotypeSample's features for each individual

        Memory space: O(SizeP), which SizeP being the number of individuals in the sample

    @author Maria M. Abad
	@version 1.0
*/

/*________________________________________________________ */
/*
template < >  Container<vector, Phenotype*>::~Container<vector, Phenotype*>()
{
//cout << "before\n";
//empty();
};
*/

//Container<vector, Phenotype>* nullPhenotypeSample;

	
	  
	class PhenotypeSample: public Container<vector<Phenotype*>, Phenotype*>  {

  protected:
    /** @name Implementation of class PhenotypeSample
        @memo Private part.
    */
 
	  
    /**
       @memo if there is PhenotypeSample information in the sample
       @doc  boolean, 1: yes, 0, no
    */


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

/////////////////////////////////////////////

//void ReadPhenotype (ifstream*  source, SNPPos TotalSNPs, unsigned short int ReduceSample, unsigned int SizeP);

/////////////////////////
//Phenotype ReadElement (ifstream* source, char* tokens);


      /* PUBLIC FUNCTIONS (INTERFACE) */

      public:

//	 PhenotypeSample();
      /**
         @memo Destructor
	 @doc
           Deallocate memory used by PhenotypeSample.
           Time complexity O(1).

      */
      ~PhenotypeSample (){};
//////////////////////////////////////////////


PhenotypeSample():Container<vector<Phenotype*>, Phenotype*>(){outputSeparator='\n';};

PhenotypeSample(PhenotypeSample & source); //:Container<vector, Phenotype*>(source); //{outputSeparator=source.outputSeparator;};

PhenotypeSample* clone();

PhenotypeSample* emptyCopy();

//PhenotypeSample(Container<vector, Phenotype> & source):Container<vector, Phenotype>(source){};


  /////////////////////////////////////////////
      /**
         @memo Constructor from input buffer
         @param file: file position in which is the PhenotypeSample who will be copy
         @param origen: PhenotypeSample to read
         @doc
           Read an PhenotypeSample
           Time complexity in time O(1).
        */
		  PhenotypeSample (char* filename);//:Container<vector, Phenotype>(filename){}; //, const unsigned int InputSizeP, const SNPPos TotalSNPs, unsigned short int ReduceSample);

	    /////////////////////////////////////////////
      /**
         @memo Constructor from input buffer
         @param file: file position in which is the PhenotypeSample who will be copy
         @param origen: PhenotypeSample to read
         @doc
           Read an PhenotypeSample
           Time complexity in time O(1).
        */
//	  PhenotypeSample (char* filename);


     // PhenotypeSample (const PhenotypeSample & origen, istream* file, const typefile tf);

///////////////////////////////////////////////////
      /**
         @memo Assignation
         @param ind: PhenotypeSample to copy.
         @return Reference to the receptor PhenotypeSample.
	 @doc
           Copy the PhenotypeSample in the receptor PhenotypeSample.
           Time complexity O(1).

      */
      PhenotypeSample& operator=(const PhenotypeSample & source);
////////////////////////////////////////////////////
   
      /**
         @memo Is equal
         @param g: PhenotypeSample to compare with.
	 @return
           Return true if the SNP is the same, false otherwise.
         @doc Time complexity O(1).

      */
      bool operator==(const PhenotypeSample & source);
      /**
         @memo Is different
         @param g: PhenotypeSample to cmpare with.
	 @return
           Return true if the SNP is different, false otherwise.
         @doc Time complexity O(1).

      */
      bool operator!=(const PhenotypeSample & source);

 	
	 iterator GetRelative(IndCategory ic, iterator const i);

		/**
         @memo Obtain the position of the PhenotypeSample of the father.
         @param The pointer to the current individual's PhenotypeSample
         @return return the position for the father
         Time complexity O(1)
		**/


	 iterator GetFather(iterator const i);

	
		/**
         @memo Obtain the position of the PhenotypeSample of the mother.
         @param The pointer to the current individual's PhenotypeSample
         @return return the position for the mother
         Time complexity O(1)
		**/

	iterator GetMother(iterator const i);

				/**
         @memo Obtain the position of the PhenotypeSample of his/her first couple.
         @param The pointer to the current individual's PhenotypeSample
         @return return the position for the mother
         Time complexity O(1)
		**/

	iterator GetPartner(iterator const i, iterator const pChild);

	iterator GetPartner(iterator const p);


				/**
         @memo Obtain the next sib with common parent
         @param The pointer to the current individual's PhenotypeSample
         @return return the position for the next sib
         Time complexity O(1)
		**/

	iterator getNextSib(iterator const i, iterator const parent);

       
		   /**
         @memo Obtain the first child of a parent.
         @param The parent position
         @return return the position of the child
         Time complexity O(TotalSize)
		*/
	
	iterator getFirstChild(iterator const i);

    
		   /**
         @memo Obtain the number of offspring in the sample 
         @return the size of a sample
         @doc Return the number of offpring phenotypes in the sample. 
         Time complexity O(Size)

      */
    IndPos GetTotalOffSpring ();          

  		   /**
         @memo Obtain the number of individual of ic category in the sample 
         @return the size of a sample
         @doc Return the number of offpring phenotypes in the sample. 
         Time complexity O(Size)

      */
    IndPos GetTotalIndividuals (IndCategory inc, int gender=everyGender, int affectation=allAffectation);          



		  /**
         @memo Print the PhenotypeSample for an individual.
         @param Position: Position of this individual in the sample
         Time complexity O(1)

      */
	
	string PrintPhenotype (iterator p);

	
	void SetMarked (bool *Marked, IndCategory ic, int gender=everyGender, int affectation=allAffectation);

	
IndPos getTotalByAffectation (int affectation);
IndPos getTotalByAffectationAndIC (int affectation, IndCategory ic);

	void  PrintPhenotypes ();

//PhenotypeSample* copyElementsWithPositionsIn(intList* positions, bool inThis=true);
PhenotypeSample* permute();

void setAffectationRandomly();

bool isATrioDataset();

};  // End of class PhenotypeSample

/******************************************************************/
/*
template <> Container<vector, Phenotype>::iterator Container<vector, Phenotype>::removeNode(Container<vector, Phenotype>::iterator it) 
{
//cout << "insiderem\n";
return this->getNext(it);
//zap(this->getElement(it));
//return it2; //this->erase(it);
};
*/

typedef PhenotypeSample::iterator PhenotypePointer;

//void addPartner (PhenotypeSample::iterator IndPhenotype, PhenotypeSample::iterator partnerPhenotype);


  /*______________________________________________________*/
/*
template <> ostream& operator<<(ostream& out, Container<vector, Phenotype>& l)
{
    for (Container<vector, Phenotype>::iterator p = l.begin(); p != l.end(); p++)
{
       out << l.getElement(p); 
   if (l.size()>1) if (p!= l.end()-1 && l.outputSeparator!='\0') out <<l.outputSeparator; 
//if (p==l.end()-1) out <<")";
}
return out;
}
*/



};  // Fin del Namespace

#endif

/* Fin Fichero: PhenotypeSample.h */
