#ifndef __RandomizationDistribution_h__
#define __RandomizationDistribution_h__

namespace BIOS {

	class RandomizationDistribution
	{
		public:
			doubleList* values; // List of values with repetitions
//			std::vector<double>* values; // List of values with repetitions						
			doubleList* collapsed_values; // List of values without repeated values
			doubleList* collapsed_freqs; // Frecuency of each collapsed value

			bool sorted;

			RandomizationDistribution();
			~RandomizationDistribution();

			void collapse();

			void sort();

			void getFreqTable();
			double getPvalue(double z);

			friend ostream& operator<<(ostream& output, const RandomizationDistribution& rd){

				if ( rd.values != NULL){
					for(int i=0; i< rd.values->size(); i++)
						output << (*rd.values)[i] << " " ;				
				output << endl;
				}
			
/*
				if ( rd.collapsed_values != NULL){
					for(int i=0; i< rd.collapsed_values->size(); i++)						
						//output << (*rd.collapsed_values)[i]  << "[" << (*rd.collapsed_freqs)[i] <<"]" << " " ;
						output << (*rd.collapsed_values)[i]  << "\t" << (*rd.collapsed_freqs)[i]  << endl;

				output << endl;
				}
*/
					
			};

			

	};

};


#endif
